/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.zzc;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="AssetCreator")
public class Asset
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<Asset> CREATOR;
    @SafeParcelable.Field(id=2, getter="getData")
    @Nullable
    private byte[] zzc;
    @SafeParcelable.Field(id=3, getter="getDigest")
    @Nullable
    private String zzd;
    @SafeParcelable.Field(id=4)
    @RecentlyNullable
    public ParcelFileDescriptor zza;
    @SafeParcelable.Field(id=5)
    @RecentlyNullable
    public Uri zzb;

    @SafeParcelable.Constructor
    Asset(@SafeParcelable.Param(id=2) @Nullable byte[] byArray, @SafeParcelable.Param(id=3) @Nullable String string, @SafeParcelable.Param(id=4) @Nullable ParcelFileDescriptor parcelFileDescriptor, @SafeParcelable.Param(id=5) @Nullable Uri uri) {
        this.zzc = byArray;
        this.zzd = string;
        this.zza = parcelFileDescriptor;
        this.zzb = uri;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel dest, int flags) {
        int n;
        void var1_1;
        Preconditions.checkNotNull((Object)dest);
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)2, (byte[])this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getDigest(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.zza, (int)(n |= 1), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.zzb, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    @RecentlyNonNull
    public static Asset createFromRef(@RecentlyNonNull String digest) {
        String string;
        Preconditions.checkNotNull((Object)digest);
        Asset asset = new Asset(null, string, null, null);
        return asset;
    }

    @VisibleForTesting
    @RecentlyNonNull
    public static Asset createFromBytes(@RecentlyNonNull byte[] assetData) {
        byte[] byArray;
        Preconditions.checkNotNull((Object)assetData);
        Asset asset = new Asset(byArray, null, null, null);
        return asset;
    }

    @VisibleForTesting
    @RecentlyNonNull
    public static Asset createFromFd(@RecentlyNonNull ParcelFileDescriptor fd) {
        ParcelFileDescriptor parcelFileDescriptor;
        Preconditions.checkNotNull((Object)fd);
        Asset asset = new Asset(null, null, parcelFileDescriptor, null);
        return asset;
    }

    @VisibleForTesting
    @RecentlyNonNull
    public static Asset createFromUri(@RecentlyNonNull Uri uri) {
        Uri uri2;
        Preconditions.checkNotNull((Object)uri);
        Asset asset = new Asset(null, null, null, uri2);
        return asset;
    }

    @RecentlyNullable
    public String getDigest() {
        return this.zzd;
    }

    @RecentlyNullable
    public ParcelFileDescriptor getFd() {
        return this.zza;
    }

    @RecentlyNullable
    public Uri getUri() {
        return this.zzb;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzc, this.zzd, this.zza, this.zzb};
        return Arrays.deepHashCode(objectArray);
    }

    public boolean equals(@Nullable Object o) {
        Asset asset;
        if (this == asset) {
            return true;
        }
        if (!(asset instanceof Asset)) {
            return false;
        }
        asset = asset;
        return Arrays.equals(this.zzc, asset.zzc) && Objects.equal((Object)this.zzd, (Object)asset.zzd) && Objects.equal((Object)this.zza, (Object)asset.zza) && Objects.equal((Object)this.zzb, (Object)asset.zzb);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Asset[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzd == null) {
            stringBuilder.append(", nodigest");
        } else {
            stringBuilder.append(", ");
            stringBuilder.append(this.zzd);
        }
        if (this.zzc != null) {
            stringBuilder.append(", size=");
            stringBuilder.append(((byte[])Preconditions.checkNotNull((Object)this.zzc)).length);
        }
        if (this.zza != null) {
            stringBuilder.append(", fd=");
            stringBuilder.append(this.zza);
        }
        if (this.zzb != null) {
            stringBuilder.append(", uri=");
            stringBuilder.append(this.zzb);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zzc zzc2;
        CREATOR = zzc2 = new zzc();
    }

    @RecentlyNullable
    public final byte[] zza() {
        return this.zzc;
    }
}

