/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Wearable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class ChannelClient
extends GoogleApi<Wearable.WearableOptions> {
    @RecentlyNonNull
    public static final String ACTION_CHANNEL_EVENT = "com.google.android.gms.wearable.CHANNEL_EVENT";

    public ChannelClient(@RecentlyNonNull Context context, @RecentlyNonNull GoogleApi.Settings settings) {
        super(context, Wearable.API, (Api.ApiOptions)Wearable.WearableOptions.zza, settings);
    }

    public ChannelClient(@RecentlyNonNull Activity activity, @RecentlyNonNull GoogleApi.Settings settings) {
        super(activity, Wearable.API, (Api.ApiOptions)Wearable.WearableOptions.zza, settings);
    }

    @RecentlyNonNull
    public abstract Task<Channel> openChannel(@RecentlyNonNull String var1, @RecentlyNonNull String var2);

    @RecentlyNonNull
    public abstract Task<Void> registerChannelCallback(@RecentlyNonNull ChannelCallback var1);

    @RecentlyNonNull
    public abstract Task<Boolean> unregisterChannelCallback(@RecentlyNonNull ChannelCallback var1);

    @RecentlyNonNull
    public abstract Task<Void> close(@RecentlyNonNull Channel var1);

    @RecentlyNonNull
    public abstract Task<Void> close(@RecentlyNonNull Channel var1, int var2);

    @RecentlyNonNull
    public abstract Task<InputStream> getInputStream(@RecentlyNonNull Channel var1);

    @RecentlyNonNull
    public abstract Task<OutputStream> getOutputStream(@RecentlyNonNull Channel var1);

    @RecentlyNonNull
    public abstract Task<Void> receiveFile(@RecentlyNonNull Channel var1, @RecentlyNonNull Uri var2, boolean var3);

    @RecentlyNonNull
    public abstract Task<Void> sendFile(@RecentlyNonNull Channel var1, @RecentlyNonNull Uri var2);

    @RecentlyNonNull
    public abstract Task<Void> sendFile(@RecentlyNonNull Channel var1, @RecentlyNonNull Uri var2, long var3, long var5);

    @RecentlyNonNull
    public abstract Task<Void> registerChannelCallback(@RecentlyNonNull Channel var1, @RecentlyNonNull ChannelCallback var2);

    @RecentlyNonNull
    public abstract Task<Boolean> unregisterChannelCallback(@RecentlyNonNull Channel var1, @RecentlyNonNull ChannelCallback var2);

    public static interface Channel
    extends Parcelable {
        @RecentlyNonNull
        public String getNodeId();

        @RecentlyNonNull
        public String getPath();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloseReason {
    }

    public static abstract class ChannelCallback {
        public static final int CLOSE_REASON_NORMAL = 0;
        public static final int CLOSE_REASON_DISCONNECTED = 1;
        public static final int CLOSE_REASON_REMOTE_CLOSE = 2;
        public static final int CLOSE_REASON_LOCAL_CLOSE = 3;

        public void onChannelOpened(@RecentlyNonNull Channel channel) {
        }

        public void onChannelClosed(@RecentlyNonNull Channel channel, int n, int n2) {
        }

        public void onInputClosed(@RecentlyNonNull Channel channel, int n, int n2) {
        }

        public void onOutputClosed(@RecentlyNonNull Channel channel, int n, int n2) {
        }
    }
}

