/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.Wearable;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class DataClient
extends GoogleApi<Wearable.WearableOptions> {
    @RecentlyNonNull
    public static final String ACTION_DATA_CHANGED = "com.google.android.gms.wearable.DATA_CHANGED";
    public static final int FILTER_LITERAL = 0;
    public static final int FILTER_PREFIX = 1;

    public DataClient(@RecentlyNonNull Context context, @RecentlyNonNull GoogleApi.Settings settings) {
        super(context, Wearable.API, (Api.ApiOptions)Wearable.WearableOptions.zza, settings);
    }

    public DataClient(@RecentlyNonNull Activity activity, @RecentlyNonNull GoogleApi.Settings settings) {
        super(activity, Wearable.API, (Api.ApiOptions)Wearable.WearableOptions.zza, settings);
    }

    @RecentlyNonNull
    public abstract Task<DataItem> putDataItem(@RecentlyNonNull PutDataRequest var1);

    @RecentlyNonNull
    public abstract Task<DataItem> getDataItem(@RecentlyNonNull Uri var1);

    @RecentlyNonNull
    public abstract Task<DataItemBuffer> getDataItems();

    @RecentlyNonNull
    public abstract Task<DataItemBuffer> getDataItems(@RecentlyNonNull Uri var1);

    @RecentlyNonNull
    public abstract Task<DataItemBuffer> getDataItems(@RecentlyNonNull Uri var1, int var2);

    @RecentlyNonNull
    public abstract Task<Integer> deleteDataItems(@RecentlyNonNull Uri var1);

    @RecentlyNonNull
    public abstract Task<Integer> deleteDataItems(@RecentlyNonNull Uri var1, int var2);

    @RecentlyNonNull
    public abstract Task<GetFdForAssetResponse> getFdForAsset(@RecentlyNonNull Asset var1);

    @RecentlyNonNull
    public abstract Task<GetFdForAssetResponse> getFdForAsset(@RecentlyNonNull DataItemAsset var1);

    @RecentlyNonNull
    public abstract Task<Void> addListener(@RecentlyNonNull OnDataChangedListener var1);

    @RecentlyNonNull
    public abstract Task<Void> addListener(@RecentlyNonNull OnDataChangedListener var1, @RecentlyNonNull Uri var2, int var3);

    @RecentlyNonNull
    public abstract Task<Boolean> removeListener(@RecentlyNonNull OnDataChangedListener var1);

    public static interface OnDataChangedListener
    extends DataApi.DataListener {
        @Override
        public void onDataChanged(@RecentlyNonNull DataEventBuffer var1);
    }

    public static abstract class GetFdForAssetResponse
    implements Releasable {
        @RecentlyNonNull
        public abstract ParcelFileDescriptor getFdForAsset();

        @RecentlyNonNull
        public abstract InputStream getInputStream();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FilterType {
    }
}

