/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.wearable.zzcc;
import com.google.android.gms.internal.wearable.zzj;
import com.google.android.gms.internal.wearable.zzk;
import com.google.android.gms.internal.wearable.zzw;
import com.google.android.gms.wearable.Asset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

@VisibleForTesting
public class DataMap {
    @RecentlyNonNull
    public static final String TAG = "DataMap";
    private final HashMap<String, Object> zza;

    public DataMap() {
        HashMap hashMap = new HashMap();
        this.zza = hashMap;
    }

    @RecentlyNonNull
    public static DataMap fromBundle(@RecentlyNonNull Bundle bundle) {
        Bundle bundle2;
        bundle.setClassLoader((ClassLoader)Preconditions.checkNotNull((Object)Asset.class.getClassLoader()));
        DataMap dataMap = new DataMap();
        block7: for (String string : bundle2.keySet()) {
            Object object = bundle2.get(string);
            if (object instanceof String) {
                dataMap.putString(string, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                dataMap.putInt(string, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                dataMap.putLong(string, (Long)object);
                continue;
            }
            if (object instanceof Double) {
                dataMap.putDouble(string, (Double)object);
                continue;
            }
            if (object instanceof Float) {
                dataMap.putFloat(string, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Boolean) {
                dataMap.putBoolean(string, (Boolean)object);
                continue;
            }
            if (object instanceof Byte) {
                dataMap.putByte(string, (Byte)object);
                continue;
            }
            if (object instanceof byte[]) {
                dataMap.putByteArray(string, (byte[])object);
                continue;
            }
            if (object instanceof String[]) {
                dataMap.putStringArray(string, (String[])object);
                continue;
            }
            if (object instanceof long[]) {
                dataMap.putLongArray(string, (long[])object);
                continue;
            }
            if (object instanceof float[]) {
                dataMap.putFloatArray(string, (float[])object);
                continue;
            }
            if (object instanceof Asset) {
                dataMap.putAsset(string, (Asset)((Object)object));
                continue;
            }
            if (object instanceof Bundle) {
                dataMap.putDataMap(string, DataMap.fromBundle((Bundle)object));
                continue;
            }
            if (!(object instanceof ArrayList)) continue;
            object = (ArrayList)object;
            switch (DataMap.zza(object)) {
                default: {
                    continue block7;
                }
                case 5: {
                    dataMap.putDataMapArrayList(string, DataMap.arrayListFromBundleArrayList((ArrayList<Bundle>)object));
                    continue block7;
                }
                case 3: {
                    dataMap.putStringArrayList(string, (ArrayList<String>)object);
                    continue block7;
                }
                case 2: {
                    dataMap.putIntegerArrayList(string, (ArrayList<Integer>)object);
                    continue block7;
                }
                case 1: {
                    dataMap.putStringArrayList(string, (ArrayList<String>)object);
                    continue block7;
                }
                case 0: 
            }
            dataMap.putStringArrayList(string, (ArrayList<String>)object);
        }
        return dataMap;
    }

    @RecentlyNonNull
    public static DataMap fromByteArray(@RecentlyNonNull byte[] bytes) {
        Object object;
        try {
            object = zzw.zzb(object);
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            zzj zzj2 = new zzj((zzw)object, arrayList);
            object = zzk.zzb(zzj2);
        }
        catch (zzcc zzcc2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unable to convert data", zzcc2);
            throw illegalArgumentException;
        }
        return object;
    }

    @RecentlyNonNull
    public static ArrayList<DataMap> arrayListFromBundleArrayList(@RecentlyNonNull ArrayList<Bundle> bundleArrayList) {
        ArrayList<Bundle> arrayList;
        ArrayList<DataMap> arrayList2 = new ArrayList<DataMap>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add(DataMap.fromBundle((Bundle)arrayList.get(i)));
        }
        return arrayList2;
    }

    @RecentlyNonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        block7: for (String string : this.zza.keySet()) {
            Object object = this.zza.get(string);
            if (object instanceof String) {
                bundle.putString(string, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                bundle.putInt(string, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                bundle.putLong(string, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                bundle.putDouble(string, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof Float) {
                bundle.putFloat(string, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Boolean) {
                bundle.putBoolean(string, ((Boolean)object).booleanValue());
                continue;
            }
            if (object instanceof Byte) {
                bundle.putByte(string, ((Byte)object).byteValue());
                continue;
            }
            if (object instanceof byte[]) {
                bundle.putByteArray(string, (byte[])object);
                continue;
            }
            if (object instanceof String[]) {
                bundle.putStringArray(string, (String[])object);
                continue;
            }
            if (object instanceof long[]) {
                bundle.putLongArray(string, (long[])object);
                continue;
            }
            if (object instanceof float[]) {
                bundle.putFloatArray(string, (float[])object);
                continue;
            }
            if (object instanceof Asset) {
                bundle.putParcelable(string, (Parcelable)((Asset)((Object)object)));
                continue;
            }
            if (object instanceof DataMap) {
                bundle.putParcelable(string, (Parcelable)((DataMap)object).toBundle());
                continue;
            }
            if (!(object instanceof ArrayList)) continue;
            ArrayList arrayList = (ArrayList)object;
            switch (DataMap.zza(arrayList)) {
                default: {
                    continue block7;
                }
                case 4: {
                    ArrayList<Bundle> arrayList2 = new ArrayList<Bundle>();
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        arrayList2.add(((DataMap)arrayList.get(i)).toBundle());
                    }
                    bundle.putParcelableArrayList(string, arrayList2);
                    continue block7;
                }
                case 3: {
                    bundle.putStringArrayList(string, arrayList);
                    continue block7;
                }
                case 2: {
                    bundle.putIntegerArrayList(string, arrayList);
                    continue block7;
                }
                case 1: {
                    bundle.putStringArrayList(string, arrayList);
                    continue block7;
                }
                case 0: 
            }
            bundle.putStringArrayList(string, arrayList);
        }
        return bundle;
    }

    @RecentlyNonNull
    public byte[] toByteArray() {
        return zzk.zza((DataMap)this).zza.zzI();
    }

    public int size() {
        return this.zza.size();
    }

    public boolean isEmpty() {
        return this.zza.isEmpty();
    }

    public void clear() {
        this.zza.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(@RecentlyNonNull String key) {
        void var1_1;
        return this.zza.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public <T> T get(@RecentlyNonNull String key) {
        void var1_1;
        return (T)this.zza.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public Object remove(@RecentlyNonNull String key) {
        void var1_1;
        return this.zza.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void putAll(@RecentlyNonNull DataMap dataMap) {
        for (String string : dataMap.keySet()) {
            void var1_1;
            this.zza.put(string, var1_1.get(string));
        }
    }

    @RecentlyNonNull
    public Set<String> keySet() {
        return this.zza.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public void putBoolean(@RecentlyNonNull String key, boolean value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putByte(@RecentlyNonNull String key, byte value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, (byte)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putInt(@RecentlyNonNull String key, int value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putLong(@RecentlyNonNull String key, long value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putFloat(@RecentlyNonNull String key, float value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, Float.valueOf((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void putDouble(@RecentlyNonNull String key, double value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putString(@RecentlyNonNull String key, @RecentlyNonNull String value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putAsset(@RecentlyNonNull String key, @RecentlyNonNull Asset value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putDataMap(@RecentlyNonNull String key, @RecentlyNonNull DataMap value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putDataMapArrayList(@RecentlyNonNull String key, @RecentlyNonNull ArrayList<DataMap> value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putIntegerArrayList(@RecentlyNonNull String key, @RecentlyNonNull ArrayList<Integer> value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putStringArrayList(@RecentlyNonNull String key, @RecentlyNonNull ArrayList<String> value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putByteArray(@RecentlyNonNull String key, @RecentlyNonNull byte[] value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putLongArray(@RecentlyNonNull String key, @RecentlyNonNull long[] value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putFloatArray(@RecentlyNonNull String key, @RecentlyNonNull float[] value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void putStringArray(@RecentlyNonNull String key, @RecentlyNonNull String[] value) {
        void var2_2;
        void var1_1;
        this.zza.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(@RecentlyNonNull String key) {
        void var1_1;
        return this.getBoolean((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(@RecentlyNonNull String key, boolean defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (boolean)var2_2;
        }
        try {
            boolean bl = (Boolean)this_;
            return bl;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Boolean", (boolean)var2_2, classCastException);
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(@RecentlyNonNull String key) {
        void var1_1;
        return this.getByte((String)var1_1, (byte)0);
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(@RecentlyNonNull String key, byte defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (byte)var2_2;
        }
        try {
            byte by = (Byte)this_;
            return by;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Byte", (byte)var2_2, classCastException);
            return (byte)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(@RecentlyNonNull String key) {
        void var1_1;
        return this.getInt((String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(@RecentlyNonNull String key, int defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (int)var2_2;
        }
        try {
            int n = (Integer)this_;
            return n;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Integer", "<null>", classCastException);
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(@RecentlyNonNull String key) {
        void var1_1;
        return this.getLong((String)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(@RecentlyNonNull String key, long defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (long)var2_2;
        }
        try {
            long l = (Long)this_;
            return l;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "long", "<null>", classCastException);
            return (long)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(@RecentlyNonNull String key) {
        void var1_1;
        return this.getFloat((String)var1_1, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(@RecentlyNonNull String key, float defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (float)var2_2;
        }
        try {
            float f = ((Float)this_).floatValue();
            return f;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Float", Float.valueOf((float)var2_2), classCastException);
            return (float)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(@RecentlyNonNull String key) {
        void var1_1;
        return this.getDouble((String)var1_1, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(@RecentlyNonNull String key, double defaultValue) {
        void var2_2;
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return (double)var2_2;
        }
        try {
            double d = (Double)this_;
            return d;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Double", (double)var2_2, classCastException);
            return (double)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public String getString(@RecentlyNonNull String key, @RecentlyNonNull String defaultValue) {
        void var1_1;
        if ((this = ((DataMap)this).getString((String)var1_1)) == null) {
            void var2_2;
            return var2_2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public String getString(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            String string = (String)this_;
            return string;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "String", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public Asset getAsset(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            Asset asset = (Asset)((Object)this_);
            return asset;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "Asset", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public DataMap getDataMap(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            DataMap dataMap = (DataMap)this_;
            return dataMap;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, TAG, "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public ArrayList<Integer> getIntegerArrayList(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)this_;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "ArrayList<Integer>", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public ArrayList<String> getStringArrayList(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)this_;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "ArrayList<String>", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public ArrayList<DataMap> getDataMapArrayList(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            ArrayList arrayList = (ArrayList)this_;
            return arrayList;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "ArrayList<DataMap>", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public byte[] getByteArray(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            byte[] byArray = (byte[])this_;
            return byArray;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "byte[]", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public long[] getLongArray(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            long[] lArray = (long[])this_;
            return lArray;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "long[]", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public float[] getFloatArray(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            float[] fArray = (float[])this_;
            return fArray;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "float[]", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNullable
    public String[] getStringArray(@RecentlyNonNull String key) {
        void var1_1;
        Object this_ = ((DataMap)this_).zza.get(var1_1);
        if (this_ == null) {
            return null;
        }
        try {
            String[] stringArray = (String[])this_;
            return stringArray;
        }
        catch (ClassCastException classCastException) {
            DataMap.zzb((String)var1_1, this_, "String[]", "<null>", classCastException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object o) {
        void var1_2;
        if (!(o instanceof DataMap)) {
            return false;
        }
        DataMap dataMap = (DataMap)var1_2;
        if (this.size() != dataMap.size()) {
            return false;
        }
        Iterator<String> iterator = this.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return true;
            }
            String string = iterator.next();
            Object object = this.get(string);
            Object t = dataMap.get(string);
            if (object instanceof Asset) {
                void var1_7;
                if (!(t instanceof Asset)) {
                    return false;
                }
                object = (Asset)((Object)object);
                Asset asset = (Asset)((Object)t);
                if (object == null || asset == null) {
                    if (object == asset) continue;
                    return false;
                }
                if (!TextUtils.isEmpty((CharSequence)((Asset)((Object)object)).getDigest())) {
                    boolean bl = ((String)Preconditions.checkNotNull((Object)((Asset)((Object)object)).getDigest())).equals(asset.getDigest());
                } else {
                    boolean bl = Arrays.equals(((Asset)((Object)object)).zza(), asset.zza());
                }
                if (var1_7 != false) continue;
                return false;
            }
            if (object instanceof String[]) {
                if (!(t instanceof String[])) {
                    return false;
                }
                if (Arrays.equals((String[])object, (String[])t)) continue;
                return false;
            }
            if (object instanceof long[]) {
                if (!(t instanceof long[])) {
                    return false;
                }
                if (Arrays.equals((long[])object, (long[])t)) continue;
                return false;
            }
            if (object instanceof float[]) {
                if (!(t instanceof float[])) {
                    return false;
                }
                if (Arrays.equals((float[])object, (float[])t)) continue;
                return false;
            }
            if (object instanceof byte[]) {
                if (!(t instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])object, (byte[])t)) continue;
                return false;
            }
            if (object == null || t == null) {
                if (object == t) return true;
                return false;
            }
            if (!object.equals(t)) break;
        }
        return false;
    }

    public int hashCode() {
        return this.zza.hashCode() * 29;
    }

    @RecentlyNonNull
    public String toString() {
        return this.zza.toString();
    }

    private static int zza(ArrayList<?> arrayList) {
        if (arrayList.isEmpty()) {
            return 0;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e == null) continue;
            if (e instanceof Integer) {
                return 2;
            }
            if (e instanceof String) {
                return 3;
            }
            if (e instanceof DataMap) {
                return 4;
            }
            if (!(e instanceof Bundle)) {
                continue;
            }
            return 5;
        }
        return 1;
    }

    private static final void zzb(String string, Object object, String string2, Object object2, ClassCastException classCastException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key ");
        stringBuilder.append(string);
        stringBuilder.append(" expected ");
        stringBuilder.append(string2);
        stringBuilder.append(" but value was a ");
        stringBuilder.append(object.getClass().getName());
        stringBuilder.append(".  The default value ");
        stringBuilder.append(object2);
        stringBuilder.append(" was returned.");
        Log.w((String)TAG, (String)stringBuilder.toString());
        Log.w((String)TAG, (String)"Attempt to cast generated internal exception:", (Throwable)classCastException);
    }
}

