/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.wearable.zzj;
import com.google.android.gms.internal.wearable.zzk;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

@VisibleForTesting
public class PutDataMapRequest {
    private final PutDataRequest zza;
    private final DataMap zzb;

    private PutDataMapRequest(PutDataRequest object, @Nullable DataMap dataMap) {
        this.zza = object;
        this.zzb = object;
        if (dataMap != null) {
            this.zzb.putAll(dataMap);
            return;
        }
    }

    @RecentlyNonNull
    public static PutDataMapRequest createFromDataMapItem(@RecentlyNonNull DataMapItem source) {
        DataMapItem dataMapItem;
        Asserts.checkNotNull((Object)source, (Object)"source must not be null");
        PutDataMapRequest putDataMapRequest = new PutDataMapRequest(PutDataRequest.zza(dataMapItem.getUri()), dataMapItem.getDataMap());
        return putDataMapRequest;
    }

    @RecentlyNonNull
    public static PutDataMapRequest createWithAutoAppendedId(@RecentlyNonNull String pathPrefix) {
        String string;
        Asserts.checkNotNull((Object)pathPrefix, (Object)"pathPrefix must not be null");
        PutDataMapRequest putDataMapRequest = new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(string), null);
        return putDataMapRequest;
    }

    @RecentlyNonNull
    public static PutDataMapRequest create(@RecentlyNonNull String path) {
        String string;
        Asserts.checkNotNull((Object)path, (Object)"path must not be null");
        PutDataMapRequest putDataMapRequest = new PutDataMapRequest(PutDataRequest.create(string), null);
        return putDataMapRequest;
    }

    @RecentlyNonNull
    public Uri getUri() {
        return this.zza.getUri();
    }

    @RecentlyNonNull
    public DataMap getDataMap() {
        return this.zzb;
    }

    @RecentlyNonNull
    public PutDataMapRequest setUrgent() {
        this.zza.setUrgent();
        return this;
    }

    public boolean isUrgent() {
        return this.zza.isUrgent();
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public PutDataRequest asPutDataRequest() {
        Object object = zzk.zza(((PutDataMapRequest)this_).zzb);
        ((PutDataMapRequest)this_).zza.setData(((zzj)object).zza.zzI());
        int n = ((zzj)object).zzb.size();
        int n2 = 0;
        while (n2 < n) {
            Object this_;
            String string = Integer.toString(n2);
            Asset asset = ((zzj)object).zzb.get(n2);
            if (string == null) {
                String string2 = String.valueOf((Object)asset);
                object = String.valueOf(string2);
                int n3 = ((String)object).length();
                StringBuilder stringBuilder = new StringBuilder(n3 + 26);
                stringBuilder.append("asset key cannot be null: ");
                stringBuilder.append(string2);
                this_ = new IllegalStateException(stringBuilder.toString());
                throw this_;
            }
            if (asset == null) {
                this_ = "asset cannot be null: key=";
                this_ = string.length() != 0 ? ((String)this_).concat(string) : (object = new String((String)this_));
                IllegalStateException illegalStateException = new IllegalStateException((String)this_);
                throw illegalStateException;
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                String string3 = String.valueOf((Object)asset);
                int n4 = string.length();
                String string4 = String.valueOf(string3);
                int n5 = string4.length();
                StringBuilder stringBuilder = new StringBuilder(n4 + 33 + n5);
                stringBuilder.append("asPutDataRequest: adding asset: ");
                stringBuilder.append(string);
                stringBuilder.append(" ");
                stringBuilder.append(string3);
                Log.d((String)"DataMap", (String)stringBuilder.toString());
            }
            ((PutDataMapRequest)this_).zza.putAsset(string, asset);
            ++n2;
        }
        return ((PutDataMapRequest)this_).zza;
    }
}

