/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.zzg;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="PutDataRequestCreator")
public class PutDataRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final String WEAR_URI_SCHEME = "wear";
    @RecentlyNonNull
    public static final Parcelable.Creator<PutDataRequest> CREATOR;
    private static final long zza;
    private static final Random zzb;
    @SafeParcelable.Field(id=2, getter="getUri")
    private final Uri zzc;
    @SafeParcelable.Field(id=4, getter="getAssetsInternal")
    private final Bundle zzd;
    @SafeParcelable.Field(id=5, getter="getData")
    @Nullable
    private byte[] zze;
    @SafeParcelable.Field(id=6, getter="getSyncDeadline")
    private long zzf;

    @SafeParcelable.Constructor
    PutDataRequest(@SafeParcelable.Param(id=2) Uri uri, @SafeParcelable.Param(id=4) Bundle bundle, @SafeParcelable.Param(id=5) @Nullable byte[] byArray, @SafeParcelable.Param(id=6) long l) {
        this.zzc = uri;
        this.zzd = bundle;
        this.zzd.setClassLoader((ClassLoader)Preconditions.checkNotNull((Object)DataItemAssetParcelable.class.getClassLoader()));
        this.zze = byArray;
        this.zzf = l;
    }

    private PutDataRequest(Uri uri) {
        Bundle bundle = new Bundle();
        this(uri, bundle, null, zza);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)dest, (Object)"dest must not be null");
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)4, (Bundle)this.zzd, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)5, (byte[])this.getData(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.zzf);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public static PutDataRequest createFromDataItem(@RecentlyNonNull DataItem source) {
        Object object;
        Preconditions.checkNotNull((Object)source, (Object)"source must not be null");
        PutDataRequest putDataRequest = PutDataRequest.zza(object.getUri());
        Object object2 = object.getAssets().entrySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                putDataRequest.setData(object.getData());
                return putDataRequest;
            }
            Map.Entry<String, DataItemAsset> entry = object2.next();
            if (entry.getValue().getId() == null) {
                object = String.valueOf(entry.getKey());
                object2 = "Cannot create an asset for a put request without a digest: ";
                object = ((String)object).length() != 0 ? ((String)object2).concat((String)object) : new String((String)object2);
                IllegalStateException illegalStateException = new IllegalStateException((String)object);
                throw illegalStateException;
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
    }

    @RecentlyNonNull
    public static PutDataRequest createWithAutoAppendedId(@RecentlyNonNull String pathPrefix) {
        String string;
        Preconditions.checkNotNull((Object)pathPrefix, (Object)"pathPrefix must not be null");
        Object object = new StringBuilder(string);
        if (!string.endsWith("/")) {
            object.append("/");
        }
        object.append("PN");
        object.append(zzb.nextLong());
        string = object.toString();
        string = PutDataRequest.zzb(string);
        object = new PutDataRequest((Uri)string);
        return object;
    }

    @RecentlyNonNull
    public static PutDataRequest create(@RecentlyNonNull String path) {
        String string;
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null");
        return PutDataRequest.zza(PutDataRequest.zzb(string));
    }

    @RecentlyNonNull
    public Uri getUri() {
        return this.zzc;
    }

    @VisibleForTesting
    @RecentlyNullable
    public byte[] getData() {
        return this.zze;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PutDataRequest setData(@RecentlyNonNull byte[] data) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    @RecentlyNonNull
    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string : this.zzd.keySet()) {
            hashMap.put(string, (Asset)this.zzd.getParcelable(string));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @RecentlyNullable
    public Asset getAsset(@RecentlyNonNull String key) {
        void var1_1;
        Preconditions.checkNotNull((Object)key, (Object)"key must not be null");
        return (Asset)this.zzd.getParcelable((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasAsset(@RecentlyNonNull String key) {
        void var1_1;
        Preconditions.checkNotNull((Object)key, (Object)"key must not be null");
        return this.zzd.containsKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PutDataRequest putAsset(@RecentlyNonNull String key, @RecentlyNonNull Asset value) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)var2_2);
        this.zzd.putParcelable((String)var1_1, (Parcelable)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public PutDataRequest removeAsset(@RecentlyNonNull String key) {
        void var1_1;
        Preconditions.checkNotNull((Object)key, (Object)"key must not be null");
        this.zzd.remove((String)var1_1);
        return this;
    }

    public boolean isUrgent() {
        return this.zzf == 0L;
    }

    @RecentlyNonNull
    public PutDataRequest setUrgent() {
        this.zzf = 0L;
        return this;
    }

    @RecentlyNonNull
    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public String toString(boolean verbose) {
        void var1_1;
        void var2_6;
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        byte[] byArray = this.zze;
        if (byArray == null) {
            String string = "null";
        } else {
            Integer n = byArray.length;
        }
        String string = String.valueOf(var2_6);
        String string2 = String.valueOf(string);
        int n = string2.length();
        CharSequence charSequence = new StringBuilder(n + 7);
        ((StringBuilder)charSequence).append("dataSz=");
        ((StringBuilder)charSequence).append(string);
        stringBuilder.append(((StringBuilder)charSequence).toString());
        Bundle bundle = this.zzd;
        int n2 = bundle.size();
        CharSequence charSequence2 = new StringBuilder(23);
        ((StringBuilder)charSequence2).append(", numAssets=");
        ((StringBuilder)charSequence2).append(n2);
        stringBuilder.append(((StringBuilder)charSequence2).toString());
        String string3 = String.valueOf(this.zzc);
        charSequence2 = String.valueOf(string3);
        int n3 = ((String)charSequence2).length();
        charSequence = new StringBuilder(n3 + 6);
        ((StringBuilder)charSequence).append(", uri=");
        ((StringBuilder)charSequence).append(string3);
        stringBuilder.append(((StringBuilder)charSequence).toString());
        long l = this.zzf;
        StringBuilder stringBuilder2 = new StringBuilder(35);
        stringBuilder2.append(", syncDeadline=");
        stringBuilder2.append(l);
        stringBuilder.append(stringBuilder2.toString());
        if (var1_1 == false) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Iterator iterator = this.zzd.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                stringBuilder.append("\n  ]");
                return stringBuilder.toString();
            }
            String string4 = (String)iterator.next();
            String string5 = String.valueOf(this.zzd.getParcelable(string4));
            charSequence = String.valueOf(string4);
            int n4 = ((String)charSequence).length();
            String string6 = String.valueOf(string5);
            int n5 = string6.length();
            StringBuilder stringBuilder3 = new StringBuilder(n4 + 7 + n5);
            stringBuilder3.append("\n    ");
            stringBuilder3.append(string4);
            stringBuilder3.append(": ");
            stringBuilder3.append(string5);
            stringBuilder.append(stringBuilder3.toString());
        }
    }

    static {
        Object object = new zzg();
        CREATOR = object;
        zza = TimeUnit.MINUTES.toMillis(30L);
        zzb = object = new SecureRandom();
    }

    @RecentlyNonNull
    public static PutDataRequest zza(@RecentlyNonNull Uri uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        PutDataRequest putDataRequest = new PutDataRequest(uri);
        return putDataRequest;
    }

    private static Uri zzb(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = new IllegalArgumentException("An empty path was supplied.");
            throw object;
        }
        if (!((String)object).startsWith("/")) {
            object = new IllegalArgumentException("A path must start with a single / .");
            throw object;
        }
        if (((String)object).startsWith("//")) {
            object = new IllegalArgumentException("A path must start with a single / .");
            throw object;
        }
        Uri.Builder builder = new Uri.Builder();
        return builder.scheme(WEAR_URI_SCHEME).path((String)object).build();
    }
}

