/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.zzda;

@SafeParcelable.Reserved(value={1})
@KeepName
@SafeParcelable.Class(creator="DataItemAssetParcelableCreator")
public class DataItemAssetParcelable
extends AbstractSafeParcelable
implements DataItemAsset,
ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<DataItemAssetParcelable> CREATOR;
    @SafeParcelable.Field(id=2, getter="getId")
    private final String zza;
    @SafeParcelable.Field(id=3, getter="getDataItemKey")
    private final String zzb;

    @SafeParcelable.Constructor
    DataItemAssetParcelable(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
        this.zza = string;
        this.zzb = string2;
    }

    public DataItemAssetParcelable(@RecentlyNonNull DataItemAsset dataItemAsset) {
        this.zza = (String)Preconditions.checkNotNull((Object)dataItemAsset.getId());
        this.zzb = (String)Preconditions.checkNotNull((Object)dataItemAsset.getDataItemKey());
    }

    public final void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    @RecentlyNonNull
    public final String getId() {
        return this.zza;
    }

    @Override
    @RecentlyNonNull
    public final String getDataItemKey() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNonNull
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataItemAssetParcelable[@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zza == null) {
            stringBuilder.append(",noid");
        } else {
            stringBuilder.append(",");
            stringBuilder.append(this.zza);
        }
        stringBuilder.append(", key=");
        stringBuilder.append(this.zzb);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zzda zzda2;
        CREATOR = zzda2 = new zzda();
    }
}

