/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityClient;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.internal.zzaa;
import com.google.android.gms.wearable.internal.zzab;
import com.google.android.gms.wearable.internal.zzac;
import com.google.android.gms.wearable.internal.zzad;
import com.google.android.gms.wearable.internal.zzae;
import com.google.android.gms.wearable.internal.zzgv;
import com.google.android.gms.wearable.internal.zzo;
import com.google.android.gms.wearable.internal.zzp;
import com.google.android.gms.wearable.internal.zzq;
import com.google.android.gms.wearable.internal.zzr;
import com.google.android.gms.wearable.internal.zzz;
import java.util.Map;

public final class zzaf
extends CapabilityClient {
    private final CapabilityApi zzb;
    public static final /* synthetic */ int zza;

    public zzaf(@NonNull Context object, @NonNull GoogleApi.Settings settings) {
        super((Context)object, settings);
        super();
        this.zzb = object;
    }

    public zzaf(@NonNull Activity object, @NonNull GoogleApi.Settings settings) {
        super((Activity)object, settings);
        super();
        this.zzb = object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<CapabilityInfo> getCapability(@NonNull String string, int n) {
        int n2;
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        CapabilityApi capabilityApi = this.zzb;
        GoogleApiClient googleApiClient = this.asGoogleApiClient();
        if (n != 0) {
            if (n == 1) {
                n2 = 1;
                n = 1;
            } else {
                n2 = n;
                n = 0;
            }
        } else {
            n2 = n;
            n = 1;
        }
        Preconditions.checkArgument(n != 0);
        zzo zzo2 = new zzo((zzz)capabilityApi, googleApiClient, string, n2);
        return PendingResultUtil.toTask((PendingResult)googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzo2), (PendingResultUtil.ResultConverter)zzaa.zza);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Map<String, CapabilityInfo>> getAllCapabilities(int n) {
        int n2;
        CapabilityApi capabilityApi = this.zzb;
        GoogleApiClient googleApiClient = this.asGoogleApiClient();
        if (n != 0) {
            if (n == 1) {
                n2 = 1;
                n = 1;
            } else {
                n2 = n;
                n = 0;
            }
        } else {
            n2 = n;
            n = 1;
        }
        Preconditions.checkArgument(n != 0);
        zzp zzp2 = new zzp((zzz)capabilityApi, googleApiClient, n2);
        return PendingResultUtil.toTask((PendingResult)googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzp2), (PendingResultUtil.ResultConverter)zzab.zza);
    }

    @Override
    public final Task<Void> addLocalCapability(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        CapabilityApi capabilityApi = zzaf2.zzb;
        zzaf zzaf2 = zzaf2.asGoogleApiClient();
        zzq zzq2 = new zzq((zzz)capabilityApi, (GoogleApiClient)zzaf2, string);
        return PendingResultUtil.toVoidTask((PendingResult)zzaf2.enqueue(zzq2));
    }

    @Override
    public final Task<Void> removeLocalCapability(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        CapabilityApi capabilityApi = zzaf2.zzb;
        zzaf zzaf2 = zzaf2.asGoogleApiClient();
        zzr zzr2 = new zzr((zzz)capabilityApi, (GoogleApiClient)zzaf2, string);
        return PendingResultUtil.toVoidTask((PendingResult)zzaf2.enqueue(zzr2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> addListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, @NonNull String string) {
        IntentFilter[] intentFilterArray;
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        Object object = zzgv.zza("com.google.android.gms.wearable.CAPABILITY_CHANGED");
        if (!string.startsWith("/")) {
            string = String.valueOf(string);
            intentFilterArray = "/";
            string = string.length() != 0 ? intentFilterArray.concat(string) : new String((String)intentFilterArray);
        }
        object.addDataPath(string, 0);
        intentFilterArray = new IntentFilter[]{object};
        Looper looper = this.getLooper();
        object = String.valueOf(string);
        String string2 = "CapabilityListener:";
        object = ((String)object).length() != 0 ? string2.concat((String)object) : new String(string2);
        object = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)looper, (String)object);
        zzae zzae2 = new zzae(onCapabilityChangedListener, string);
        return this.zza((ListenerHolder<CapabilityClient.OnCapabilityChangedListener>)object, zzae2, intentFilterArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Boolean> removeListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, String string) {
        Object object;
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        if (!string.startsWith("/")) {
            string = String.valueOf(string);
            object = "/";
            string = string.length() != 0 ? ((String)object).concat(string) : new String((String)object);
        }
        object = this.getLooper();
        string = String.valueOf(string);
        String string2 = "CapabilityListener:";
        if (string.length() != 0) {
            string = string2.concat(string);
            return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)object, (String)string).getListenerKey(), (Object)"Key must not be null"), 24003);
        }
        string = new String(string2);
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)object, (String)string).getListenerKey(), (Object)"Key must not be null"), 24003);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> addListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, @NonNull Uri uri, int n) {
        boolean bl;
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)uri, (Object)"uri must not be null");
        if (n != 0) {
            if (n == 1) {
                n = 1;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        Preconditions.checkArgument((boolean)bl, (Object)"invalid filter type");
        uri = zzgv.zzb("com.google.android.gms.wearable.CAPABILITY_CHANGED", uri, n);
        Looper looper = this.getLooper();
        looper = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)looper, (String)"CapabilityListener");
        IntentFilter[] intentFilterArray = new IntentFilter[]{uri};
        return this.zza((ListenerHolder<CapabilityClient.OnCapabilityChangedListener>)looper, onCapabilityChangedListener, intentFilterArray);
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener) {
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)this.getLooper(), (String)"CapabilityListener").getListenerKey(), (Object)"Key must not be null"), 24003);
    }

    private final Task<Void> zza(ListenerHolder<CapabilityClient.OnCapabilityChangedListener> builder, CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, IntentFilter[] object) {
        RegistrationMethods.Builder builder2 = RegistrationMethods.builder();
        builder2 = builder2.withHolder(builder);
        zzac zzac2 = new zzac(onCapabilityChangedListener, (ListenerHolder)builder, (IntentFilter[])object);
        builder = builder2.register((RemoteCall)zzac2);
        object = new zzad(onCapabilityChangedListener);
        return this.doRegisterEventListener(builder.unregister((RemoteCall)object).setMethodKey(24013).build());
    }
}

