/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.ChannelClient;
import com.google.android.gms.wearable.internal.zzai;
import com.google.android.gms.wearable.internal.zzam;
import com.google.android.gms.wearable.internal.zzan;
import com.google.android.gms.wearable.internal.zzao;
import com.google.android.gms.wearable.internal.zzap;
import com.google.android.gms.wearable.internal.zzaq;
import com.google.android.gms.wearable.internal.zzar;
import com.google.android.gms.wearable.internal.zzas;
import com.google.android.gms.wearable.internal.zzat;
import com.google.android.gms.wearable.internal.zzau;
import com.google.android.gms.wearable.internal.zzaz;
import com.google.android.gms.wearable.internal.zzba;
import com.google.android.gms.wearable.internal.zzbb;
import com.google.android.gms.wearable.internal.zzbc;
import com.google.android.gms.wearable.internal.zzbd;
import com.google.android.gms.wearable.internal.zzbi;
import com.google.android.gms.wearable.internal.zzgv;
import java.io.InputStream;
import java.io.OutputStream;

public final class zzav
extends ChannelClient {
    private final zzam zzb;
    public static final /* synthetic */ int zza;

    public zzav(@NonNull Context object, @NonNull GoogleApi.Settings settings) {
        super((Context)object, settings);
        super();
        this.zzb = object;
    }

    public zzav(@NonNull Activity object, @NonNull GoogleApi.Settings settings) {
        super((Activity)object, settings);
        super();
        this.zzb = object;
    }

    @Override
    public final Task<ChannelClient.Channel> openChannel(@NonNull String string, @NonNull String string2) {
        zzam zzam2 = zzav2.zzb;
        zzav zzav2 = zzav2.asGoogleApiClient();
        Preconditions.checkNotNull((Object)((Object)zzav2), (Object)"client is null");
        Preconditions.checkNotNull((Object)string, (Object)"nodeId is null");
        Preconditions.checkNotNull((Object)string2, (Object)"path is null");
        zzai zzai2 = new zzai(zzam2, (GoogleApiClient)zzav2, string, string2);
        return PendingResultUtil.toTask((PendingResult)zzav2.enqueue(zzai2), (PendingResultUtil.ResultConverter)zzan.zza);
    }

    @Override
    public final Task<Void> registerChannelCallback(@NonNull ChannelClient.ChannelCallback channelCallback) {
        Preconditions.checkNotNull((Object)channelCallback, (Object)"listener is null");
        Object object = this.getLooper();
        object = ListenerHolders.createListenerHolder((Object)channelCallback, (Looper)object, (String)"ChannelListener");
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgv.zza("com.google.android.gms.wearable.CHANNEL_EVENT")};
        zzau zzau2 = new zzau(channelCallback);
        channelCallback = this.getLooper();
        channelCallback = ListenerHolders.createListenerHolder((Object)zzau2, (Looper)channelCallback, (String)"ChannelListener");
        Object object2 = RegistrationMethods.builder();
        object = object2.withHolder((ListenerHolder)object);
        object2 = new zzao(zzau2, (ListenerHolder)channelCallback, intentFilterArray);
        channelCallback = object.register((RemoteCall)object2);
        object = new zzap(zzau2);
        return this.doRegisterEventListener(channelCallback.unregister((RemoteCall)object).setMethodKey(24014).build());
    }

    @Override
    public final Task<Boolean> unregisterChannelCallback(@NonNull ChannelClient.ChannelCallback channelCallback) {
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)channelCallback, (Looper)this.getLooper(), (String)"ChannelListener").getListenerKey(), (Object)"Key must not be null"), 24004);
    }

    private static zzbi zzc(@NonNull ChannelClient.Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must not be null");
        return (zzbi)channel;
    }

    private static zzbi zzd(@NonNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must not be null");
        return (zzbi)channel;
    }

    @Override
    public final Task<Void> close(@NonNull ChannelClient.Channel channel) {
        channel = zzav.zzc(channel);
        zzav zzav2 = zzav2.asGoogleApiClient();
        zzaz zzaz2 = new zzaz((zzbi)channel, (GoogleApiClient)zzav2);
        return PendingResultUtil.toVoidTask((PendingResult)zzav2.enqueue(zzaz2));
    }

    @Override
    public final Task<Void> close(@NonNull ChannelClient.Channel channel, int n) {
        channel = zzav.zzc(channel);
        zzav zzav2 = zzav2.asGoogleApiClient();
        zzba zzba2 = new zzba((zzbi)channel, (GoogleApiClient)zzav2, n);
        return PendingResultUtil.toVoidTask((PendingResult)zzav2.enqueue(zzba2));
    }

    @Override
    public final Task<InputStream> getInputStream(@NonNull ChannelClient.Channel channel) {
        channel = zzav.zzc(channel);
        zzav zzav2 = zzav2.asGoogleApiClient();
        zzbb zzbb2 = new zzbb((zzbi)channel, (GoogleApiClient)zzav2);
        return PendingResultUtil.toTask((PendingResult)zzav2.enqueue(zzbb2), (PendingResultUtil.ResultConverter)zzaq.zza);
    }

    @Override
    public final Task<OutputStream> getOutputStream(@NonNull ChannelClient.Channel channel) {
        channel = zzav.zzc(channel);
        zzav zzav2 = zzav2.asGoogleApiClient();
        zzbc zzbc2 = new zzbc((zzbi)channel, (GoogleApiClient)zzav2);
        return PendingResultUtil.toTask((PendingResult)zzav2.enqueue(zzbc2), (PendingResultUtil.ResultConverter)zzar.zza);
    }

    @Override
    public final Task<Void> receiveFile(@NonNull ChannelClient.Channel channel, @NonNull Uri uri, boolean bl) {
        channel = zzav.zzc(channel);
        zzav zzav2 = zzav2.asGoogleApiClient();
        Preconditions.checkNotNull((Object)((Object)zzav2), (Object)"client is null");
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        zzbd zzbd2 = new zzbd((zzbi)channel, (GoogleApiClient)zzav2, uri, bl);
        return PendingResultUtil.toVoidTask((PendingResult)zzav2.enqueue(zzbd2));
    }

    @Override
    public final Task<Void> sendFile(@NonNull ChannelClient.Channel channel, @NonNull Uri uri) {
        return PendingResultUtil.toVoidTask(zzav.zzc(channel).sendFile(this.asGoogleApiClient(), uri, 0L, -1L));
    }

    @Override
    public final Task<Void> sendFile(@NonNull ChannelClient.Channel channel, @NonNull Uri uri, long l, long l2) {
        return PendingResultUtil.toVoidTask(zzav.zzc(channel).sendFile(this.asGoogleApiClient(), uri, l, l2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> registerChannelCallback(@NonNull ChannelClient.Channel object, @NonNull ChannelClient.ChannelCallback object2) {
        String string = ((zzbi)object).zza();
        Preconditions.checkNotNull((Object)object2, (Object)"listener is null");
        IntentFilter[] intentFilterArray = this.getLooper();
        object = String.valueOf(string);
        Object object3 = "ChannelListener:";
        object = ((String)object).length() != 0 ? ((String)object3).concat((String)object) : new String((String)object3);
        object = ListenerHolders.createListenerHolder((Object)object2, (Looper)intentFilterArray, (String)object);
        intentFilterArray = new IntentFilter[]{zzgv.zza("com.google.android.gms.wearable.CHANNEL_EVENT")};
        object3 = new zzau((ChannelClient.ChannelCallback)object2);
        object2 = this.getLooper();
        object2 = ListenerHolders.createListenerHolder((Object)object3, (Looper)object2, (String)"ChannelListener");
        RegistrationMethods.Builder builder = RegistrationMethods.builder();
        object = builder.withHolder((ListenerHolder)object);
        zzas zzas2 = new zzas((zzau)object3, (ListenerHolder)object2, string, intentFilterArray);
        object = object.register((RemoteCall)zzas2);
        object2 = new zzat((zzau)object3, string);
        return this.doRegisterEventListener(object.unregister((RemoteCall)object2).setMethodKey(24014).build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Boolean> unregisterChannelCallback(@NonNull ChannelClient.Channel object, @NonNull ChannelClient.ChannelCallback channelCallback) {
        object = zzav.zzc((ChannelClient.Channel)object);
        object = ((zzbi)object).zza();
        Looper looper = this.getLooper();
        object = String.valueOf(object);
        String string = "ChannelListener:";
        if (((String)object).length() != 0) {
            object = string.concat((String)object);
            return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)channelCallback, (Looper)looper, (String)object).getListenerKey(), (Object)"Key must not be null"), 24004);
        }
        object = new String(string);
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)channelCallback, (Looper)looper, (String)object).getListenerKey(), (Object)"Key must not be null"), 24004);
    }

    static final /* synthetic */ ChannelClient.Channel zza(ChannelApi.OpenChannelResult openChannelResult) {
        return zzav.zzd(openChannelResult.getChannel());
    }

    static /* synthetic */ zzbi zzb(Channel channel) {
        return zzav.zzd(channel);
    }
}

