/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.ChannelClient;
import com.google.android.gms.wearable.internal.zzal;
import com.google.android.gms.wearable.internal.zzaz;
import com.google.android.gms.wearable.internal.zzba;
import com.google.android.gms.wearable.internal.zzbb;
import com.google.android.gms.wearable.internal.zzbc;
import com.google.android.gms.wearable.internal.zzbd;
import com.google.android.gms.wearable.internal.zzbe;
import com.google.android.gms.wearable.internal.zzbf;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.internal.zzc;
import com.google.android.gms.wearable.internal.zzgv;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ChannelImplCreator")
public final class zzbi
extends AbstractSafeParcelable
implements Channel,
ChannelClient.Channel {
    public static final Parcelable.Creator<zzbi> CREATOR;
    @SafeParcelable.Field(id=2, getter="getToken")
    private final String zza;
    @SafeParcelable.Field(id=3, getter="getNodeId")
    private final String zzb;
    @SafeParcelable.Field(id=4, getter="getPath")
    private final String zzc;

    @SafeParcelable.Constructor
    public zzbi(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3) {
        this.zza = (String)Preconditions.checkNotNull((Object)string);
        this.zzb = (String)Preconditions.checkNotNull((Object)string2);
        this.zzc = (String)Preconditions.checkNotNull((Object)string3);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        String string;
        StringBuilder stringBuilder;
        char[] cArray = ((zzbi)((Object)string6)).zza.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; n2 += cArray[i], ++i) {
        }
        String string2 = ((zzbi)((Object)string6)).zza.trim();
        int n3 = string2.length();
        if (n3 > 25) {
            String string3 = string2.substring(0, 10);
            string2 = string2.substring(n3 + -10, n3);
            String string4 = String.valueOf(string3);
            n3 = string4.length();
            String string5 = String.valueOf(string2);
            int n4 = string5.length();
            stringBuilder = new StringBuilder(n3 + 16 + n4);
            stringBuilder.append(string3);
            stringBuilder.append("...");
            stringBuilder.append(string2);
            stringBuilder.append("::");
            stringBuilder.append(n2);
            string = stringBuilder.toString();
        } else {
            string = string2;
        }
        string2 = ((zzbi)((Object)string6)).zzb;
        String string6 = ((zzbi)((Object)string6)).zzc;
        String string7 = String.valueOf(string);
        int n5 = string7.length();
        String string8 = String.valueOf(string2);
        int n6 = string8.length();
        String string9 = String.valueOf(string6);
        int n7 = string9.length();
        stringBuilder = new StringBuilder(n5 + 31 + n6 + n7);
        stringBuilder.append("Channel{token=");
        stringBuilder.append(string);
        stringBuilder.append(", nodeId=");
        stringBuilder.append(string2);
        stringBuilder.append(", path=");
        stringBuilder.append(string6);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzbi)) {
            return false;
        }
        object = (zzbi)object;
        return this.zza.equals(((zzbi)object).zza) && Objects.equal((Object)((zzbi)object).zzb, (Object)this.zzb) && Objects.equal((Object)((zzbi)object).zzc, (Object)this.zzc);
    }

    public final int hashCode() {
        return this.zza.hashCode();
    }

    @Override
    public final String getNodeId() {
        return this.zzb;
    }

    @Override
    public final String getPath() {
        return this.zzc;
    }

    public final String zza() {
        return this.zza;
    }

    @Override
    public final PendingResult<Status> close(GoogleApiClient googleApiClient) {
        zzaz zzaz2 = new zzaz(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzaz2);
    }

    @Override
    public final PendingResult<Status> close(GoogleApiClient googleApiClient, int n) {
        zzba zzba2 = new zzba(this, googleApiClient, n);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzba2);
    }

    @Override
    public final PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient googleApiClient) {
        zzbb zzbb2 = new zzbb(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzbb2);
    }

    @Override
    public final PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient googleApiClient) {
        zzbc zzbc2 = new zzbc(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzbc2);
    }

    @Override
    public final PendingResult<Status> receiveFile(GoogleApiClient googleApiClient, Uri uri, boolean bl) {
        Preconditions.checkNotNull((Object)googleApiClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        zzbd zzbd2 = new zzbd(this, googleApiClient, uri, bl);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzbd2);
    }

    @Override
    public final PendingResult<Status> sendFile(GoogleApiClient googleApiClient, Uri uri) {
        return this.sendFile(googleApiClient, uri, 0L, -1L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final PendingResult<Status> sendFile(GoogleApiClient googleApiClient, Uri uri, long l, long l2) {
        Preconditions.checkNotNull((Object)googleApiClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)this.zza, (Object)"token is null");
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        boolean bl = l >= 0L;
        Object[] objectArray = new Object[]{l};
        Preconditions.checkArgument((boolean)bl, (String)"startOffset is negative: %s", (Object[])objectArray);
        bl = l2 < 0L ? l2 == -1L : true;
        objectArray = new Object[]{l2};
        Preconditions.checkArgument((boolean)bl, (String)"invalid length: %s", (Object[])objectArray);
        zzbe zzbe2 = new zzbe(this, googleApiClient, uri, l, l2);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzbe2);
    }

    @Override
    public final PendingResult<Status> addListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgv.zza("com.google.android.gms.wearable.CHANNEL_EVENT")};
        String string = ((zzbi)((Object)string)).zza;
        zzbf zzbf2 = new zzbf(string, intentFilterArray);
        return com.google.android.gms.wearable.internal.zzc.zza(googleApiClient, zzbf2, channelListener);
    }

    @Override
    public final PendingResult<Status> removeListener(GoogleApiClient googleApiClient, ChannelApi.ChannelListener channelListener) {
        Preconditions.checkNotNull((Object)googleApiClient, (Object)"client is null");
        Preconditions.checkNotNull((Object)channelListener, (Object)"listener is null");
        zzal zzal2 = new zzal(googleApiClient, channelListener, this.zza);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzal2);
    }

    static /* synthetic */ String zzb(zzbi zzbi2) {
        return zzbi2.zza;
    }

    static {
        zzbj zzbj2;
        CREATOR = zzbj2 = new zzbj();
    }
}

