/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataClient;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzbx;
import com.google.android.gms.wearable.internal.zzby;
import com.google.android.gms.wearable.internal.zzbz;
import com.google.android.gms.wearable.internal.zzcc;
import com.google.android.gms.wearable.internal.zzcd;
import com.google.android.gms.wearable.internal.zzcj;
import com.google.android.gms.wearable.internal.zzck;
import com.google.android.gms.wearable.internal.zzcl;
import com.google.android.gms.wearable.internal.zzcm;
import com.google.android.gms.wearable.internal.zzcn;
import com.google.android.gms.wearable.internal.zzco;
import com.google.android.gms.wearable.internal.zzcp;
import com.google.android.gms.wearable.internal.zzcq;
import com.google.android.gms.wearable.internal.zzcr;
import com.google.android.gms.wearable.internal.zzcs;
import com.google.android.gms.wearable.internal.zzct;
import com.google.android.gms.wearable.internal.zzcu;
import com.google.android.gms.wearable.internal.zzgv;

public final class zzcw
extends DataClient {
    private final DataApi zzb;
    public static final /* synthetic */ int zza;

    public zzcw(@NonNull Context object, @NonNull GoogleApi.Settings settings) {
        super((Context)object, settings);
        super();
        this.zzb = object;
    }

    public zzcw(@NonNull Activity object, @NonNull GoogleApi.Settings settings) {
        super((Activity)object, settings);
        super();
        this.zzb = object;
    }

    @Override
    public final Task<DataItem> putDataItem(@NonNull PutDataRequest putDataRequest) {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        zzbx zzbx2 = new zzbx((zzcj)dataApi, (GoogleApiClient)zzcw2, putDataRequest);
        return PendingResultUtil.toTask((PendingResult)zzcw2.enqueue(zzbx2), (PendingResultUtil.ResultConverter)zzck.zza);
    }

    @Override
    public final Task<DataItem> getDataItem(@NonNull Uri uri) {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        zzby zzby2 = new zzby((zzcj)dataApi, (GoogleApiClient)zzcw2, uri);
        return PendingResultUtil.toTask((PendingResult)zzcw2.enqueue(zzby2), (PendingResultUtil.ResultConverter)zzcm.zza);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems() {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        zzbz zzbz2 = new zzbz((zzcj)dataApi, (GoogleApiClient)zzcw2);
        return PendingResultUtil.toTask((PendingResult)zzcw2.enqueue(zzbz2), (PendingResultUtil.ResultConverter)zzcn.zza);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems(@NonNull Uri uri) {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        return PendingResultUtil.toTask(((zzcj)dataApi).getDataItems((GoogleApiClient)zzcw2, uri, 0), (PendingResultUtil.ResultConverter)zzco.zza);
    }

    @Override
    public final Task<DataItemBuffer> getDataItems(@NonNull Uri uri, int n) {
        return PendingResultUtil.toTask(this.zzb.getDataItems(this.asGoogleApiClient(), uri, n), (PendingResultUtil.ResultConverter)zzcp.zza);
    }

    @Override
    public final Task<Integer> deleteDataItems(@NonNull Uri uri) {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        return PendingResultUtil.toTask(((zzcj)dataApi).deleteDataItems((GoogleApiClient)zzcw2, uri, 0), (PendingResultUtil.ResultConverter)zzcq.zza);
    }

    @Override
    public final Task<Integer> deleteDataItems(@NonNull Uri uri, int n) {
        return PendingResultUtil.toTask(this.zzb.deleteDataItems(this.asGoogleApiClient(), uri, n), (PendingResultUtil.ResultConverter)zzcr.zza);
    }

    @Override
    public final Task<DataClient.GetFdForAssetResponse> getFdForAsset(@NonNull Asset asset) {
        DataApi dataApi = object.zzb;
        Object object = object.asGoogleApiClient();
        if (asset == null) {
            object = new IllegalArgumentException("asset is null");
            throw object;
        }
        if (asset.getDigest() == null) {
            object = new IllegalArgumentException("invalid asset");
            throw object;
        }
        if (asset.zza() != null) {
            object = new IllegalArgumentException("invalid asset");
            throw object;
        }
        zzcc zzcc2 = new zzcc((zzcj)dataApi, (GoogleApiClient)object, asset);
        return PendingResultUtil.toTask((PendingResult)object.enqueue(zzcc2), (PendingResultUtil.ResultConverter)zzcs.zza);
    }

    @Override
    public final Task<DataClient.GetFdForAssetResponse> getFdForAsset(@NonNull DataItemAsset dataItemAsset) {
        DataApi dataApi = zzcw2.zzb;
        zzcw zzcw2 = zzcw2.asGoogleApiClient();
        zzcd zzcd2 = new zzcd((zzcj)dataApi, (GoogleApiClient)zzcw2, dataItemAsset);
        return PendingResultUtil.toTask((PendingResult)zzcw2.enqueue(zzcd2), (PendingResultUtil.ResultConverter)zzct.zza);
    }

    @Override
    public final Task<Void> addListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgv.zza("com.google.android.gms.wearable.DATA_CHANGED")};
        return this.zza(onDataChangedListener, intentFilterArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> addListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener, @NonNull Uri uri, int n) {
        boolean bl;
        Asserts.checkNotNull((Object)uri, (Object)"uri must not be null");
        if (n != 0) {
            if (n == 1) {
                n = 1;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        Preconditions.checkArgument((boolean)bl, (Object)"invalid filter type");
        uri = zzgv.zzb("com.google.android.gms.wearable.DATA_CHANGED", uri, n);
        IntentFilter[] intentFilterArray = new IntentFilter[]{uri};
        return this.zza(onDataChangedListener, intentFilterArray);
    }

    private final Task<Void> zza(DataClient.OnDataChangedListener onDataChangedListener, IntentFilter[] builder) {
        Object object = ListenerHolders.createListenerHolder((Object)onDataChangedListener, (Looper)this.getLooper(), (String)"DataListener");
        RegistrationMethods.Builder builder2 = RegistrationMethods.builder();
        builder2 = builder2.withHolder(object);
        zzcu zzcu2 = new zzcu(onDataChangedListener, (ListenerHolder)object, (IntentFilter[])builder);
        builder = builder2.register((RemoteCall)zzcu2);
        object = new zzcl(onDataChangedListener);
        return this.doRegisterEventListener(builder.unregister((RemoteCall)object).setMethodKey(24015).build());
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull DataClient.OnDataChangedListener onDataChangedListener) {
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)onDataChangedListener, (Looper)this.getLooper(), (String)"DataListener").getListenerKey(), (Object)"Key must not be null"), 24005);
    }
}

