/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.internal.zzde;
import java.util.Map;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="DataItemParcelableCreator")
public final class zzdd
extends AbstractSafeParcelable
implements DataItem {
    public static final Parcelable.Creator<zzdd> CREATOR;
    @SafeParcelable.Field(id=2, getter="getUri")
    private final Uri zza;
    @SafeParcelable.Field(id=4, getter="getAssetsInternal", type="android.os.Bundle")
    private final Map<String, DataItemAsset> zzb;
    @SafeParcelable.Field(id=5, getter="getData")
    private byte[] zzc;

    @SafeParcelable.Constructor
    zzdd(@SafeParcelable.Param(id=2) Uri object, @SafeParcelable.Param(id=4) Bundle bundle, @SafeParcelable.Param(id=5) byte[] byArray) {
        this.zza = object;
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (String string : bundle.keySet()) {
            object.put(string, (DataItemAssetParcelable)bundle.getParcelable(string));
        }
        this.zzb = object;
        this.zzc = byArray;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zza, (int)n, (boolean)false);
        Bundle bundle = new Bundle();
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (Map.Entry<String, DataItemAsset> entry : this.zzb.entrySet()) {
            String string = entry.getKey();
            DataItemAssetParcelable dataItemAssetParcelable = new DataItemAssetParcelable(entry.getValue());
            bundle.putParcelable(string, (Parcelable)dataItemAssetParcelable);
        }
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)4, (Bundle)bundle, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)parcel, (int)5, (byte[])this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final Uri getUri() {
        return this.zza;
    }

    @Override
    @VisibleForTesting
    public final byte[] getData() {
        return this.zzc;
    }

    @Override
    public final Map<String, DataItemAsset> getAssets() {
        return this.zzb;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        boolean bl = Log.isLoggable((String)"DataItem", (int)3);
        StringBuilder stringBuilder = new StringBuilder("DataItemParcelable[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        Object object = ((zzdd)this).zzc;
        object = object == null ? (Object)"null" : (Object)((byte[])object).length;
        object = String.valueOf(object);
        String string = String.valueOf(object);
        int n = string.length();
        CharSequence charSequence = new StringBuilder(n + 8);
        ((StringBuilder)charSequence).append(",dataSz=");
        ((StringBuilder)charSequence).append((String)object);
        stringBuilder.append(((StringBuilder)charSequence).toString());
        object = ((zzdd)this).zzb;
        int n2 = object.size();
        CharSequence charSequence2 = new StringBuilder(23);
        ((StringBuilder)charSequence2).append(", numAssets=");
        ((StringBuilder)charSequence2).append(n2);
        stringBuilder.append(((StringBuilder)charSequence2).toString());
        Object object2 = String.valueOf(((zzdd)this).zza);
        charSequence2 = String.valueOf(object2);
        int n3 = ((String)charSequence2).length();
        charSequence = new StringBuilder(n3 + 6);
        ((StringBuilder)charSequence).append(", uri=");
        ((StringBuilder)charSequence).append((String)object2);
        stringBuilder.append(((StringBuilder)charSequence).toString());
        if (!bl) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        object2 = ((zzdd)this).zzb.keySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                stringBuilder.append("\n  ]");
                return stringBuilder.toString();
            }
            String string2 = (String)object2.next();
            String string3 = String.valueOf(((zzdd)this).zzb.get(string2));
            charSequence = String.valueOf(string2);
            int n4 = ((String)charSequence).length();
            String string4 = String.valueOf(string3);
            int n5 = string4.length();
            StringBuilder stringBuilder2 = new StringBuilder(n4 + 7 + n5);
            stringBuilder2.append("\n    ");
            stringBuilder2.append(string2);
            stringBuilder2.append(": ");
            stringBuilder2.append(string3);
            stringBuilder.append(stringBuilder2.toString());
        }
    }

    static {
        zzde zzde2;
        CREATOR = zzde2 = new zzde();
    }
}

