/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.MessageClient;
import com.google.android.gms.wearable.MessageOptions;
import com.google.android.gms.wearable.internal.zzey;
import com.google.android.gms.wearable.internal.zzfc;
import com.google.android.gms.wearable.internal.zzfd;
import com.google.android.gms.wearable.internal.zzfe;
import com.google.android.gms.wearable.internal.zzff;
import com.google.android.gms.wearable.internal.zzfg;
import com.google.android.gms.wearable.internal.zzgv;
import com.google.android.gms.wearable.zze;

public final class zzfi
extends MessageClient {
    @VisibleForTesting
    final zzfc zza;
    public static final /* synthetic */ int zzb;

    public zzfi(@NonNull Context object, @NonNull GoogleApi.Settings settings) {
        super((Context)object, settings);
        super();
        this.zza = object;
    }

    public zzfi(@NonNull Activity object, @NonNull GoogleApi.Settings settings) {
        super((Activity)object, settings);
        super();
        this.zza = object;
    }

    @Override
    public final Task<Integer> sendMessage(String string, String string2, byte[] byArray) {
        zzfc zzfc2 = zzfi2.zza;
        zzfi zzfi2 = zzfi2.asGoogleApiClient();
        zzey zzey2 = new zzey(zzfc2, (GoogleApiClient)zzfi2, string, string2, byArray);
        return PendingResultUtil.toTask((PendingResult)zzfi2.enqueue(zzey2), (PendingResultUtil.ResultConverter)zzfd.zza);
    }

    @Override
    public final Task<Integer> sendMessage(String string, String featureArray, byte[] byArray, MessageOptions messageOptions) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzfe zzfe2 = new zzfe(this, string, (String)featureArray, byArray, messageOptions);
        string = builder.run((RemoteCall)zzfe2);
        string = string.setMethodKey(24020);
        featureArray = new Feature[]{zze.zza};
        return this.doRead(string.setFeatures(featureArray).build());
    }

    @Override
    public final Task<Void> addListener(MessageClient.OnMessageReceivedListener onMessageReceivedListener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzgv.zza("com.google.android.gms.wearable.MESSAGE_RECEIVED")};
        return this.zza(onMessageReceivedListener, intentFilterArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> addListener(MessageClient.OnMessageReceivedListener onMessageReceivedListener, Uri uri, int n) {
        boolean bl;
        Preconditions.checkNotNull((Object)uri, (Object)"uri must not be null");
        if (n != 0) {
            if (n == 1) {
                n = 1;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        com.google.android.gms.common.internal.Preconditions.checkArgument((boolean)bl, (Object)"invalid filter type");
        uri = zzgv.zzb("com.google.android.gms.wearable.MESSAGE_RECEIVED", uri, n);
        IntentFilter[] intentFilterArray = new IntentFilter[]{uri};
        return this.zza(onMessageReceivedListener, intentFilterArray);
    }

    private final Task<Void> zza(MessageClient.OnMessageReceivedListener onMessageReceivedListener, IntentFilter[] builder) {
        Object object = ListenerHolders.createListenerHolder((Object)onMessageReceivedListener, (Looper)this.getLooper(), (String)"MessageListener");
        RegistrationMethods.Builder builder2 = RegistrationMethods.builder();
        builder2 = builder2.withHolder(object);
        zzff zzff2 = new zzff(onMessageReceivedListener, (ListenerHolder)object, (IntentFilter[])builder);
        builder = builder2.register((RemoteCall)zzff2);
        object = new zzfg(onMessageReceivedListener);
        return this.doRegisterEventListener(builder.unregister((RemoteCall)object).setMethodKey(24016).build());
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull MessageClient.OnMessageReceivedListener onMessageReceivedListener) {
        return this.doUnregisterEventListener((ListenerHolder.ListenerKey)Preconditions.checkNotNull((Object)ListenerHolders.createListenerHolder((Object)onMessageReceivedListener, (Looper)this.getLooper(), (String)"MessageListener").getListenerKey(), (Object)"Key must not be null"), 24007);
    }
}

