/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.wearable.zzd;
import com.google.android.gms.internal.wearable.zzh;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zza;
import com.google.android.gms.wearable.internal.zzeq;
import com.google.android.gms.wearable.internal.zzeu;
import com.google.android.gms.wearable.internal.zzex;
import com.google.android.gms.wearable.internal.zzge;
import com.google.android.gms.wearable.internal.zzgo;
import com.google.android.gms.wearable.internal.zzhj;
import com.google.android.gms.wearable.internal.zzhn;
import com.google.android.gms.wearable.internal.zzhs;
import com.google.android.gms.wearable.internal.zzht;
import com.google.android.gms.wearable.internal.zzhu;
import com.google.android.gms.wearable.internal.zzia;
import com.google.android.gms.wearable.internal.zzib;
import com.google.android.gms.wearable.zze;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;

public final class zzhv
extends GmsClient<zzeu> {
    private final ExecutorService zze;
    private final zzex zzf;
    private final zzex zzg;
    private final zzex<ChannelApi.ChannelListener> zzh;
    private final zzex<DataApi.DataListener> zzi;
    private final zzex<MessageApi.MessageListener> zzj;
    private final zzex zzk;
    private final zzex zzl;
    private final zzex zzm;
    private final zzex<CapabilityApi.CapabilityListener> zzn;
    private final zzib zzo;

    public zzhv(Context object, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ClientSettings clientSettings) {
        com.google.android.gms.internal.wearable.zzh.zza();
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService = Executors.unconfigurableExecutorService(executorService);
        zzib zzib2 = zzib.zza(object);
        super(object, looper, 14, clientSettings, connectionCallbacks, onConnectionFailedListener);
        super();
        this.zzf = object;
        super();
        this.zzg = object;
        super();
        this.zzh = object;
        super();
        this.zzi = object;
        super();
        this.zzj = object;
        super();
        this.zzk = object;
        super();
        this.zzl = object;
        super();
        this.zzm = object;
        super();
        this.zzn = object;
        this.zze = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.zzo = zzib2;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected final String getStartServicePackage() {
        if (this.zzo.zzb("com.google.android.wearable.app.cn")) {
            return "com.google.android.wearable.app.cn";
        }
        return "com.google.android.gms";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    public final boolean requiresGooglePlayServices() {
        return !this.zzo.zzb("com.google.android.wearable.app.cn");
    }

    protected final void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            StringBuilder stringBuilder = new StringBuilder(41);
            stringBuilder.append("onPostInitHandler: statusCode ");
            stringBuilder.append(n);
            Log.v((String)"WearableClient", (String)stringBuilder.toString());
        }
        if (n == 0) {
            this.zzf.zza(iBinder);
            this.zzg.zza(iBinder);
            this.zzh.zza(iBinder);
            this.zzi.zza(iBinder);
            this.zzj.zza(iBinder);
            this.zzk.zza(iBinder);
            this.zzl.zza(iBinder);
            this.zzm.zza(iBinder);
            this.zzn.zza(iBinder);
            n = 0;
        }
        super.onPostInitHandler(n, iBinder, bundle, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        if (!this.requiresGooglePlayServices()) {
            try {
                Bundle bundle = this.getContext().getPackageManager().getApplicationInfo((String)"com.google.android.wearable.app.cn", (int)128).metaData;
                int n = bundle != null ? bundle.getInt("com.google.android.wearable.api.version", 0) : 0;
                if (n < 8600000) {
                    StringBuilder stringBuilder = new StringBuilder(82);
                    stringBuilder.append("The Wear OS app is out of date. Requires API version 8600000 but found ");
                    stringBuilder.append(n);
                    Log.w((String)"WearableClient", (String)stringBuilder.toString());
                    stringBuilder = this.getContext();
                    Context context = this.getContext();
                    Intent intent = new Intent("com.google.android.wearable.app.cn.UPDATE_ANDROID_WEAR");
                    intent = intent.setPackage("com.google.android.wearable.app.cn");
                    context = context.getPackageManager().resolveActivity(intent, 65536);
                    if (context != null) {
                        context = intent;
                    } else {
                        context = Uri.parse((String)"market://details");
                        context = context.buildUpon();
                        context = context.appendQueryParameter("id", "com.google.android.wearable.app.cn");
                        context = context.build();
                        intent = new Intent("android.intent.action.VIEW", (Uri)context);
                        context = intent;
                    }
                    this.triggerNotAvailable(connectionProgressReportCallbacks, 6, zzd.zza((Context)stringBuilder, 0, (Intent)context, zzd.zza));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.triggerNotAvailable(connectionProgressReportCallbacks, 16, null);
                return;
            }
        }
        super.connect(connectionProgressReportCallbacks);
    }

    public final Feature[] getApiFeatures() {
        return com.google.android.gms.wearable.zze.zze;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public final void zzp(BaseImplementation.ResultHolder<DataApi.DataItemResult> object, PutDataRequest object2) throws RemoteException {
        Object object3;
        Object object4;
        Object object5;
        Object object6 = ((PutDataRequest)((Object)object2)).getAssets().entrySet().iterator();
        while (object6.hasNext()) {
            object5 = object6.next().getValue();
            if (object5.zza() != null || object5.getDigest() != null || object5.getFd() != null || object5.getUri() != null) continue;
            object = String.valueOf(((PutDataRequest)((Object)object2)).getUri());
            object2 = String.valueOf(object5);
            object6 = String.valueOf(object);
            int n = ((String)object6).length();
            object5 = String.valueOf(object2);
            int n2 = ((String)object5).length();
            StringBuilder stringBuilder = new StringBuilder(n + 33 + n2);
            stringBuilder.append("Put for ");
            stringBuilder.append((String)object);
            stringBuilder.append(" contains invalid asset: ");
            stringBuilder.append((String)object2);
            object4 = new IllegalArgumentException(stringBuilder.toString());
            throw object4;
        }
        object6 = PutDataRequest.zza(((PutDataRequest)((Object)object2)).getUri());
        ((PutDataRequest)((Object)object6)).setData(((PutDataRequest)((Object)object2)).getData());
        if (((PutDataRequest)((Object)object2)).isUrgent()) {
            ((PutDataRequest)((Object)object6)).setUrgent();
        }
        object5 = new ArrayList();
        for (Context context : ((PutDataRequest)((Object)object2)).getAssets().entrySet()) {
            Object object7;
            Object object8;
            object3 = context.getValue();
            if (object3.zza() != null) {
                object8 = ParcelFileDescriptor.createPipe();
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object7 = String.valueOf(object3);
                    String string = String.valueOf(object8[0]);
                    String string2 = String.valueOf(object8[1]);
                    String string3 = String.valueOf(object7);
                    int n = string3.length();
                    String string4 = String.valueOf(string);
                    int n3 = string4.length();
                    String string5 = String.valueOf(string2);
                    int n4 = string5.length();
                    StringBuilder stringBuilder = new StringBuilder(n + 61 + n3 + n4);
                    stringBuilder.append("processAssets: replacing data with FD in asset: ");
                    stringBuilder.append((String)object7);
                    stringBuilder.append(" read:");
                    stringBuilder.append(string);
                    stringBuilder.append(" write:");
                    stringBuilder.append(string2);
                    Log.d((String)"WearableClient", (String)stringBuilder.toString());
                }
                ((PutDataRequest)((Object)object6)).putAsset(context.getKey(), Asset.createFromFd((ParcelFileDescriptor)object8[0]));
                context = object8[1];
                object3 = object3.zza();
                object7 = new zzhs((zzhv)((Object)object4), (ParcelFileDescriptor)context, (byte[])object3);
                object8 = new FutureTask(object7);
                object5.add(object8);
                ((zzhv)((Object)object4)).zze.submit((Runnable)object8);
                continue;
            }
            if (object3.getUri() != null) {
                object8 = object4.getContext();
                object8 = object8.getContentResolver();
                object7 = object3.getUri();
                object8 = object8.openFileDescriptor((Uri)object7, "r");
                object8 = Asset.createFromFd((ParcelFileDescriptor)object8);
                ((PutDataRequest)((Object)object6)).putAsset((String)context.getKey(), (Asset)((Object)object8));
                continue;
            }
            ((PutDataRequest)((Object)object6)).putAsset(context.getKey(), (Asset)((Object)object3));
        }
        object4 = object4.getService();
        object4 = (zzeu)object4;
        object2 = new zzhn((BaseImplementation.ResultHolder<DataApi.DataItemResult>)object, (List<FutureTask<Boolean>>)object5);
        ((zzeu)object4).zzd((zzeq)object2, (PutDataRequest)((Object)object6));
        return;
        catch (IOException iOException) {
            object2 = String.valueOf(object2);
            object6 = String.valueOf(object2);
            int n = ((String)object6).length();
            object5 = new StringBuilder(n + 60);
            ((StringBuilder)object5).append("Unable to create ParcelFileDescriptor for asset in request: ");
            ((StringBuilder)object5).append((String)object2);
            object = new IllegalStateException(((StringBuilder)object5).toString(), iOException);
            throw object;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object4 = new zzhn((BaseImplementation.ResultHolder<DataApi.DataItemResult>)object, (List<FutureTask<Boolean>>)object5);
            object = new zzge(4005, null);
            ((zza)object4).zzg((zzge)((Object)object));
            object4 = String.valueOf(object3.getUri());
            object = String.valueOf(object4);
            int n = ((String)object).length();
            object2 = new StringBuilder(n + 28);
            ((StringBuilder)object2).append("Couldn't resolve asset URI: ");
            ((StringBuilder)object2).append((String)object4);
            Log.w((String)"WearableClient", (String)((StringBuilder)object2).toString());
            return;
        }
    }

    public final void zzq(BaseImplementation.ResultHolder<DataApi.GetFdForAssetResult> resultHolder, Asset asset) throws RemoteException {
        Object object = object.getService();
        object = (zzeu)object;
        zzhj zzhj2 = new zzhj(resultHolder);
        ((zzeu)object).zzk(zzhj2, asset);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzr(BaseImplementation.ResultHolder<Status> resultHolder, String string, Uri uri, boolean bl) {
        zzht zzht2;
        ExecutorService executorService;
        try {
            executorService = this.zze;
            Preconditions.checkNotNull(resultHolder);
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)uri);
            zzht2 = new zzht(this, uri, resultHolder, bl, string);
        }
        catch (RuntimeException runtimeException) {
            string = new Status(8);
            resultHolder.setFailedResult((Status)string);
            throw runtimeException;
        }
        {
            executorService.execute(zzht2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzs(BaseImplementation.ResultHolder<Status> resultHolder, String string, Uri uri, long l, long l2) {
        try {
            ExecutorService executorService = this.zze;
            Preconditions.checkNotNull(resultHolder);
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)uri);
            boolean bl = l >= 0L;
            Object[] objectArray = new Object[]{l};
            Preconditions.checkArgument((boolean)bl, (String)"startOffset is negative: %s", (Object[])objectArray);
            bl = l2 >= -1L;
            objectArray = new Object[]{l2};
            Preconditions.checkArgument((boolean)bl, (String)"invalid length: %s", (Object[])objectArray);
            zzhu zzhu2 = new zzhu(this, uri, resultHolder, string, l, l2);
            executorService.execute(zzhu2);
            return;
        }
        catch (RuntimeException runtimeException) {
            string = new Status(8);
            resultHolder.setFailedResult((Status)string);
            throw runtimeException;
        }
    }

    public final void zzt(BaseImplementation.ResultHolder<Status> resultHolder, DataApi.DataListener dataListener, ListenerHolder<? extends DataApi.DataListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzi.zzb(this, resultHolder, dataListener, zzia.zzl(listenerHolder, intentFilterArray));
    }

    public final void zzu(BaseImplementation.ResultHolder<Status> resultHolder, MessageApi.MessageListener messageListener, ListenerHolder<? extends MessageApi.MessageListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzj.zzb(this, resultHolder, messageListener, zzia.zzm(listenerHolder, intentFilterArray));
    }

    public final void zzv(BaseImplementation.ResultHolder<Status> resultHolder, CapabilityApi.CapabilityListener capabilityListener, ListenerHolder<? extends CapabilityApi.CapabilityListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzn.zzb(this, resultHolder, capabilityListener, zzia.zzp(listenerHolder, intentFilterArray));
    }

    public final void zzw(BaseImplementation.ResultHolder<Status> resultHolder, ChannelApi.ChannelListener channelListener, ListenerHolder<? extends ChannelApi.ChannelListener> listenerHolder, @Nullable String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzh.zzb(this, resultHolder, channelListener, zzia.zzn(listenerHolder, intentFilterArray));
            return;
        }
        zzgo zzgo2 = new zzgo(string, channelListener);
        this.zzh.zzb(this, resultHolder, zzgo2, zzia.zzo(listenerHolder, string, intentFilterArray));
    }

    public final void zzx(BaseImplementation.ResultHolder<Status> resultHolder, DataApi.DataListener dataListener) throws RemoteException {
        this.zzi.zzc(this, resultHolder, dataListener);
    }

    public final void zzy(BaseImplementation.ResultHolder<Status> resultHolder, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzj.zzc(this, resultHolder, messageListener);
    }

    public final void zzz(BaseImplementation.ResultHolder<Status> resultHolder, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzn.zzc(this, resultHolder, capabilityListener);
    }

    public final void zzA(BaseImplementation.ResultHolder<Status> resultHolder, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzh.zzc(this, resultHolder, channelListener);
            return;
        }
        zzgo zzgo2 = new zzgo(string, channelListener);
        this.zzh.zzc(this, resultHolder, zzgo2);
    }

    public final int getMinApkVersion() {
        return 8600000;
    }

    public final boolean usesClientTelemetry() {
        return true;
    }
}

