/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountBudgetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ACCOUNT_BUDGET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/accountBudgets/{account_budget_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String accountBudgetId;

    @Deprecated
    protected AccountBudgetName() {
        this.customerId = null;
        this.accountBudgetId = null;
    }

    private AccountBudgetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.accountBudgetId = (String)Preconditions.checkNotNull((Object)builder.getAccountBudgetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAccountBudgetId() {
        return this.accountBudgetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccountBudgetName of(String customerId, String accountBudgetId) {
        return AccountBudgetName.newBuilder().setCustomerId(customerId).setAccountBudgetId(accountBudgetId).build();
    }

    public static String format(String customerId, String accountBudgetId) {
        return AccountBudgetName.newBuilder().setCustomerId(customerId).setAccountBudgetId(accountBudgetId).build().toString();
    }

    public static AccountBudgetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ACCOUNT_BUDGET_ID.validatedMatch(formattedString, "AccountBudgetName.parse: formattedString not in valid format");
        return AccountBudgetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("account_budget_id"));
    }

    public static List<AccountBudgetName> parseList(List<String> formattedStrings) {
        ArrayList<AccountBudgetName> list = new ArrayList<AccountBudgetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountBudgetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountBudgetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountBudgetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ACCOUNT_BUDGET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountBudgetName accountBudgetName = this;
            synchronized (accountBudgetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.accountBudgetId != null) {
                        fieldMapBuilder.put((Object)"account_budget_id", (Object)this.accountBudgetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ACCOUNT_BUDGET_ID.instantiate(new String[]{"customer_id", this.customerId, "account_budget_id", this.accountBudgetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccountBudgetName that = (AccountBudgetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.accountBudgetId, that.accountBudgetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accountBudgetId);
    }

    public static class Builder {
        private String customerId;
        private String accountBudgetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAccountBudgetId() {
            return this.accountBudgetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAccountBudgetId(String accountBudgetId) {
            this.accountBudgetId = accountBudgetId;
            return this;
        }

        private Builder(AccountBudgetName accountBudgetName) {
            this.customerId = accountBudgetName.customerId;
            this.accountBudgetId = accountBudgetName.accountBudgetId;
        }

        public AccountBudgetName build() {
            return new AccountBudgetName(this);
        }
    }
}

