/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AndroidPrivacySharedKeyGoogleCampaignName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_INTERACTION_DATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/androidPrivacySharedKeyGoogleCampaigns/{campaign_id}~{android_privacy_interaction_type}~{android_privacy_interaction_date}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String androidPrivacyInteractionType;
    private final String androidPrivacyInteractionDate;

    @Deprecated
    protected AndroidPrivacySharedKeyGoogleCampaignName() {
        this.customerId = null;
        this.campaignId = null;
        this.androidPrivacyInteractionType = null;
        this.androidPrivacyInteractionDate = null;
    }

    private AndroidPrivacySharedKeyGoogleCampaignName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.androidPrivacyInteractionType = (String)Preconditions.checkNotNull((Object)builder.getAndroidPrivacyInteractionType());
        this.androidPrivacyInteractionDate = (String)Preconditions.checkNotNull((Object)builder.getAndroidPrivacyInteractionDate());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAndroidPrivacyInteractionType() {
        return this.androidPrivacyInteractionType;
    }

    public String getAndroidPrivacyInteractionDate() {
        return this.androidPrivacyInteractionDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AndroidPrivacySharedKeyGoogleCampaignName of(String customerId, String campaignId, String androidPrivacyInteractionType, String androidPrivacyInteractionDate) {
        return AndroidPrivacySharedKeyGoogleCampaignName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAndroidPrivacyInteractionType(androidPrivacyInteractionType).setAndroidPrivacyInteractionDate(androidPrivacyInteractionDate).build();
    }

    public static String format(String customerId, String campaignId, String androidPrivacyInteractionType, String androidPrivacyInteractionDate) {
        return AndroidPrivacySharedKeyGoogleCampaignName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAndroidPrivacyInteractionType(androidPrivacyInteractionType).setAndroidPrivacyInteractionDate(androidPrivacyInteractionDate).build().toString();
    }

    public static AndroidPrivacySharedKeyGoogleCampaignName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.validatedMatch(formattedString, "AndroidPrivacySharedKeyGoogleCampaignName.parse: formattedString not in valid format");
        return AndroidPrivacySharedKeyGoogleCampaignName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("android_privacy_interaction_type"), (String)matchMap.get("android_privacy_interaction_date"));
    }

    public static List<AndroidPrivacySharedKeyGoogleCampaignName> parseList(List<String> formattedStrings) {
        ArrayList<AndroidPrivacySharedKeyGoogleCampaignName> list = new ArrayList<AndroidPrivacySharedKeyGoogleCampaignName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AndroidPrivacySharedKeyGoogleCampaignName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AndroidPrivacySharedKeyGoogleCampaignName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AndroidPrivacySharedKeyGoogleCampaignName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AndroidPrivacySharedKeyGoogleCampaignName androidPrivacySharedKeyGoogleCampaignName = this;
            synchronized (androidPrivacySharedKeyGoogleCampaignName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.androidPrivacyInteractionType != null) {
                        fieldMapBuilder.put((Object)"android_privacy_interaction_type", (Object)this.androidPrivacyInteractionType);
                    }
                    if (this.androidPrivacyInteractionDate != null) {
                        fieldMapBuilder.put((Object)"android_privacy_interaction_date", (Object)this.androidPrivacyInteractionDate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "android_privacy_interaction_type", this.androidPrivacyInteractionType, "android_privacy_interaction_date", this.androidPrivacyInteractionDate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AndroidPrivacySharedKeyGoogleCampaignName that = (AndroidPrivacySharedKeyGoogleCampaignName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.androidPrivacyInteractionType, that.androidPrivacyInteractionType) && Objects.equals(this.androidPrivacyInteractionDate, that.androidPrivacyInteractionDate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.androidPrivacyInteractionType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.androidPrivacyInteractionDate);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String androidPrivacyInteractionType;
        private String androidPrivacyInteractionDate;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAndroidPrivacyInteractionType() {
            return this.androidPrivacyInteractionType;
        }

        public String getAndroidPrivacyInteractionDate() {
            return this.androidPrivacyInteractionDate;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAndroidPrivacyInteractionType(String androidPrivacyInteractionType) {
            this.androidPrivacyInteractionType = androidPrivacyInteractionType;
            return this;
        }

        public Builder setAndroidPrivacyInteractionDate(String androidPrivacyInteractionDate) {
            this.androidPrivacyInteractionDate = androidPrivacyInteractionDate;
            return this;
        }

        private Builder(AndroidPrivacySharedKeyGoogleCampaignName androidPrivacySharedKeyGoogleCampaignName) {
            this.customerId = androidPrivacySharedKeyGoogleCampaignName.customerId;
            this.campaignId = androidPrivacySharedKeyGoogleCampaignName.campaignId;
            this.androidPrivacyInteractionType = androidPrivacySharedKeyGoogleCampaignName.androidPrivacyInteractionType;
            this.androidPrivacyInteractionDate = androidPrivacySharedKeyGoogleCampaignName.androidPrivacyInteractionDate;
        }

        public AndroidPrivacySharedKeyGoogleCampaignName build() {
            return new AndroidPrivacySharedKeyGoogleCampaignName(this);
        }
    }
}

