/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DetailedDemographicName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_DETAILED_DEMOGRAPHIC_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/detailedDemographics/{detailed_demographic_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String detailedDemographicId;

    @Deprecated
    protected DetailedDemographicName() {
        this.customerId = null;
        this.detailedDemographicId = null;
    }

    private DetailedDemographicName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.detailedDemographicId = (String)Preconditions.checkNotNull((Object)builder.getDetailedDemographicId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getDetailedDemographicId() {
        return this.detailedDemographicId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DetailedDemographicName of(String customerId, String detailedDemographicId) {
        return DetailedDemographicName.newBuilder().setCustomerId(customerId).setDetailedDemographicId(detailedDemographicId).build();
    }

    public static String format(String customerId, String detailedDemographicId) {
        return DetailedDemographicName.newBuilder().setCustomerId(customerId).setDetailedDemographicId(detailedDemographicId).build().toString();
    }

    public static DetailedDemographicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_DETAILED_DEMOGRAPHIC_ID.validatedMatch(formattedString, "DetailedDemographicName.parse: formattedString not in valid format");
        return DetailedDemographicName.of((String)matchMap.get("customer_id"), (String)matchMap.get("detailed_demographic_id"));
    }

    public static List<DetailedDemographicName> parseList(List<String> formattedStrings) {
        ArrayList<DetailedDemographicName> list = new ArrayList<DetailedDemographicName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DetailedDemographicName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DetailedDemographicName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DetailedDemographicName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_DETAILED_DEMOGRAPHIC_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DetailedDemographicName detailedDemographicName = this;
            synchronized (detailedDemographicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.detailedDemographicId != null) {
                        fieldMapBuilder.put((Object)"detailed_demographic_id", (Object)this.detailedDemographicId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_DETAILED_DEMOGRAPHIC_ID.instantiate(new String[]{"customer_id", this.customerId, "detailed_demographic_id", this.detailedDemographicId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DetailedDemographicName that = (DetailedDemographicName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.detailedDemographicId, that.detailedDemographicId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.detailedDemographicId);
    }

    public static class Builder {
        private String customerId;
        private String detailedDemographicId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getDetailedDemographicId() {
            return this.detailedDemographicId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setDetailedDemographicId(String detailedDemographicId) {
            this.detailedDemographicId = detailedDemographicId;
            return this;
        }

        private Builder(DetailedDemographicName detailedDemographicName) {
            this.customerId = detailedDemographicName.customerId;
            this.detailedDemographicId = detailedDemographicName.detailedDemographicId;
        }

        public DetailedDemographicName build() {
            return new DetailedDemographicName(this);
        }
    }
}

