/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.ads.googleads.v19.common.MetricGoal;
import com.google.ads.googleads.v19.common.MetricGoalOrBuilder;
import com.google.ads.googleads.v19.enums.AsyncActionStatusEnum;
import com.google.ads.googleads.v19.enums.ExperimentStatusEnum;
import com.google.ads.googleads.v19.enums.ExperimentTypeEnum;
import com.google.ads.googleads.v19.resources.ExperimentOrBuilder;
import com.google.ads.googleads.v19.resources.ExperimentProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Experiment
extends GeneratedMessageV3
implements ExperimentOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int EXPERIMENT_ID_FIELD_NUMBER = 9;
    private long experimentId_ = 0L;
    public static final int NAME_FIELD_NUMBER = 10;
    private volatile Object name_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 11;
    private volatile Object description_ = "";
    public static final int SUFFIX_FIELD_NUMBER = 12;
    private volatile Object suffix_ = "";
    public static final int TYPE_FIELD_NUMBER = 13;
    private int type_ = 0;
    public static final int STATUS_FIELD_NUMBER = 14;
    private int status_ = 0;
    public static final int START_DATE_FIELD_NUMBER = 15;
    private volatile Object startDate_ = "";
    public static final int END_DATE_FIELD_NUMBER = 16;
    private volatile Object endDate_ = "";
    public static final int GOALS_FIELD_NUMBER = 17;
    private List<MetricGoal> goals_;
    public static final int LONG_RUNNING_OPERATION_FIELD_NUMBER = 18;
    private volatile Object longRunningOperation_ = "";
    public static final int PROMOTE_STATUS_FIELD_NUMBER = 19;
    private int promoteStatus_ = 0;
    public static final int SYNC_ENABLED_FIELD_NUMBER = 20;
    private boolean syncEnabled_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Experiment DEFAULT_INSTANCE = new Experiment();
    private static final Parser<Experiment> PARSER = new AbstractParser<Experiment>(){

        public Experiment parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Experiment.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Experiment(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Experiment() {
        this.resourceName_ = "";
        this.name_ = "";
        this.description_ = "";
        this.suffix_ = "";
        this.type_ = 0;
        this.status_ = 0;
        this.startDate_ = "";
        this.endDate_ = "";
        this.goals_ = Collections.emptyList();
        this.longRunningOperation_ = "";
        this.promoteStatus_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Experiment();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ExperimentProto.internal_static_google_ads_googleads_v19_resources_Experiment_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ExperimentProto.internal_static_google_ads_googleads_v19_resources_Experiment_fieldAccessorTable.ensureFieldAccessorsInitialized(Experiment.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasExperimentId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public long getExperimentId() {
        return this.experimentId_;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getSuffix() {
        Object ref = this.suffix_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.suffix_ = s;
        return s;
    }

    @Override
    public ByteString getSuffixBytes() {
        Object ref = this.suffix_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.suffix_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public ExperimentTypeEnum.ExperimentType getType() {
        ExperimentTypeEnum.ExperimentType result = ExperimentTypeEnum.ExperimentType.forNumber(this.type_);
        return result == null ? ExperimentTypeEnum.ExperimentType.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public ExperimentStatusEnum.ExperimentStatus getStatus() {
        ExperimentStatusEnum.ExperimentStatus result = ExperimentStatusEnum.ExperimentStatus.forNumber(this.status_);
        return result == null ? ExperimentStatusEnum.ExperimentStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasStartDate() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getStartDate() {
        Object ref = this.startDate_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.startDate_ = s;
        return s;
    }

    @Override
    public ByteString getStartDateBytes() {
        Object ref = this.startDate_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.startDate_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasEndDate() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getEndDate() {
        Object ref = this.endDate_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.endDate_ = s;
        return s;
    }

    @Override
    public ByteString getEndDateBytes() {
        Object ref = this.endDate_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.endDate_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<MetricGoal> getGoalsList() {
        return this.goals_;
    }

    @Override
    public List<? extends MetricGoalOrBuilder> getGoalsOrBuilderList() {
        return this.goals_;
    }

    @Override
    public int getGoalsCount() {
        return this.goals_.size();
    }

    @Override
    public MetricGoal getGoals(int index) {
        return this.goals_.get(index);
    }

    @Override
    public MetricGoalOrBuilder getGoalsOrBuilder(int index) {
        return this.goals_.get(index);
    }

    @Override
    public boolean hasLongRunningOperation() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public String getLongRunningOperation() {
        Object ref = this.longRunningOperation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.longRunningOperation_ = s;
        return s;
    }

    @Override
    public ByteString getLongRunningOperationBytes() {
        Object ref = this.longRunningOperation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.longRunningOperation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getPromoteStatusValue() {
        return this.promoteStatus_;
    }

    @Override
    public AsyncActionStatusEnum.AsyncActionStatus getPromoteStatus() {
        AsyncActionStatusEnum.AsyncActionStatus result = AsyncActionStatusEnum.AsyncActionStatus.forNumber(this.promoteStatus_);
        return result == null ? AsyncActionStatusEnum.AsyncActionStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasSyncEnabled() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public boolean getSyncEnabled() {
        return this.syncEnabled_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt64(9, this.experimentId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.suffix_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.suffix_);
        }
        if (this.type_ != ExperimentTypeEnum.ExperimentType.UNSPECIFIED.getNumber()) {
            output.writeEnum(13, this.type_);
        }
        if (this.status_ != ExperimentStatusEnum.ExperimentStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(14, this.status_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)15, (Object)this.startDate_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)16, (Object)this.endDate_);
        }
        for (int i = 0; i < this.goals_.size(); ++i) {
            output.writeMessage(17, (MessageLite)this.goals_.get(i));
        }
        if ((this.bitField0_ & 8) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)18, (Object)this.longRunningOperation_);
        }
        if (this.promoteStatus_ != AsyncActionStatusEnum.AsyncActionStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(19, this.promoteStatus_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeBool(20, this.syncEnabled_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt64Size((int)9, (long)this.experimentId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.description_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.suffix_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.suffix_);
        }
        if (this.type_ != ExperimentTypeEnum.ExperimentType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)13, (int)this.type_);
        }
        if (this.status_ != ExperimentStatusEnum.ExperimentStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)14, (int)this.status_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)15, (Object)this.startDate_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)16, (Object)this.endDate_);
        }
        for (int i = 0; i < this.goals_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)((MessageLite)this.goals_.get(i)));
        }
        if ((this.bitField0_ & 8) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)18, (Object)this.longRunningOperation_);
        }
        if (this.promoteStatus_ != AsyncActionStatusEnum.AsyncActionStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)19, (int)this.promoteStatus_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeBoolSize((int)20, (boolean)this.syncEnabled_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Experiment)) {
            return super.equals(obj);
        }
        Experiment other = (Experiment)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasExperimentId() != other.hasExperimentId()) {
            return false;
        }
        if (this.hasExperimentId() && this.getExperimentId() != other.getExperimentId()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getSuffix().equals(other.getSuffix())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.hasStartDate() != other.hasStartDate()) {
            return false;
        }
        if (this.hasStartDate() && !this.getStartDate().equals(other.getStartDate())) {
            return false;
        }
        if (this.hasEndDate() != other.hasEndDate()) {
            return false;
        }
        if (this.hasEndDate() && !this.getEndDate().equals(other.getEndDate())) {
            return false;
        }
        if (!this.getGoalsList().equals(other.getGoalsList())) {
            return false;
        }
        if (this.hasLongRunningOperation() != other.hasLongRunningOperation()) {
            return false;
        }
        if (this.hasLongRunningOperation() && !this.getLongRunningOperation().equals(other.getLongRunningOperation())) {
            return false;
        }
        if (this.promoteStatus_ != other.promoteStatus_) {
            return false;
        }
        if (this.hasSyncEnabled() != other.hasSyncEnabled()) {
            return false;
        }
        if (this.hasSyncEnabled() && this.getSyncEnabled() != other.getSyncEnabled()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Experiment.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasExperimentId()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + Internal.hashLong((long)this.getExperimentId());
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getDescription().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getSuffix().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 14;
        hash = 53 * hash + this.status_;
        if (this.hasStartDate()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getStartDate().hashCode();
        }
        if (this.hasEndDate()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getEndDate().hashCode();
        }
        if (this.getGoalsCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getGoalsList().hashCode();
        }
        if (this.hasLongRunningOperation()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getLongRunningOperation().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.promoteStatus_;
        if (this.hasSyncEnabled()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getSyncEnabled());
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Experiment parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data);
    }

    public static Experiment parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Experiment parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data);
    }

    public static Experiment parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Experiment parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data);
    }

    public static Experiment parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Experiment)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Experiment parseFrom(InputStream input) throws IOException {
        return (Experiment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Experiment parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Experiment)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Experiment parseDelimitedFrom(InputStream input) throws IOException {
        return (Experiment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Experiment parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Experiment)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Experiment parseFrom(CodedInputStream input) throws IOException {
        return (Experiment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Experiment parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Experiment)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Experiment.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Experiment prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Experiment getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Experiment> parser() {
        return PARSER;
    }

    public Parser<Experiment> getParserForType() {
        return PARSER;
    }

    public Experiment getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ExperimentOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long experimentId_;
        private Object name_ = "";
        private Object description_ = "";
        private Object suffix_ = "";
        private int type_ = 0;
        private int status_ = 0;
        private Object startDate_ = "";
        private Object endDate_ = "";
        private List<MetricGoal> goals_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<MetricGoal, MetricGoal.Builder, MetricGoalOrBuilder> goalsBuilder_;
        private Object longRunningOperation_ = "";
        private int promoteStatus_ = 0;
        private boolean syncEnabled_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ExperimentProto.internal_static_google_ads_googleads_v19_resources_Experiment_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ExperimentProto.internal_static_google_ads_googleads_v19_resources_Experiment_fieldAccessorTable.ensureFieldAccessorsInitialized(Experiment.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.experimentId_ = 0L;
            this.name_ = "";
            this.description_ = "";
            this.suffix_ = "";
            this.type_ = 0;
            this.status_ = 0;
            this.startDate_ = "";
            this.endDate_ = "";
            if (this.goalsBuilder_ == null) {
                this.goals_ = Collections.emptyList();
            } else {
                this.goals_ = null;
                this.goalsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.longRunningOperation_ = "";
            this.promoteStatus_ = 0;
            this.syncEnabled_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ExperimentProto.internal_static_google_ads_googleads_v19_resources_Experiment_descriptor;
        }

        public Experiment getDefaultInstanceForType() {
            return Experiment.getDefaultInstance();
        }

        public Experiment build() {
            Experiment result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Experiment buildPartial() {
            Experiment result = new Experiment(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Experiment result) {
            if (this.goalsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.goals_ = Collections.unmodifiableList(this.goals_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.goals_ = this.goals_;
            } else {
                result.goals_ = this.goalsBuilder_.build();
            }
        }

        private void buildPartial0(Experiment result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.experimentId_ = this.experimentId_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.suffix_ = this.suffix_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.startDate_ = this.startDate_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.endDate_ = this.endDate_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.longRunningOperation_ = this.longRunningOperation_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.promoteStatus_ = this.promoteStatus_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.syncEnabled_ = this.syncEnabled_;
                to_bitField0_ |= 0x10;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Experiment) {
                return this.mergeFrom((Experiment)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Experiment other) {
            if (other == Experiment.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasExperimentId()) {
                this.setExperimentId(other.getExperimentId());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.getSuffix().isEmpty()) {
                this.suffix_ = other.suffix_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.hasStartDate()) {
                this.startDate_ = other.startDate_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (other.hasEndDate()) {
                this.endDate_ = other.endDate_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (this.goalsBuilder_ == null) {
                if (!other.goals_.isEmpty()) {
                    if (this.goals_.isEmpty()) {
                        this.goals_ = other.goals_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureGoalsIsMutable();
                        this.goals_.addAll(other.goals_);
                    }
                    this.onChanged();
                }
            } else if (!other.goals_.isEmpty()) {
                if (this.goalsBuilder_.isEmpty()) {
                    this.goalsBuilder_.dispose();
                    this.goalsBuilder_ = null;
                    this.goals_ = other.goals_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.goalsBuilder_ = alwaysUseFieldBuilders ? this.getGoalsFieldBuilder() : null;
                } else {
                    this.goalsBuilder_.addAllMessages((Iterable)other.goals_);
                }
            }
            if (other.hasLongRunningOperation()) {
                this.longRunningOperation_ = other.longRunningOperation_;
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            if (other.promoteStatus_ != 0) {
                this.setPromoteStatusValue(other.getPromoteStatusValue());
            }
            if (other.hasSyncEnabled()) {
                this.setSyncEnabled(other.getSyncEnabled());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 72: {
                            this.experimentId_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 82: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 90: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 98: {
                            this.suffix_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block21;
                        }
                        case 104: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 112: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 122: {
                            this.startDate_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block21;
                        }
                        case 130: {
                            this.endDate_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block21;
                        }
                        case 138: {
                            MetricGoal m = (MetricGoal)input.readMessage(MetricGoal.parser(), extensionRegistry);
                            if (this.goalsBuilder_ == null) {
                                this.ensureGoalsIsMutable();
                                this.goals_.add(m);
                                continue block21;
                            }
                            this.goalsBuilder_.addMessage((AbstractMessage)m);
                            continue block21;
                        }
                        case 146: {
                            this.longRunningOperation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400;
                            continue block21;
                        }
                        case 152: {
                            this.promoteStatus_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block21;
                        }
                        case 160: {
                            this.syncEnabled_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = Experiment.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExperimentId() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getExperimentId() {
            return this.experimentId_;
        }

        public Builder setExperimentId(long value) {
            this.experimentId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearExperimentId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.experimentId_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Experiment.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = Experiment.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public String getSuffix() {
            Object ref = this.suffix_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.suffix_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSuffixBytes() {
            Object ref = this.suffix_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.suffix_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSuffix(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.suffix_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearSuffix() {
            this.suffix_ = Experiment.getDefaultInstance().getSuffix();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setSuffixBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.suffix_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ExperimentTypeEnum.ExperimentType getType() {
            ExperimentTypeEnum.ExperimentType result = ExperimentTypeEnum.ExperimentType.forNumber(this.type_);
            return result == null ? ExperimentTypeEnum.ExperimentType.UNRECOGNIZED : result;
        }

        public Builder setType(ExperimentTypeEnum.ExperimentType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public ExperimentStatusEnum.ExperimentStatus getStatus() {
            ExperimentStatusEnum.ExperimentStatus result = ExperimentStatusEnum.ExperimentStatus.forNumber(this.status_);
            return result == null ? ExperimentStatusEnum.ExperimentStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(ExperimentStatusEnum.ExperimentStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStartDate() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getStartDate() {
            Object ref = this.startDate_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.startDate_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStartDateBytes() {
            Object ref = this.startDate_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.startDate_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStartDate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.startDate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearStartDate() {
            this.startDate_ = Experiment.getDefaultInstance().getStartDate();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setStartDateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.startDate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEndDate() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public String getEndDate() {
            Object ref = this.endDate_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.endDate_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEndDateBytes() {
            Object ref = this.endDate_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.endDate_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEndDate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.endDate_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearEndDate() {
            this.endDate_ = Experiment.getDefaultInstance().getEndDate();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setEndDateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.endDate_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        private void ensureGoalsIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.goals_ = new ArrayList<MetricGoal>(this.goals_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<MetricGoal> getGoalsList() {
            if (this.goalsBuilder_ == null) {
                return Collections.unmodifiableList(this.goals_);
            }
            return this.goalsBuilder_.getMessageList();
        }

        @Override
        public int getGoalsCount() {
            if (this.goalsBuilder_ == null) {
                return this.goals_.size();
            }
            return this.goalsBuilder_.getCount();
        }

        @Override
        public MetricGoal getGoals(int index) {
            if (this.goalsBuilder_ == null) {
                return this.goals_.get(index);
            }
            return (MetricGoal)this.goalsBuilder_.getMessage(index);
        }

        public Builder setGoals(int index, MetricGoal value) {
            if (this.goalsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGoalsIsMutable();
                this.goals_.set(index, value);
                this.onChanged();
            } else {
                this.goalsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setGoals(int index, MetricGoal.Builder builderForValue) {
            if (this.goalsBuilder_ == null) {
                this.ensureGoalsIsMutable();
                this.goals_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.goalsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGoals(MetricGoal value) {
            if (this.goalsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGoalsIsMutable();
                this.goals_.add(value);
                this.onChanged();
            } else {
                this.goalsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addGoals(int index, MetricGoal value) {
            if (this.goalsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureGoalsIsMutable();
                this.goals_.add(index, value);
                this.onChanged();
            } else {
                this.goalsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addGoals(MetricGoal.Builder builderForValue) {
            if (this.goalsBuilder_ == null) {
                this.ensureGoalsIsMutable();
                this.goals_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.goalsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addGoals(int index, MetricGoal.Builder builderForValue) {
            if (this.goalsBuilder_ == null) {
                this.ensureGoalsIsMutable();
                this.goals_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.goalsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllGoals(Iterable<? extends MetricGoal> values) {
            if (this.goalsBuilder_ == null) {
                this.ensureGoalsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.goals_);
                this.onChanged();
            } else {
                this.goalsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearGoals() {
            if (this.goalsBuilder_ == null) {
                this.goals_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.goalsBuilder_.clear();
            }
            return this;
        }

        public Builder removeGoals(int index) {
            if (this.goalsBuilder_ == null) {
                this.ensureGoalsIsMutable();
                this.goals_.remove(index);
                this.onChanged();
            } else {
                this.goalsBuilder_.remove(index);
            }
            return this;
        }

        public MetricGoal.Builder getGoalsBuilder(int index) {
            return (MetricGoal.Builder)this.getGoalsFieldBuilder().getBuilder(index);
        }

        @Override
        public MetricGoalOrBuilder getGoalsOrBuilder(int index) {
            if (this.goalsBuilder_ == null) {
                return this.goals_.get(index);
            }
            return (MetricGoalOrBuilder)this.goalsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends MetricGoalOrBuilder> getGoalsOrBuilderList() {
            if (this.goalsBuilder_ != null) {
                return this.goalsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.goals_);
        }

        public MetricGoal.Builder addGoalsBuilder() {
            return (MetricGoal.Builder)this.getGoalsFieldBuilder().addBuilder((AbstractMessage)MetricGoal.getDefaultInstance());
        }

        public MetricGoal.Builder addGoalsBuilder(int index) {
            return (MetricGoal.Builder)this.getGoalsFieldBuilder().addBuilder(index, (AbstractMessage)MetricGoal.getDefaultInstance());
        }

        public List<MetricGoal.Builder> getGoalsBuilderList() {
            return this.getGoalsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<MetricGoal, MetricGoal.Builder, MetricGoalOrBuilder> getGoalsFieldBuilder() {
            if (this.goalsBuilder_ == null) {
                this.goalsBuilder_ = new RepeatedFieldBuilderV3(this.goals_, (this.bitField0_ & 0x200) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.goals_ = null;
            }
            return this.goalsBuilder_;
        }

        @Override
        public boolean hasLongRunningOperation() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public String getLongRunningOperation() {
            Object ref = this.longRunningOperation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.longRunningOperation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLongRunningOperationBytes() {
            Object ref = this.longRunningOperation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.longRunningOperation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLongRunningOperation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.longRunningOperation_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearLongRunningOperation() {
            this.longRunningOperation_ = Experiment.getDefaultInstance().getLongRunningOperation();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        public Builder setLongRunningOperationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Experiment.checkByteStringIsUtf8((ByteString)value);
            this.longRunningOperation_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        @Override
        public int getPromoteStatusValue() {
            return this.promoteStatus_;
        }

        public Builder setPromoteStatusValue(int value) {
            this.promoteStatus_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public AsyncActionStatusEnum.AsyncActionStatus getPromoteStatus() {
            AsyncActionStatusEnum.AsyncActionStatus result = AsyncActionStatusEnum.AsyncActionStatus.forNumber(this.promoteStatus_);
            return result == null ? AsyncActionStatusEnum.AsyncActionStatus.UNRECOGNIZED : result;
        }

        public Builder setPromoteStatus(AsyncActionStatusEnum.AsyncActionStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.promoteStatus_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPromoteStatus() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.promoteStatus_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSyncEnabled() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public boolean getSyncEnabled() {
            return this.syncEnabled_;
        }

        public Builder setSyncEnabled(boolean value) {
            this.syncEnabled_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearSyncEnabled() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.syncEnabled_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

