/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OfflineConversionUploadClientSummaryName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CLIENT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/offlineConversionUploadClientSummaries/{client}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String client;

    @Deprecated
    protected OfflineConversionUploadClientSummaryName() {
        this.customerId = null;
        this.client = null;
    }

    private OfflineConversionUploadClientSummaryName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.client = (String)Preconditions.checkNotNull((Object)builder.getClient());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getClient() {
        return this.client;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OfflineConversionUploadClientSummaryName of(String customerId, String client) {
        return OfflineConversionUploadClientSummaryName.newBuilder().setCustomerId(customerId).setClient(client).build();
    }

    public static String format(String customerId, String client) {
        return OfflineConversionUploadClientSummaryName.newBuilder().setCustomerId(customerId).setClient(client).build().toString();
    }

    public static OfflineConversionUploadClientSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CLIENT.validatedMatch(formattedString, "OfflineConversionUploadClientSummaryName.parse: formattedString not in valid format");
        return OfflineConversionUploadClientSummaryName.of((String)matchMap.get("customer_id"), (String)matchMap.get("client"));
    }

    public static List<OfflineConversionUploadClientSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<OfflineConversionUploadClientSummaryName> list = new ArrayList<OfflineConversionUploadClientSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OfflineConversionUploadClientSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OfflineConversionUploadClientSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OfflineConversionUploadClientSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CLIENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OfflineConversionUploadClientSummaryName offlineConversionUploadClientSummaryName = this;
            synchronized (offlineConversionUploadClientSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.client != null) {
                        fieldMapBuilder.put((Object)"client", (Object)this.client);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CLIENT.instantiate(new String[]{"customer_id", this.customerId, "client", this.client});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OfflineConversionUploadClientSummaryName that = (OfflineConversionUploadClientSummaryName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.client, that.client);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.client);
    }

    public static class Builder {
        private String customerId;
        private String client;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getClient() {
            return this.client;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setClient(String client) {
            this.client = client;
            return this;
        }

        private Builder(OfflineConversionUploadClientSummaryName offlineConversionUploadClientSummaryName) {
            this.customerId = offlineConversionUploadClientSummaryName.customerId;
            this.client = offlineConversionUploadClientSummaryName.client;
        }

        public OfflineConversionUploadClientSummaryName build() {
            return new OfflineConversionUploadClientSummaryName(this);
        }
    }
}

