/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PerformanceMaxPlacementViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BASE64_PLACEMENT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/performanceMaxPlacementViews/{base_64_placement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String base64Placement;

    @Deprecated
    protected PerformanceMaxPlacementViewName() {
        this.customerId = null;
        this.base64Placement = null;
    }

    private PerformanceMaxPlacementViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.base64Placement = (String)Preconditions.checkNotNull((Object)builder.getBase64Placement());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBase64Placement() {
        return this.base64Placement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PerformanceMaxPlacementViewName of(String customerId, String base64Placement) {
        return PerformanceMaxPlacementViewName.newBuilder().setCustomerId(customerId).setBase64Placement(base64Placement).build();
    }

    public static String format(String customerId, String base64Placement) {
        return PerformanceMaxPlacementViewName.newBuilder().setCustomerId(customerId).setBase64Placement(base64Placement).build().toString();
    }

    public static PerformanceMaxPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BASE64_PLACEMENT.validatedMatch(formattedString, "PerformanceMaxPlacementViewName.parse: formattedString not in valid format");
        return PerformanceMaxPlacementViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("base_64_placement"));
    }

    public static List<PerformanceMaxPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<PerformanceMaxPlacementViewName> list = new ArrayList<PerformanceMaxPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PerformanceMaxPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PerformanceMaxPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PerformanceMaxPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BASE64_PLACEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PerformanceMaxPlacementViewName performanceMaxPlacementViewName = this;
            synchronized (performanceMaxPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.base64Placement != null) {
                        fieldMapBuilder.put((Object)"base_64_placement", (Object)this.base64Placement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BASE64_PLACEMENT.instantiate(new String[]{"customer_id", this.customerId, "base_64_placement", this.base64Placement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PerformanceMaxPlacementViewName that = (PerformanceMaxPlacementViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.base64Placement, that.base64Placement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.base64Placement);
    }

    public static class Builder {
        private String customerId;
        private String base64Placement;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBase64Placement() {
            return this.base64Placement;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBase64Placement(String base64Placement) {
            this.base64Placement = base64Placement;
            return this;
        }

        private Builder(PerformanceMaxPlacementViewName performanceMaxPlacementViewName) {
            this.customerId = performanceMaxPlacementViewName.customerId;
            this.base64Placement = performanceMaxPlacementViewName.base64Placement;
        }

        public PerformanceMaxPlacementViewName build() {
            return new PerformanceMaxPlacementViewName(this);
        }
    }
}

