/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.AdGroupAssetOperation;
import com.google.ads.googleads.v19.services.AdGroupAssetServiceSettings;
import com.google.ads.googleads.v19.services.MutateAdGroupAssetsRequest;
import com.google.ads.googleads.v19.services.MutateAdGroupAssetsResponse;
import com.google.ads.googleads.v19.services.stub.AdGroupAssetServiceStub;
import com.google.ads.googleads.v19.services.stub.AdGroupAssetServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupAssetServiceClient
implements BackgroundResource {
    private final AdGroupAssetServiceSettings settings;
    private final AdGroupAssetServiceStub stub;

    public static final AdGroupAssetServiceClient create() throws IOException {
        return AdGroupAssetServiceClient.create(AdGroupAssetServiceSettings.newBuilder().build());
    }

    public static final AdGroupAssetServiceClient create(AdGroupAssetServiceSettings settings) throws IOException {
        return new AdGroupAssetServiceClient(settings);
    }

    public static final AdGroupAssetServiceClient create(AdGroupAssetServiceStub stub) {
        return new AdGroupAssetServiceClient(stub);
    }

    protected AdGroupAssetServiceClient(AdGroupAssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupAssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupAssetServiceClient(AdGroupAssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupAssetServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupAssetServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupAssetsResponse mutateAdGroupAssets(String customerId, List<AdGroupAssetOperation> operations) {
        MutateAdGroupAssetsRequest request = MutateAdGroupAssetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupAssets(request);
    }

    public final MutateAdGroupAssetsResponse mutateAdGroupAssets(MutateAdGroupAssetsRequest request) {
        return (MutateAdGroupAssetsResponse)this.mutateAdGroupAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupAssetsRequest, MutateAdGroupAssetsResponse> mutateAdGroupAssetsCallable() {
        return this.stub.mutateAdGroupAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

