/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.AssetGroupSignalOperation;
import com.google.ads.googleads.v19.services.AssetGroupSignalServiceSettings;
import com.google.ads.googleads.v19.services.MutateAssetGroupSignalsRequest;
import com.google.ads.googleads.v19.services.MutateAssetGroupSignalsResponse;
import com.google.ads.googleads.v19.services.stub.AssetGroupSignalServiceStub;
import com.google.ads.googleads.v19.services.stub.AssetGroupSignalServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AssetGroupSignalServiceClient
implements BackgroundResource {
    private final AssetGroupSignalServiceSettings settings;
    private final AssetGroupSignalServiceStub stub;

    public static final AssetGroupSignalServiceClient create() throws IOException {
        return AssetGroupSignalServiceClient.create(AssetGroupSignalServiceSettings.newBuilder().build());
    }

    public static final AssetGroupSignalServiceClient create(AssetGroupSignalServiceSettings settings) throws IOException {
        return new AssetGroupSignalServiceClient(settings);
    }

    public static final AssetGroupSignalServiceClient create(AssetGroupSignalServiceStub stub) {
        return new AssetGroupSignalServiceClient(stub);
    }

    protected AssetGroupSignalServiceClient(AssetGroupSignalServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetGroupSignalServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AssetGroupSignalServiceClient(AssetGroupSignalServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetGroupSignalServiceSettings getSettings() {
        return this.settings;
    }

    public AssetGroupSignalServiceStub getStub() {
        return this.stub;
    }

    public final MutateAssetGroupSignalsResponse mutateAssetGroupSignals(String customerId, List<AssetGroupSignalOperation> operations) {
        MutateAssetGroupSignalsRequest request = MutateAssetGroupSignalsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAssetGroupSignals(request);
    }

    public final MutateAssetGroupSignalsResponse mutateAssetGroupSignals(MutateAssetGroupSignalsRequest request) {
        return (MutateAssetGroupSignalsResponse)this.mutateAssetGroupSignalsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAssetGroupSignalsRequest, MutateAssetGroupSignalsResponse> mutateAssetGroupSignalsCallable() {
        return this.stub.mutateAssetGroupSignalsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

