/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.CallConversion;
import com.google.ads.googleads.v19.services.ClickConversion;
import com.google.ads.googleads.v19.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v19.services.UploadCallConversionsRequest;
import com.google.ads.googleads.v19.services.UploadCallConversionsResponse;
import com.google.ads.googleads.v19.services.UploadClickConversionsRequest;
import com.google.ads.googleads.v19.services.UploadClickConversionsResponse;
import com.google.ads.googleads.v19.services.stub.ConversionUploadServiceStub;
import com.google.ads.googleads.v19.services.stub.ConversionUploadServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConversionUploadServiceClient
implements BackgroundResource {
    private final ConversionUploadServiceSettings settings;
    private final ConversionUploadServiceStub stub;

    public static final ConversionUploadServiceClient create() throws IOException {
        return ConversionUploadServiceClient.create(ConversionUploadServiceSettings.newBuilder().build());
    }

    public static final ConversionUploadServiceClient create(ConversionUploadServiceSettings settings) throws IOException {
        return new ConversionUploadServiceClient(settings);
    }

    public static final ConversionUploadServiceClient create(ConversionUploadServiceStub stub) {
        return new ConversionUploadServiceClient(stub);
    }

    protected ConversionUploadServiceClient(ConversionUploadServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversionUploadServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversionUploadServiceClient(ConversionUploadServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversionUploadServiceSettings getSettings() {
        return this.settings;
    }

    public ConversionUploadServiceStub getStub() {
        return this.stub;
    }

    public final UploadClickConversionsResponse uploadClickConversions(String customerId, List<ClickConversion> conversions, boolean partialFailure) {
        UploadClickConversionsRequest request = UploadClickConversionsRequest.newBuilder().setCustomerId(customerId).addAllConversions(conversions).setPartialFailure(partialFailure).build();
        return this.uploadClickConversions(request);
    }

    public final UploadClickConversionsResponse uploadClickConversions(UploadClickConversionsRequest request) {
        return (UploadClickConversionsResponse)this.uploadClickConversionsCallable().call((Object)request);
    }

    public final UnaryCallable<UploadClickConversionsRequest, UploadClickConversionsResponse> uploadClickConversionsCallable() {
        return this.stub.uploadClickConversionsCallable();
    }

    public final UploadCallConversionsResponse uploadCallConversions(String customerId, List<CallConversion> conversions, boolean partialFailure) {
        UploadCallConversionsRequest request = UploadCallConversionsRequest.newBuilder().setCustomerId(customerId).addAllConversions(conversions).setPartialFailure(partialFailure).build();
        return this.uploadCallConversions(request);
    }

    public final UploadCallConversionsResponse uploadCallConversions(UploadCallConversionsRequest request) {
        return (UploadCallConversionsResponse)this.uploadCallConversionsCallable().call((Object)request);
    }

    public final UnaryCallable<UploadCallConversionsRequest, UploadCallConversionsResponse> uploadCallConversionsCallable() {
        return this.stub.uploadCallConversionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

