/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.services.CustomerUserAccessOperation;
import com.google.ads.googleads.v19.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v19.services.MutateCustomerUserAccessRequest;
import com.google.ads.googleads.v19.services.MutateCustomerUserAccessResponse;
import com.google.ads.googleads.v19.services.stub.CustomerUserAccessServiceStub;
import com.google.ads.googleads.v19.services.stub.CustomerUserAccessServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CustomerUserAccessServiceClient
implements BackgroundResource {
    private final CustomerUserAccessServiceSettings settings;
    private final CustomerUserAccessServiceStub stub;

    public static final CustomerUserAccessServiceClient create() throws IOException {
        return CustomerUserAccessServiceClient.create(CustomerUserAccessServiceSettings.newBuilder().build());
    }

    public static final CustomerUserAccessServiceClient create(CustomerUserAccessServiceSettings settings) throws IOException {
        return new CustomerUserAccessServiceClient(settings);
    }

    public static final CustomerUserAccessServiceClient create(CustomerUserAccessServiceStub stub) {
        return new CustomerUserAccessServiceClient(stub);
    }

    protected CustomerUserAccessServiceClient(CustomerUserAccessServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerUserAccessServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerUserAccessServiceClient(CustomerUserAccessServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerUserAccessServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerUserAccessServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerUserAccessResponse mutateCustomerUserAccess(String customerId, CustomerUserAccessOperation operation) {
        MutateCustomerUserAccessRequest request = MutateCustomerUserAccessRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateCustomerUserAccess(request);
    }

    public final MutateCustomerUserAccessResponse mutateCustomerUserAccess(MutateCustomerUserAccessRequest request) {
        return (MutateCustomerUserAccessResponse)this.mutateCustomerUserAccessCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerUserAccessRequest, MutateCustomerUserAccessResponse> mutateCustomerUserAccessCallable() {
        return this.stub.mutateCustomerUserAccessCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

