/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services;

import com.google.ads.googleads.v19.resources.GoogleAdsField;
import com.google.ads.googleads.v19.resources.GoogleAdsFieldName;
import com.google.ads.googleads.v19.services.GetGoogleAdsFieldRequest;
import com.google.ads.googleads.v19.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v19.services.SearchGoogleAdsFieldsRequest;
import com.google.ads.googleads.v19.services.SearchGoogleAdsFieldsResponse;
import com.google.ads.googleads.v19.services.stub.GoogleAdsFieldServiceStub;
import com.google.ads.googleads.v19.services.stub.GoogleAdsFieldServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GoogleAdsFieldServiceClient
implements BackgroundResource {
    private final GoogleAdsFieldServiceSettings settings;
    private final GoogleAdsFieldServiceStub stub;

    public static final GoogleAdsFieldServiceClient create() throws IOException {
        return GoogleAdsFieldServiceClient.create(GoogleAdsFieldServiceSettings.newBuilder().build());
    }

    public static final GoogleAdsFieldServiceClient create(GoogleAdsFieldServiceSettings settings) throws IOException {
        return new GoogleAdsFieldServiceClient(settings);
    }

    public static final GoogleAdsFieldServiceClient create(GoogleAdsFieldServiceStub stub) {
        return new GoogleAdsFieldServiceClient(stub);
    }

    protected GoogleAdsFieldServiceClient(GoogleAdsFieldServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GoogleAdsFieldServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GoogleAdsFieldServiceClient(GoogleAdsFieldServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GoogleAdsFieldServiceSettings getSettings() {
        return this.settings;
    }

    public GoogleAdsFieldServiceStub getStub() {
        return this.stub;
    }

    public final GoogleAdsField getGoogleAdsField(GoogleAdsFieldName resourceName) {
        GetGoogleAdsFieldRequest request = GetGoogleAdsFieldRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getGoogleAdsField(request);
    }

    public final GoogleAdsField getGoogleAdsField(String resourceName) {
        GetGoogleAdsFieldRequest request = GetGoogleAdsFieldRequest.newBuilder().setResourceName(resourceName).build();
        return this.getGoogleAdsField(request);
    }

    public final GoogleAdsField getGoogleAdsField(GetGoogleAdsFieldRequest request) {
        return (GoogleAdsField)this.getGoogleAdsFieldCallable().call((Object)request);
    }

    public final UnaryCallable<GetGoogleAdsFieldRequest, GoogleAdsField> getGoogleAdsFieldCallable() {
        return this.stub.getGoogleAdsFieldCallable();
    }

    public final SearchGoogleAdsFieldsPagedResponse searchGoogleAdsFields(String query) {
        SearchGoogleAdsFieldsRequest request = SearchGoogleAdsFieldsRequest.newBuilder().setQuery(query).build();
        return this.searchGoogleAdsFields(request);
    }

    public final SearchGoogleAdsFieldsPagedResponse searchGoogleAdsFields(SearchGoogleAdsFieldsRequest request) {
        return (SearchGoogleAdsFieldsPagedResponse)((Object)this.searchGoogleAdsFieldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsPagedResponse> searchGoogleAdsFieldsPagedCallable() {
        return this.stub.searchGoogleAdsFieldsPagedCallable();
    }

    public final UnaryCallable<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse> searchGoogleAdsFieldsCallable() {
        return this.stub.searchGoogleAdsFieldsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchGoogleAdsFieldsPagedResponse
    extends AbstractPagedListResponse<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField, SearchGoogleAdsFieldsPage, SearchGoogleAdsFieldsFixedSizeCollection> {
        public static ApiFuture<SearchGoogleAdsFieldsPagedResponse> createAsync(PageContext<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField> context, ApiFuture<SearchGoogleAdsFieldsResponse> futureResponse) {
            ApiFuture<SearchGoogleAdsFieldsPage> futurePage = SearchGoogleAdsFieldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchGoogleAdsFieldsPagedResponse((SearchGoogleAdsFieldsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchGoogleAdsFieldsPagedResponse(SearchGoogleAdsFieldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchGoogleAdsFieldsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchGoogleAdsFieldsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField, SearchGoogleAdsFieldsPage, SearchGoogleAdsFieldsFixedSizeCollection> {
        private SearchGoogleAdsFieldsFixedSizeCollection(List<SearchGoogleAdsFieldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchGoogleAdsFieldsFixedSizeCollection createEmptyCollection() {
            return new SearchGoogleAdsFieldsFixedSizeCollection(null, 0);
        }

        protected SearchGoogleAdsFieldsFixedSizeCollection createCollection(List<SearchGoogleAdsFieldsPage> pages, int collectionSize) {
            return new SearchGoogleAdsFieldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchGoogleAdsFieldsPage
    extends AbstractPage<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField, SearchGoogleAdsFieldsPage> {
        private SearchGoogleAdsFieldsPage(PageContext<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField> context, SearchGoogleAdsFieldsResponse response) {
            super(context, (Object)response);
        }

        private static SearchGoogleAdsFieldsPage createEmptyPage() {
            return new SearchGoogleAdsFieldsPage(null, null);
        }

        protected SearchGoogleAdsFieldsPage createPage(PageContext<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField> context, SearchGoogleAdsFieldsResponse response) {
            return new SearchGoogleAdsFieldsPage(context, response);
        }

        public ApiFuture<SearchGoogleAdsFieldsPage> createPageAsync(PageContext<SearchGoogleAdsFieldsRequest, SearchGoogleAdsFieldsResponse, GoogleAdsField> context, ApiFuture<SearchGoogleAdsFieldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

