/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v19.services.stub;

import com.google.ads.googleads.v19.services.CreateProductLinkInvitationRequest;
import com.google.ads.googleads.v19.services.CreateProductLinkInvitationResponse;
import com.google.ads.googleads.v19.services.RemoveProductLinkInvitationRequest;
import com.google.ads.googleads.v19.services.RemoveProductLinkInvitationResponse;
import com.google.ads.googleads.v19.services.UpdateProductLinkInvitationRequest;
import com.google.ads.googleads.v19.services.UpdateProductLinkInvitationResponse;
import com.google.ads.googleads.v19.services.stub.GrpcProductLinkInvitationServiceStub;
import com.google.ads.googleads.v19.services.stub.ProductLinkInvitationServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ProductLinkInvitationServiceStubSettings
extends StubSettings<ProductLinkInvitationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<CreateProductLinkInvitationRequest, CreateProductLinkInvitationResponse> createProductLinkInvitationSettings;
    private final UnaryCallSettings<UpdateProductLinkInvitationRequest, UpdateProductLinkInvitationResponse> updateProductLinkInvitationSettings;
    private final UnaryCallSettings<RemoveProductLinkInvitationRequest, RemoveProductLinkInvitationResponse> removeProductLinkInvitationSettings;

    public UnaryCallSettings<CreateProductLinkInvitationRequest, CreateProductLinkInvitationResponse> createProductLinkInvitationSettings() {
        return this.createProductLinkInvitationSettings;
    }

    public UnaryCallSettings<UpdateProductLinkInvitationRequest, UpdateProductLinkInvitationResponse> updateProductLinkInvitationSettings() {
        return this.updateProductLinkInvitationSettings;
    }

    public UnaryCallSettings<RemoveProductLinkInvitationRequest, RemoveProductLinkInvitationResponse> removeProductLinkInvitationSettings() {
        return this.removeProductLinkInvitationSettings;
    }

    public ProductLinkInvitationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProductLinkInvitationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "googleads";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProductLinkInvitationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProductLinkInvitationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProductLinkInvitationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createProductLinkInvitationSettings = settingsBuilder.createProductLinkInvitationSettings().build();
        this.updateProductLinkInvitationSettings = settingsBuilder.updateProductLinkInvitationSettings().build();
        this.removeProductLinkInvitationSettings = settingsBuilder.removeProductLinkInvitationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProductLinkInvitationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateProductLinkInvitationRequest, CreateProductLinkInvitationResponse> createProductLinkInvitationSettings;
        private final UnaryCallSettings.Builder<UpdateProductLinkInvitationRequest, UpdateProductLinkInvitationResponse> updateProductLinkInvitationSettings;
        private final UnaryCallSettings.Builder<RemoveProductLinkInvitationRequest, RemoveProductLinkInvitationResponse> removeProductLinkInvitationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createProductLinkInvitationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProductLinkInvitationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeProductLinkInvitationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductLinkInvitationSettings, this.updateProductLinkInvitationSettings, this.removeProductLinkInvitationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProductLinkInvitationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createProductLinkInvitationSettings = settings.createProductLinkInvitationSettings.toBuilder();
            this.updateProductLinkInvitationSettings = settings.updateProductLinkInvitationSettings.toBuilder();
            this.removeProductLinkInvitationSettings = settings.removeProductLinkInvitationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createProductLinkInvitationSettings, this.updateProductLinkInvitationSettings, this.removeProductLinkInvitationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProductLinkInvitationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProductLinkInvitationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProductLinkInvitationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProductLinkInvitationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createProductLinkInvitationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateProductLinkInvitationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.removeProductLinkInvitationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateProductLinkInvitationRequest, CreateProductLinkInvitationResponse> createProductLinkInvitationSettings() {
            return this.createProductLinkInvitationSettings;
        }

        public UnaryCallSettings.Builder<UpdateProductLinkInvitationRequest, UpdateProductLinkInvitationResponse> updateProductLinkInvitationSettings() {
            return this.updateProductLinkInvitationSettings;
        }

        public UnaryCallSettings.Builder<RemoveProductLinkInvitationRequest, RemoveProductLinkInvitationResponse> removeProductLinkInvitationSettings() {
            return this.removeProductLinkInvitationSettings;
        }

        public ProductLinkInvitationServiceStubSettings build() throws IOException {
            return new ProductLinkInvitationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(14400000L)).setTotalTimeoutDuration(Duration.ofMillis(14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

