/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerManagerLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_MANAGER_CUSTOMER_ID_MANAGER_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerManagerLinks/{manager_customer_id}~{manager_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String managerCustomerId;
    private final String managerLinkId;

    @Deprecated
    protected CustomerManagerLinkName() {
        this.customerId = null;
        this.managerCustomerId = null;
        this.managerLinkId = null;
    }

    private CustomerManagerLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.managerCustomerId = (String)Preconditions.checkNotNull((Object)builder.getManagerCustomerId());
        this.managerLinkId = (String)Preconditions.checkNotNull((Object)builder.getManagerLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getManagerCustomerId() {
        return this.managerCustomerId;
    }

    public String getManagerLinkId() {
        return this.managerLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerManagerLinkName of(String customerId, String managerCustomerId, String managerLinkId) {
        return CustomerManagerLinkName.newBuilder().setCustomerId(customerId).setManagerCustomerId(managerCustomerId).setManagerLinkId(managerLinkId).build();
    }

    public static String format(String customerId, String managerCustomerId, String managerLinkId) {
        return CustomerManagerLinkName.newBuilder().setCustomerId(customerId).setManagerCustomerId(managerCustomerId).setManagerLinkId(managerLinkId).build().toString();
    }

    public static CustomerManagerLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_MANAGER_CUSTOMER_ID_MANAGER_LINK_ID.validatedMatch(formattedString, "CustomerManagerLinkName.parse: formattedString not in valid format");
        return CustomerManagerLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("manager_customer_id"), (String)matchMap.get("manager_link_id"));
    }

    public static List<CustomerManagerLinkName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerManagerLinkName> list = new ArrayList<CustomerManagerLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerManagerLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerManagerLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerManagerLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_MANAGER_CUSTOMER_ID_MANAGER_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerManagerLinkName customerManagerLinkName = this;
            synchronized (customerManagerLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.managerCustomerId != null) {
                        fieldMapBuilder.put((Object)"manager_customer_id", (Object)this.managerCustomerId);
                    }
                    if (this.managerLinkId != null) {
                        fieldMapBuilder.put((Object)"manager_link_id", (Object)this.managerLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_MANAGER_CUSTOMER_ID_MANAGER_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "manager_customer_id", this.managerCustomerId, "manager_link_id", this.managerLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerManagerLinkName that = (CustomerManagerLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.managerCustomerId, that.managerCustomerId) && Objects.equals(this.managerLinkId, that.managerLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.managerCustomerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.managerLinkId);
    }

    public static class Builder {
        private String customerId;
        private String managerCustomerId;
        private String managerLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getManagerCustomerId() {
            return this.managerCustomerId;
        }

        public String getManagerLinkId() {
            return this.managerLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setManagerCustomerId(String managerCustomerId) {
            this.managerCustomerId = managerCustomerId;
            return this;
        }

        public Builder setManagerLinkId(String managerLinkId) {
            this.managerLinkId = managerLinkId;
            return this;
        }

        private Builder(CustomerManagerLinkName customerManagerLinkName) {
            this.customerId = customerManagerLinkName.customerId;
            this.managerCustomerId = customerManagerLinkName.managerCustomerId;
            this.managerLinkId = customerManagerLinkName.managerLinkId;
        }

        public CustomerManagerLinkName build() {
            return new CustomerManagerLinkName(this);
        }
    }
}

