/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerUserAccessName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_USER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerUserAccesses/{user_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String userId;

    @Deprecated
    protected CustomerUserAccessName() {
        this.customerId = null;
        this.userId = null;
    }

    private CustomerUserAccessName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.userId = (String)Preconditions.checkNotNull((Object)builder.getUserId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUserId() {
        return this.userId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerUserAccessName of(String customerId, String userId) {
        return CustomerUserAccessName.newBuilder().setCustomerId(customerId).setUserId(userId).build();
    }

    public static String format(String customerId, String userId) {
        return CustomerUserAccessName.newBuilder().setCustomerId(customerId).setUserId(userId).build().toString();
    }

    public static CustomerUserAccessName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_USER_ID.validatedMatch(formattedString, "CustomerUserAccessName.parse: formattedString not in valid format");
        return CustomerUserAccessName.of((String)matchMap.get("customer_id"), (String)matchMap.get("user_id"));
    }

    public static List<CustomerUserAccessName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerUserAccessName> list = new ArrayList<CustomerUserAccessName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerUserAccessName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerUserAccessName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerUserAccessName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_USER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerUserAccessName customerUserAccessName = this;
            synchronized (customerUserAccessName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.userId != null) {
                        fieldMapBuilder.put((Object)"user_id", (Object)this.userId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_USER_ID.instantiate(new String[]{"customer_id", this.customerId, "user_id", this.userId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerUserAccessName that = (CustomerUserAccessName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.userId, that.userId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userId);
    }

    public static class Builder {
        private String customerId;
        private String userId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUserId() {
            return this.userId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUserId(String userId) {
            this.userId = userId;
            return this;
        }

        private Builder(CustomerUserAccessName customerUserAccessName) {
            this.customerId = customerUserAccessName.customerId;
            this.userId = customerUserAccessName.userId;
        }

        public CustomerUserAccessName build() {
            return new CustomerUserAccessName(this);
        }
    }
}

