/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PRODUCT_LINK_ID_DATA_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/dataLinks/{product_link_id}~{data_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String productLinkId;
    private final String dataLinkId;

    @Deprecated
    protected DataLinkName() {
        this.customerId = null;
        this.productLinkId = null;
        this.dataLinkId = null;
    }

    private DataLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.productLinkId = (String)Preconditions.checkNotNull((Object)builder.getProductLinkId());
        this.dataLinkId = (String)Preconditions.checkNotNull((Object)builder.getDataLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getProductLinkId() {
        return this.productLinkId;
    }

    public String getDataLinkId() {
        return this.dataLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataLinkName of(String customerId, String productLinkId, String dataLinkId) {
        return DataLinkName.newBuilder().setCustomerId(customerId).setProductLinkId(productLinkId).setDataLinkId(dataLinkId).build();
    }

    public static String format(String customerId, String productLinkId, String dataLinkId) {
        return DataLinkName.newBuilder().setCustomerId(customerId).setProductLinkId(productLinkId).setDataLinkId(dataLinkId).build().toString();
    }

    public static DataLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PRODUCT_LINK_ID_DATA_LINK_ID.validatedMatch(formattedString, "DataLinkName.parse: formattedString not in valid format");
        return DataLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("product_link_id"), (String)matchMap.get("data_link_id"));
    }

    public static List<DataLinkName> parseList(List<String> formattedStrings) {
        ArrayList<DataLinkName> list = new ArrayList<DataLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PRODUCT_LINK_ID_DATA_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataLinkName dataLinkName = this;
            synchronized (dataLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.productLinkId != null) {
                        fieldMapBuilder.put((Object)"product_link_id", (Object)this.productLinkId);
                    }
                    if (this.dataLinkId != null) {
                        fieldMapBuilder.put((Object)"data_link_id", (Object)this.dataLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PRODUCT_LINK_ID_DATA_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "product_link_id", this.productLinkId, "data_link_id", this.dataLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataLinkName that = (DataLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.productLinkId, that.productLinkId) && Objects.equals(this.dataLinkId, that.dataLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.productLinkId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataLinkId);
    }

    public static class Builder {
        private String customerId;
        private String productLinkId;
        private String dataLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getProductLinkId() {
            return this.productLinkId;
        }

        public String getDataLinkId() {
            return this.dataLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setProductLinkId(String productLinkId) {
            this.productLinkId = productLinkId;
            return this;
        }

        public Builder setDataLinkId(String dataLinkId) {
            this.dataLinkId = dataLinkId;
            return this;
        }

        private Builder(DataLinkName dataLinkName) {
            this.customerId = dataLinkName.customerId;
            this.productLinkId = dataLinkName.productLinkId;
            this.dataLinkId = dataLinkName.dataLinkId;
        }

        public DataLinkName build() {
            return new DataLinkName(this);
        }
    }
}

