/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.ads.googleads.v20.common.DateRange;
import com.google.ads.googleads.v20.common.DateRangeOrBuilder;
import com.google.ads.googleads.v20.enums.InvoiceTypeEnum;
import com.google.ads.googleads.v20.enums.MonthOfYearEnum;
import com.google.ads.googleads.v20.resources.InvoiceOrBuilder;
import com.google.ads.googleads.v20.resources.InvoiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Invoice
extends GeneratedMessageV3
implements InvoiceOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 25;
    private volatile Object id_ = "";
    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;
    public static final int BILLING_SETUP_FIELD_NUMBER = 26;
    private volatile Object billingSetup_ = "";
    public static final int PAYMENTS_ACCOUNT_ID_FIELD_NUMBER = 27;
    private volatile Object paymentsAccountId_ = "";
    public static final int PAYMENTS_PROFILE_ID_FIELD_NUMBER = 28;
    private volatile Object paymentsProfileId_ = "";
    public static final int ISSUE_DATE_FIELD_NUMBER = 29;
    private volatile Object issueDate_ = "";
    public static final int DUE_DATE_FIELD_NUMBER = 30;
    private volatile Object dueDate_ = "";
    public static final int SERVICE_DATE_RANGE_FIELD_NUMBER = 9;
    private DateRange serviceDateRange_;
    public static final int CURRENCY_CODE_FIELD_NUMBER = 31;
    private volatile Object currencyCode_ = "";
    public static final int ADJUSTMENTS_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 19;
    private long adjustmentsSubtotalAmountMicros_ = 0L;
    public static final int ADJUSTMENTS_TAX_AMOUNT_MICROS_FIELD_NUMBER = 20;
    private long adjustmentsTaxAmountMicros_ = 0L;
    public static final int ADJUSTMENTS_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 21;
    private long adjustmentsTotalAmountMicros_ = 0L;
    public static final int REGULATORY_COSTS_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 22;
    private long regulatoryCostsSubtotalAmountMicros_ = 0L;
    public static final int REGULATORY_COSTS_TAX_AMOUNT_MICROS_FIELD_NUMBER = 23;
    private long regulatoryCostsTaxAmountMicros_ = 0L;
    public static final int REGULATORY_COSTS_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 24;
    private long regulatoryCostsTotalAmountMicros_ = 0L;
    public static final int EXPORT_CHARGE_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 40;
    private long exportChargeSubtotalAmountMicros_ = 0L;
    public static final int EXPORT_CHARGE_TAX_AMOUNT_MICROS_FIELD_NUMBER = 41;
    private long exportChargeTaxAmountMicros_ = 0L;
    public static final int EXPORT_CHARGE_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 42;
    private long exportChargeTotalAmountMicros_ = 0L;
    public static final int SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 33;
    private long subtotalAmountMicros_ = 0L;
    public static final int TAX_AMOUNT_MICROS_FIELD_NUMBER = 34;
    private long taxAmountMicros_ = 0L;
    public static final int TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 35;
    private long totalAmountMicros_ = 0L;
    public static final int CORRECTED_INVOICE_FIELD_NUMBER = 36;
    private volatile Object correctedInvoice_ = "";
    public static final int REPLACED_INVOICES_FIELD_NUMBER = 37;
    private LazyStringArrayList replacedInvoices_ = LazyStringArrayList.emptyList();
    public static final int PDF_URL_FIELD_NUMBER = 38;
    private volatile Object pdfUrl_ = "";
    public static final int ACCOUNT_BUDGET_SUMMARIES_FIELD_NUMBER = 18;
    private List<AccountBudgetSummary> accountBudgetSummaries_;
    public static final int ACCOUNT_SUMMARIES_FIELD_NUMBER = 39;
    private List<AccountSummary> accountSummaries_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Invoice DEFAULT_INSTANCE = new Invoice();
    private static final Parser<Invoice> PARSER = new AbstractParser<Invoice>(){

        public Invoice parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Invoice.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Invoice(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Invoice() {
        this.resourceName_ = "";
        this.id_ = "";
        this.type_ = 0;
        this.billingSetup_ = "";
        this.paymentsAccountId_ = "";
        this.paymentsProfileId_ = "";
        this.issueDate_ = "";
        this.dueDate_ = "";
        this.currencyCode_ = "";
        this.correctedInvoice_ = "";
        this.replacedInvoices_ = LazyStringArrayList.emptyList();
        this.pdfUrl_ = "";
        this.accountBudgetSummaries_ = Collections.emptyList();
        this.accountSummaries_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Invoice();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_fieldAccessorTable.ensureFieldAccessorsInitialized(Invoice.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public InvoiceTypeEnum.InvoiceType getType() {
        InvoiceTypeEnum.InvoiceType result = InvoiceTypeEnum.InvoiceType.forNumber(this.type_);
        return result == null ? InvoiceTypeEnum.InvoiceType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasBillingSetup() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getBillingSetup() {
        Object ref = this.billingSetup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.billingSetup_ = s;
        return s;
    }

    @Override
    public ByteString getBillingSetupBytes() {
        Object ref = this.billingSetup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.billingSetup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPaymentsAccountId() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getPaymentsAccountId() {
        Object ref = this.paymentsAccountId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.paymentsAccountId_ = s;
        return s;
    }

    @Override
    public ByteString getPaymentsAccountIdBytes() {
        Object ref = this.paymentsAccountId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.paymentsAccountId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPaymentsProfileId() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public String getPaymentsProfileId() {
        Object ref = this.paymentsProfileId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.paymentsProfileId_ = s;
        return s;
    }

    @Override
    public ByteString getPaymentsProfileIdBytes() {
        Object ref = this.paymentsProfileId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.paymentsProfileId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasIssueDate() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public String getIssueDate() {
        Object ref = this.issueDate_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.issueDate_ = s;
        return s;
    }

    @Override
    public ByteString getIssueDateBytes() {
        Object ref = this.issueDate_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.issueDate_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasDueDate() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public String getDueDate() {
        Object ref = this.dueDate_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.dueDate_ = s;
        return s;
    }

    @Override
    public ByteString getDueDateBytes() {
        Object ref = this.dueDate_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.dueDate_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasServiceDateRange() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public DateRange getServiceDateRange() {
        return this.serviceDateRange_ == null ? DateRange.getDefaultInstance() : this.serviceDateRange_;
    }

    @Override
    public DateRangeOrBuilder getServiceDateRangeOrBuilder() {
        return this.serviceDateRange_ == null ? DateRange.getDefaultInstance() : this.serviceDateRange_;
    }

    @Override
    public boolean hasCurrencyCode() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public String getCurrencyCode() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.currencyCode_ = s;
        return s;
    }

    @Override
    public ByteString getCurrencyCodeBytes() {
        Object ref = this.currencyCode_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.currencyCode_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getAdjustmentsSubtotalAmountMicros() {
        return this.adjustmentsSubtotalAmountMicros_;
    }

    @Override
    public long getAdjustmentsTaxAmountMicros() {
        return this.adjustmentsTaxAmountMicros_;
    }

    @Override
    public long getAdjustmentsTotalAmountMicros() {
        return this.adjustmentsTotalAmountMicros_;
    }

    @Override
    public long getRegulatoryCostsSubtotalAmountMicros() {
        return this.regulatoryCostsSubtotalAmountMicros_;
    }

    @Override
    public long getRegulatoryCostsTaxAmountMicros() {
        return this.regulatoryCostsTaxAmountMicros_;
    }

    @Override
    public long getRegulatoryCostsTotalAmountMicros() {
        return this.regulatoryCostsTotalAmountMicros_;
    }

    @Override
    public boolean hasExportChargeSubtotalAmountMicros() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public long getExportChargeSubtotalAmountMicros() {
        return this.exportChargeSubtotalAmountMicros_;
    }

    @Override
    public boolean hasExportChargeTaxAmountMicros() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public long getExportChargeTaxAmountMicros() {
        return this.exportChargeTaxAmountMicros_;
    }

    @Override
    public boolean hasExportChargeTotalAmountMicros() {
        return (this.bitField0_ & 0x400) != 0;
    }

    @Override
    public long getExportChargeTotalAmountMicros() {
        return this.exportChargeTotalAmountMicros_;
    }

    @Override
    public boolean hasSubtotalAmountMicros() {
        return (this.bitField0_ & 0x800) != 0;
    }

    @Override
    public long getSubtotalAmountMicros() {
        return this.subtotalAmountMicros_;
    }

    @Override
    public boolean hasTaxAmountMicros() {
        return (this.bitField0_ & 0x1000) != 0;
    }

    @Override
    public long getTaxAmountMicros() {
        return this.taxAmountMicros_;
    }

    @Override
    public boolean hasTotalAmountMicros() {
        return (this.bitField0_ & 0x2000) != 0;
    }

    @Override
    public long getTotalAmountMicros() {
        return this.totalAmountMicros_;
    }

    @Override
    public boolean hasCorrectedInvoice() {
        return (this.bitField0_ & 0x4000) != 0;
    }

    @Override
    public String getCorrectedInvoice() {
        Object ref = this.correctedInvoice_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.correctedInvoice_ = s;
        return s;
    }

    @Override
    public ByteString getCorrectedInvoiceBytes() {
        Object ref = this.correctedInvoice_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.correctedInvoice_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getReplacedInvoicesList() {
        return this.replacedInvoices_;
    }

    @Override
    public int getReplacedInvoicesCount() {
        return this.replacedInvoices_.size();
    }

    @Override
    public String getReplacedInvoices(int index) {
        return this.replacedInvoices_.get(index);
    }

    @Override
    public ByteString getReplacedInvoicesBytes(int index) {
        return this.replacedInvoices_.getByteString(index);
    }

    @Override
    public boolean hasPdfUrl() {
        return (this.bitField0_ & 0x8000) != 0;
    }

    @Override
    public String getPdfUrl() {
        Object ref = this.pdfUrl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.pdfUrl_ = s;
        return s;
    }

    @Override
    public ByteString getPdfUrlBytes() {
        Object ref = this.pdfUrl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.pdfUrl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AccountBudgetSummary> getAccountBudgetSummariesList() {
        return this.accountBudgetSummaries_;
    }

    @Override
    public List<? extends AccountBudgetSummaryOrBuilder> getAccountBudgetSummariesOrBuilderList() {
        return this.accountBudgetSummaries_;
    }

    @Override
    public int getAccountBudgetSummariesCount() {
        return this.accountBudgetSummaries_.size();
    }

    @Override
    public AccountBudgetSummary getAccountBudgetSummaries(int index) {
        return this.accountBudgetSummaries_.get(index);
    }

    @Override
    public AccountBudgetSummaryOrBuilder getAccountBudgetSummariesOrBuilder(int index) {
        return this.accountBudgetSummaries_.get(index);
    }

    @Override
    public List<AccountSummary> getAccountSummariesList() {
        return this.accountSummaries_;
    }

    @Override
    public List<? extends AccountSummaryOrBuilder> getAccountSummariesOrBuilderList() {
        return this.accountSummaries_;
    }

    @Override
    public int getAccountSummariesCount() {
        return this.accountSummaries_.size();
    }

    @Override
    public AccountSummary getAccountSummaries(int index) {
        return this.accountSummaries_.get(index);
    }

    @Override
    public AccountSummaryOrBuilder getAccountSummariesOrBuilder(int index) {
        return this.accountSummaries_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.type_ != InvoiceTypeEnum.InvoiceType.UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.type_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(9, (MessageLite)this.getServiceDateRange());
        }
        for (i = 0; i < this.accountBudgetSummaries_.size(); ++i) {
            output.writeMessage(18, (MessageLite)this.accountBudgetSummaries_.get(i));
        }
        if (this.adjustmentsSubtotalAmountMicros_ != 0L) {
            output.writeInt64(19, this.adjustmentsSubtotalAmountMicros_);
        }
        if (this.adjustmentsTaxAmountMicros_ != 0L) {
            output.writeInt64(20, this.adjustmentsTaxAmountMicros_);
        }
        if (this.adjustmentsTotalAmountMicros_ != 0L) {
            output.writeInt64(21, this.adjustmentsTotalAmountMicros_);
        }
        if (this.regulatoryCostsSubtotalAmountMicros_ != 0L) {
            output.writeInt64(22, this.regulatoryCostsSubtotalAmountMicros_);
        }
        if (this.regulatoryCostsTaxAmountMicros_ != 0L) {
            output.writeInt64(23, this.regulatoryCostsTaxAmountMicros_);
        }
        if (this.regulatoryCostsTotalAmountMicros_ != 0L) {
            output.writeInt64(24, this.regulatoryCostsTotalAmountMicros_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)25, (Object)this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)26, (Object)this.billingSetup_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)27, (Object)this.paymentsAccountId_);
        }
        if ((this.bitField0_ & 8) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)28, (Object)this.paymentsProfileId_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)29, (Object)this.issueDate_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)30, (Object)this.dueDate_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)31, (Object)this.currencyCode_);
        }
        if ((this.bitField0_ & 0x800) != 0) {
            output.writeInt64(33, this.subtotalAmountMicros_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            output.writeInt64(34, this.taxAmountMicros_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            output.writeInt64(35, this.totalAmountMicros_);
        }
        if ((this.bitField0_ & 0x4000) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)36, (Object)this.correctedInvoice_);
        }
        for (i = 0; i < this.replacedInvoices_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)37, (Object)this.replacedInvoices_.getRaw(i));
        }
        if ((this.bitField0_ & 0x8000) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)38, (Object)this.pdfUrl_);
        }
        for (i = 0; i < this.accountSummaries_.size(); ++i) {
            output.writeMessage(39, (MessageLite)this.accountSummaries_.get(i));
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeInt64(40, this.exportChargeSubtotalAmountMicros_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            output.writeInt64(41, this.exportChargeTaxAmountMicros_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            output.writeInt64(42, this.exportChargeTotalAmountMicros_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.type_ != InvoiceTypeEnum.InvoiceType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.type_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getServiceDateRange());
        }
        for (i = 0; i < this.accountBudgetSummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)((MessageLite)this.accountBudgetSummaries_.get(i)));
        }
        if (this.adjustmentsSubtotalAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)19, (long)this.adjustmentsSubtotalAmountMicros_);
        }
        if (this.adjustmentsTaxAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)20, (long)this.adjustmentsTaxAmountMicros_);
        }
        if (this.adjustmentsTotalAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)21, (long)this.adjustmentsTotalAmountMicros_);
        }
        if (this.regulatoryCostsSubtotalAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)22, (long)this.regulatoryCostsSubtotalAmountMicros_);
        }
        if (this.regulatoryCostsTaxAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)23, (long)this.regulatoryCostsTaxAmountMicros_);
        }
        if (this.regulatoryCostsTotalAmountMicros_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)24, (long)this.regulatoryCostsTotalAmountMicros_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)25, (Object)this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)26, (Object)this.billingSetup_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)27, (Object)this.paymentsAccountId_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)28, (Object)this.paymentsProfileId_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)29, (Object)this.issueDate_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)30, (Object)this.dueDate_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)31, (Object)this.currencyCode_);
        }
        if ((this.bitField0_ & 0x800) != 0) {
            size += CodedOutputStream.computeInt64Size((int)33, (long)this.subtotalAmountMicros_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            size += CodedOutputStream.computeInt64Size((int)34, (long)this.taxAmountMicros_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            size += CodedOutputStream.computeInt64Size((int)35, (long)this.totalAmountMicros_);
        }
        if ((this.bitField0_ & 0x4000) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)36, (Object)this.correctedInvoice_);
        }
        int dataSize = 0;
        for (int i2 = 0; i2 < this.replacedInvoices_.size(); ++i2) {
            dataSize += Invoice.computeStringSizeNoTag((Object)this.replacedInvoices_.getRaw(i2));
        }
        size += dataSize;
        size += 2 * this.getReplacedInvoicesList().size();
        if ((this.bitField0_ & 0x8000) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)38, (Object)this.pdfUrl_);
        }
        for (i = 0; i < this.accountSummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)39, (MessageLite)((MessageLite)this.accountSummaries_.get(i)));
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeInt64Size((int)40, (long)this.exportChargeSubtotalAmountMicros_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            size += CodedOutputStream.computeInt64Size((int)41, (long)this.exportChargeTaxAmountMicros_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            size += CodedOutputStream.computeInt64Size((int)42, (long)this.exportChargeTotalAmountMicros_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Invoice)) {
            return super.equals(obj);
        }
        Invoice other = (Invoice)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasId() != other.hasId()) {
            return false;
        }
        if (this.hasId() && !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.hasBillingSetup() != other.hasBillingSetup()) {
            return false;
        }
        if (this.hasBillingSetup() && !this.getBillingSetup().equals(other.getBillingSetup())) {
            return false;
        }
        if (this.hasPaymentsAccountId() != other.hasPaymentsAccountId()) {
            return false;
        }
        if (this.hasPaymentsAccountId() && !this.getPaymentsAccountId().equals(other.getPaymentsAccountId())) {
            return false;
        }
        if (this.hasPaymentsProfileId() != other.hasPaymentsProfileId()) {
            return false;
        }
        if (this.hasPaymentsProfileId() && !this.getPaymentsProfileId().equals(other.getPaymentsProfileId())) {
            return false;
        }
        if (this.hasIssueDate() != other.hasIssueDate()) {
            return false;
        }
        if (this.hasIssueDate() && !this.getIssueDate().equals(other.getIssueDate())) {
            return false;
        }
        if (this.hasDueDate() != other.hasDueDate()) {
            return false;
        }
        if (this.hasDueDate() && !this.getDueDate().equals(other.getDueDate())) {
            return false;
        }
        if (this.hasServiceDateRange() != other.hasServiceDateRange()) {
            return false;
        }
        if (this.hasServiceDateRange() && !this.getServiceDateRange().equals(other.getServiceDateRange())) {
            return false;
        }
        if (this.hasCurrencyCode() != other.hasCurrencyCode()) {
            return false;
        }
        if (this.hasCurrencyCode() && !this.getCurrencyCode().equals(other.getCurrencyCode())) {
            return false;
        }
        if (this.getAdjustmentsSubtotalAmountMicros() != other.getAdjustmentsSubtotalAmountMicros()) {
            return false;
        }
        if (this.getAdjustmentsTaxAmountMicros() != other.getAdjustmentsTaxAmountMicros()) {
            return false;
        }
        if (this.getAdjustmentsTotalAmountMicros() != other.getAdjustmentsTotalAmountMicros()) {
            return false;
        }
        if (this.getRegulatoryCostsSubtotalAmountMicros() != other.getRegulatoryCostsSubtotalAmountMicros()) {
            return false;
        }
        if (this.getRegulatoryCostsTaxAmountMicros() != other.getRegulatoryCostsTaxAmountMicros()) {
            return false;
        }
        if (this.getRegulatoryCostsTotalAmountMicros() != other.getRegulatoryCostsTotalAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeSubtotalAmountMicros() != other.hasExportChargeSubtotalAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeSubtotalAmountMicros() && this.getExportChargeSubtotalAmountMicros() != other.getExportChargeSubtotalAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeTaxAmountMicros() != other.hasExportChargeTaxAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeTaxAmountMicros() && this.getExportChargeTaxAmountMicros() != other.getExportChargeTaxAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeTotalAmountMicros() != other.hasExportChargeTotalAmountMicros()) {
            return false;
        }
        if (this.hasExportChargeTotalAmountMicros() && this.getExportChargeTotalAmountMicros() != other.getExportChargeTotalAmountMicros()) {
            return false;
        }
        if (this.hasSubtotalAmountMicros() != other.hasSubtotalAmountMicros()) {
            return false;
        }
        if (this.hasSubtotalAmountMicros() && this.getSubtotalAmountMicros() != other.getSubtotalAmountMicros()) {
            return false;
        }
        if (this.hasTaxAmountMicros() != other.hasTaxAmountMicros()) {
            return false;
        }
        if (this.hasTaxAmountMicros() && this.getTaxAmountMicros() != other.getTaxAmountMicros()) {
            return false;
        }
        if (this.hasTotalAmountMicros() != other.hasTotalAmountMicros()) {
            return false;
        }
        if (this.hasTotalAmountMicros() && this.getTotalAmountMicros() != other.getTotalAmountMicros()) {
            return false;
        }
        if (this.hasCorrectedInvoice() != other.hasCorrectedInvoice()) {
            return false;
        }
        if (this.hasCorrectedInvoice() && !this.getCorrectedInvoice().equals(other.getCorrectedInvoice())) {
            return false;
        }
        if (!this.getReplacedInvoicesList().equals(other.getReplacedInvoicesList())) {
            return false;
        }
        if (this.hasPdfUrl() != other.hasPdfUrl()) {
            return false;
        }
        if (this.hasPdfUrl() && !this.getPdfUrl().equals(other.getPdfUrl())) {
            return false;
        }
        if (!this.getAccountBudgetSummariesList().equals(other.getAccountBudgetSummariesList())) {
            return false;
        }
        if (!this.getAccountSummariesList().equals(other.getAccountSummariesList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Invoice.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasId()) {
            hash = 37 * hash + 25;
            hash = 53 * hash + this.getId().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.type_;
        if (this.hasBillingSetup()) {
            hash = 37 * hash + 26;
            hash = 53 * hash + this.getBillingSetup().hashCode();
        }
        if (this.hasPaymentsAccountId()) {
            hash = 37 * hash + 27;
            hash = 53 * hash + this.getPaymentsAccountId().hashCode();
        }
        if (this.hasPaymentsProfileId()) {
            hash = 37 * hash + 28;
            hash = 53 * hash + this.getPaymentsProfileId().hashCode();
        }
        if (this.hasIssueDate()) {
            hash = 37 * hash + 29;
            hash = 53 * hash + this.getIssueDate().hashCode();
        }
        if (this.hasDueDate()) {
            hash = 37 * hash + 30;
            hash = 53 * hash + this.getDueDate().hashCode();
        }
        if (this.hasServiceDateRange()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getServiceDateRange().hashCode();
        }
        if (this.hasCurrencyCode()) {
            hash = 37 * hash + 31;
            hash = 53 * hash + this.getCurrencyCode().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + Internal.hashLong((long)this.getAdjustmentsSubtotalAmountMicros());
        hash = 37 * hash + 20;
        hash = 53 * hash + Internal.hashLong((long)this.getAdjustmentsTaxAmountMicros());
        hash = 37 * hash + 21;
        hash = 53 * hash + Internal.hashLong((long)this.getAdjustmentsTotalAmountMicros());
        hash = 37 * hash + 22;
        hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsSubtotalAmountMicros());
        hash = 37 * hash + 23;
        hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsTaxAmountMicros());
        hash = 37 * hash + 24;
        hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsTotalAmountMicros());
        if (this.hasExportChargeSubtotalAmountMicros()) {
            hash = 37 * hash + 40;
            hash = 53 * hash + Internal.hashLong((long)this.getExportChargeSubtotalAmountMicros());
        }
        if (this.hasExportChargeTaxAmountMicros()) {
            hash = 37 * hash + 41;
            hash = 53 * hash + Internal.hashLong((long)this.getExportChargeTaxAmountMicros());
        }
        if (this.hasExportChargeTotalAmountMicros()) {
            hash = 37 * hash + 42;
            hash = 53 * hash + Internal.hashLong((long)this.getExportChargeTotalAmountMicros());
        }
        if (this.hasSubtotalAmountMicros()) {
            hash = 37 * hash + 33;
            hash = 53 * hash + Internal.hashLong((long)this.getSubtotalAmountMicros());
        }
        if (this.hasTaxAmountMicros()) {
            hash = 37 * hash + 34;
            hash = 53 * hash + Internal.hashLong((long)this.getTaxAmountMicros());
        }
        if (this.hasTotalAmountMicros()) {
            hash = 37 * hash + 35;
            hash = 53 * hash + Internal.hashLong((long)this.getTotalAmountMicros());
        }
        if (this.hasCorrectedInvoice()) {
            hash = 37 * hash + 36;
            hash = 53 * hash + this.getCorrectedInvoice().hashCode();
        }
        if (this.getReplacedInvoicesCount() > 0) {
            hash = 37 * hash + 37;
            hash = 53 * hash + this.getReplacedInvoicesList().hashCode();
        }
        if (this.hasPdfUrl()) {
            hash = 37 * hash + 38;
            hash = 53 * hash + this.getPdfUrl().hashCode();
        }
        if (this.getAccountBudgetSummariesCount() > 0) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getAccountBudgetSummariesList().hashCode();
        }
        if (this.getAccountSummariesCount() > 0) {
            hash = 37 * hash + 39;
            hash = 53 * hash + this.getAccountSummariesList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Invoice parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data);
    }

    public static Invoice parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Invoice parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data);
    }

    public static Invoice parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Invoice parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data);
    }

    public static Invoice parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Invoice)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Invoice parseFrom(InputStream input) throws IOException {
        return (Invoice)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Invoice parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Invoice)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Invoice parseDelimitedFrom(InputStream input) throws IOException {
        return (Invoice)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Invoice parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Invoice)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Invoice parseFrom(CodedInputStream input) throws IOException {
        return (Invoice)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Invoice parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Invoice)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Invoice.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Invoice prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Invoice getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Invoice> parser() {
        return PARSER;
    }

    public Parser<Invoice> getParserForType() {
        return PARSER;
    }

    public Invoice getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements InvoiceOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object id_ = "";
        private int type_ = 0;
        private Object billingSetup_ = "";
        private Object paymentsAccountId_ = "";
        private Object paymentsProfileId_ = "";
        private Object issueDate_ = "";
        private Object dueDate_ = "";
        private DateRange serviceDateRange_;
        private SingleFieldBuilderV3<DateRange, DateRange.Builder, DateRangeOrBuilder> serviceDateRangeBuilder_;
        private Object currencyCode_ = "";
        private long adjustmentsSubtotalAmountMicros_;
        private long adjustmentsTaxAmountMicros_;
        private long adjustmentsTotalAmountMicros_;
        private long regulatoryCostsSubtotalAmountMicros_;
        private long regulatoryCostsTaxAmountMicros_;
        private long regulatoryCostsTotalAmountMicros_;
        private long exportChargeSubtotalAmountMicros_;
        private long exportChargeTaxAmountMicros_;
        private long exportChargeTotalAmountMicros_;
        private long subtotalAmountMicros_;
        private long taxAmountMicros_;
        private long totalAmountMicros_;
        private Object correctedInvoice_ = "";
        private LazyStringArrayList replacedInvoices_ = LazyStringArrayList.emptyList();
        private Object pdfUrl_ = "";
        private List<AccountBudgetSummary> accountBudgetSummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AccountBudgetSummary, AccountBudgetSummary.Builder, AccountBudgetSummaryOrBuilder> accountBudgetSummariesBuilder_;
        private List<AccountSummary> accountSummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AccountSummary, AccountSummary.Builder, AccountSummaryOrBuilder> accountSummariesBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_fieldAccessorTable.ensureFieldAccessorsInitialized(Invoice.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getServiceDateRangeFieldBuilder();
                this.getAccountBudgetSummariesFieldBuilder();
                this.getAccountSummariesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = "";
            this.type_ = 0;
            this.billingSetup_ = "";
            this.paymentsAccountId_ = "";
            this.paymentsProfileId_ = "";
            this.issueDate_ = "";
            this.dueDate_ = "";
            this.serviceDateRange_ = null;
            if (this.serviceDateRangeBuilder_ != null) {
                this.serviceDateRangeBuilder_.dispose();
                this.serviceDateRangeBuilder_ = null;
            }
            this.currencyCode_ = "";
            this.adjustmentsSubtotalAmountMicros_ = 0L;
            this.adjustmentsTaxAmountMicros_ = 0L;
            this.adjustmentsTotalAmountMicros_ = 0L;
            this.regulatoryCostsSubtotalAmountMicros_ = 0L;
            this.regulatoryCostsTaxAmountMicros_ = 0L;
            this.regulatoryCostsTotalAmountMicros_ = 0L;
            this.exportChargeSubtotalAmountMicros_ = 0L;
            this.exportChargeTaxAmountMicros_ = 0L;
            this.exportChargeTotalAmountMicros_ = 0L;
            this.subtotalAmountMicros_ = 0L;
            this.taxAmountMicros_ = 0L;
            this.totalAmountMicros_ = 0L;
            this.correctedInvoice_ = "";
            this.replacedInvoices_ = LazyStringArrayList.emptyList();
            this.pdfUrl_ = "";
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.accountBudgetSummaries_ = Collections.emptyList();
            } else {
                this.accountBudgetSummaries_ = null;
                this.accountBudgetSummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFDFFFFFF;
            if (this.accountSummariesBuilder_ == null) {
                this.accountSummaries_ = Collections.emptyList();
            } else {
                this.accountSummaries_ = null;
                this.accountSummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFBFFFFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_descriptor;
        }

        public Invoice getDefaultInstanceForType() {
            return Invoice.getDefaultInstance();
        }

        public Invoice build() {
            Invoice result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Invoice buildPartial() {
            Invoice result = new Invoice(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Invoice result) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x2000000) != 0) {
                    this.accountBudgetSummaries_ = Collections.unmodifiableList(this.accountBudgetSummaries_);
                    this.bitField0_ &= 0xFDFFFFFF;
                }
                result.accountBudgetSummaries_ = this.accountBudgetSummaries_;
            } else {
                result.accountBudgetSummaries_ = this.accountBudgetSummariesBuilder_.build();
            }
            if (this.accountSummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x4000000) != 0) {
                    this.accountSummaries_ = Collections.unmodifiableList(this.accountSummaries_);
                    this.bitField0_ &= 0xFBFFFFFF;
                }
                result.accountSummaries_ = this.accountSummaries_;
            } else {
                result.accountSummaries_ = this.accountSummariesBuilder_.build();
            }
        }

        private void buildPartial0(Invoice result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.billingSetup_ = this.billingSetup_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.paymentsAccountId_ = this.paymentsAccountId_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.paymentsProfileId_ = this.paymentsProfileId_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.issueDate_ = this.issueDate_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.dueDate_ = this.dueDate_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.serviceDateRange_ = this.serviceDateRangeBuilder_ == null ? this.serviceDateRange_ : (DateRange)this.serviceDateRangeBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.currencyCode_ = this.currencyCode_;
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.adjustmentsSubtotalAmountMicros_ = this.adjustmentsSubtotalAmountMicros_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.adjustmentsTaxAmountMicros_ = this.adjustmentsTaxAmountMicros_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.adjustmentsTotalAmountMicros_ = this.adjustmentsTotalAmountMicros_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.regulatoryCostsSubtotalAmountMicros_ = this.regulatoryCostsSubtotalAmountMicros_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.regulatoryCostsTaxAmountMicros_ = this.regulatoryCostsTaxAmountMicros_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.regulatoryCostsTotalAmountMicros_ = this.regulatoryCostsTotalAmountMicros_;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.exportChargeSubtotalAmountMicros_ = this.exportChargeSubtotalAmountMicros_;
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.exportChargeTaxAmountMicros_ = this.exportChargeTaxAmountMicros_;
                to_bitField0_ |= 0x200;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.exportChargeTotalAmountMicros_ = this.exportChargeTotalAmountMicros_;
                to_bitField0_ |= 0x400;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.subtotalAmountMicros_ = this.subtotalAmountMicros_;
                to_bitField0_ |= 0x800;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.taxAmountMicros_ = this.taxAmountMicros_;
                to_bitField0_ |= 0x1000;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.totalAmountMicros_ = this.totalAmountMicros_;
                to_bitField0_ |= 0x2000;
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.correctedInvoice_ = this.correctedInvoice_;
                to_bitField0_ |= 0x4000;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                this.replacedInvoices_.makeImmutable();
                result.replacedInvoices_ = this.replacedInvoices_;
            }
            if ((from_bitField0_ & 0x1000000) != 0) {
                result.pdfUrl_ = this.pdfUrl_;
                to_bitField0_ |= 0x8000;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Invoice) {
                return this.mergeFrom((Invoice)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Invoice other) {
            if (other == Invoice.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasId()) {
                this.id_ = other.id_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.hasBillingSetup()) {
                this.billingSetup_ = other.billingSetup_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.hasPaymentsAccountId()) {
                this.paymentsAccountId_ = other.paymentsAccountId_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.hasPaymentsProfileId()) {
                this.paymentsProfileId_ = other.paymentsProfileId_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.hasIssueDate()) {
                this.issueDate_ = other.issueDate_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasDueDate()) {
                this.dueDate_ = other.dueDate_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (other.hasServiceDateRange()) {
                this.mergeServiceDateRange(other.getServiceDateRange());
            }
            if (other.hasCurrencyCode()) {
                this.currencyCode_ = other.currencyCode_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (other.getAdjustmentsSubtotalAmountMicros() != 0L) {
                this.setAdjustmentsSubtotalAmountMicros(other.getAdjustmentsSubtotalAmountMicros());
            }
            if (other.getAdjustmentsTaxAmountMicros() != 0L) {
                this.setAdjustmentsTaxAmountMicros(other.getAdjustmentsTaxAmountMicros());
            }
            if (other.getAdjustmentsTotalAmountMicros() != 0L) {
                this.setAdjustmentsTotalAmountMicros(other.getAdjustmentsTotalAmountMicros());
            }
            if (other.getRegulatoryCostsSubtotalAmountMicros() != 0L) {
                this.setRegulatoryCostsSubtotalAmountMicros(other.getRegulatoryCostsSubtotalAmountMicros());
            }
            if (other.getRegulatoryCostsTaxAmountMicros() != 0L) {
                this.setRegulatoryCostsTaxAmountMicros(other.getRegulatoryCostsTaxAmountMicros());
            }
            if (other.getRegulatoryCostsTotalAmountMicros() != 0L) {
                this.setRegulatoryCostsTotalAmountMicros(other.getRegulatoryCostsTotalAmountMicros());
            }
            if (other.hasExportChargeSubtotalAmountMicros()) {
                this.setExportChargeSubtotalAmountMicros(other.getExportChargeSubtotalAmountMicros());
            }
            if (other.hasExportChargeTaxAmountMicros()) {
                this.setExportChargeTaxAmountMicros(other.getExportChargeTaxAmountMicros());
            }
            if (other.hasExportChargeTotalAmountMicros()) {
                this.setExportChargeTotalAmountMicros(other.getExportChargeTotalAmountMicros());
            }
            if (other.hasSubtotalAmountMicros()) {
                this.setSubtotalAmountMicros(other.getSubtotalAmountMicros());
            }
            if (other.hasTaxAmountMicros()) {
                this.setTaxAmountMicros(other.getTaxAmountMicros());
            }
            if (other.hasTotalAmountMicros()) {
                this.setTotalAmountMicros(other.getTotalAmountMicros());
            }
            if (other.hasCorrectedInvoice()) {
                this.correctedInvoice_ = other.correctedInvoice_;
                this.bitField0_ |= 0x400000;
                this.onChanged();
            }
            if (!other.replacedInvoices_.isEmpty()) {
                if (this.replacedInvoices_.isEmpty()) {
                    this.replacedInvoices_ = other.replacedInvoices_;
                    this.bitField0_ |= 0x800000;
                } else {
                    this.ensureReplacedInvoicesIsMutable();
                    this.replacedInvoices_.addAll((Collection)other.replacedInvoices_);
                }
                this.onChanged();
            }
            if (other.hasPdfUrl()) {
                this.pdfUrl_ = other.pdfUrl_;
                this.bitField0_ |= 0x1000000;
                this.onChanged();
            }
            if (this.accountBudgetSummariesBuilder_ == null) {
                if (!other.accountBudgetSummaries_.isEmpty()) {
                    if (this.accountBudgetSummaries_.isEmpty()) {
                        this.accountBudgetSummaries_ = other.accountBudgetSummaries_;
                        this.bitField0_ &= 0xFDFFFFFF;
                    } else {
                        this.ensureAccountBudgetSummariesIsMutable();
                        this.accountBudgetSummaries_.addAll(other.accountBudgetSummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.accountBudgetSummaries_.isEmpty()) {
                if (this.accountBudgetSummariesBuilder_.isEmpty()) {
                    this.accountBudgetSummariesBuilder_.dispose();
                    this.accountBudgetSummariesBuilder_ = null;
                    this.accountBudgetSummaries_ = other.accountBudgetSummaries_;
                    this.bitField0_ &= 0xFDFFFFFF;
                    this.accountBudgetSummariesBuilder_ = alwaysUseFieldBuilders ? this.getAccountBudgetSummariesFieldBuilder() : null;
                } else {
                    this.accountBudgetSummariesBuilder_.addAllMessages((Iterable)other.accountBudgetSummaries_);
                }
            }
            if (this.accountSummariesBuilder_ == null) {
                if (!other.accountSummaries_.isEmpty()) {
                    if (this.accountSummaries_.isEmpty()) {
                        this.accountSummaries_ = other.accountSummaries_;
                        this.bitField0_ &= 0xFBFFFFFF;
                    } else {
                        this.ensureAccountSummariesIsMutable();
                        this.accountSummaries_.addAll(other.accountSummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.accountSummaries_.isEmpty()) {
                if (this.accountSummariesBuilder_.isEmpty()) {
                    this.accountSummariesBuilder_.dispose();
                    this.accountSummariesBuilder_ = null;
                    this.accountSummaries_ = other.accountSummaries_;
                    this.bitField0_ &= 0xFBFFFFFF;
                    this.accountSummariesBuilder_ = alwaysUseFieldBuilders ? this.getAccountSummariesFieldBuilder() : null;
                } else {
                    this.accountSummariesBuilder_.addAllMessages((Iterable)other.accountSummaries_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block35: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block35;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block35;
                        }
                        case 24: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block35;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getServiceDateRangeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block35;
                        }
                        case 146: {
                            GeneratedMessageV3 m = (AccountBudgetSummary)input.readMessage(AccountBudgetSummary.parser(), extensionRegistry);
                            if (this.accountBudgetSummariesBuilder_ == null) {
                                this.ensureAccountBudgetSummariesIsMutable();
                                this.accountBudgetSummaries_.add((AccountBudgetSummary)m);
                                continue block35;
                            }
                            this.accountBudgetSummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block35;
                        }
                        case 152: {
                            this.adjustmentsSubtotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x400;
                            continue block35;
                        }
                        case 160: {
                            this.adjustmentsTaxAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x800;
                            continue block35;
                        }
                        case 168: {
                            this.adjustmentsTotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x1000;
                            continue block35;
                        }
                        case 176: {
                            this.regulatoryCostsSubtotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x2000;
                            continue block35;
                        }
                        case 184: {
                            this.regulatoryCostsTaxAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x4000;
                            continue block35;
                        }
                        case 192: {
                            this.regulatoryCostsTotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x8000;
                            continue block35;
                        }
                        case 202: {
                            this.id_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block35;
                        }
                        case 210: {
                            this.billingSetup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block35;
                        }
                        case 218: {
                            this.paymentsAccountId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block35;
                        }
                        case 226: {
                            this.paymentsProfileId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block35;
                        }
                        case 234: {
                            this.issueDate_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block35;
                        }
                        case 242: {
                            this.dueDate_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block35;
                        }
                        case 250: {
                            this.currencyCode_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block35;
                        }
                        case 264: {
                            this.subtotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x80000;
                            continue block35;
                        }
                        case 272: {
                            this.taxAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x100000;
                            continue block35;
                        }
                        case 280: {
                            this.totalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x200000;
                            continue block35;
                        }
                        case 290: {
                            this.correctedInvoice_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400000;
                            continue block35;
                        }
                        case 298: {
                            String s = input.readStringRequireUtf8();
                            this.ensureReplacedInvoicesIsMutable();
                            this.replacedInvoices_.add((Object)s);
                            continue block35;
                        }
                        case 306: {
                            this.pdfUrl_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000000;
                            continue block35;
                        }
                        case 314: {
                            GeneratedMessageV3 m = (AccountSummary)input.readMessage(AccountSummary.parser(), extensionRegistry);
                            if (this.accountSummariesBuilder_ == null) {
                                this.ensureAccountSummariesIsMutable();
                                this.accountSummaries_.add((AccountSummary)m);
                                continue block35;
                            }
                            this.accountSummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block35;
                        }
                        case 320: {
                            this.exportChargeSubtotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x10000;
                            continue block35;
                        }
                        case 328: {
                            this.exportChargeTaxAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x20000;
                            continue block35;
                        }
                        case 336: {
                            this.exportChargeTotalAmountMicros_ = input.readInt64();
                            this.bitField0_ |= 0x40000;
                            continue block35;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = Invoice.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasId() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = Invoice.getDefaultInstance().getId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public InvoiceTypeEnum.InvoiceType getType() {
            InvoiceTypeEnum.InvoiceType result = InvoiceTypeEnum.InvoiceType.forNumber(this.type_);
            return result == null ? InvoiceTypeEnum.InvoiceType.UNRECOGNIZED : result;
        }

        public Builder setType(InvoiceTypeEnum.InvoiceType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBillingSetup() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public String getBillingSetup() {
            Object ref = this.billingSetup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.billingSetup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getBillingSetupBytes() {
            Object ref = this.billingSetup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.billingSetup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setBillingSetup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.billingSetup_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearBillingSetup() {
            this.billingSetup_ = Invoice.getDefaultInstance().getBillingSetup();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setBillingSetupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.billingSetup_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPaymentsAccountId() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getPaymentsAccountId() {
            Object ref = this.paymentsAccountId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.paymentsAccountId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPaymentsAccountIdBytes() {
            Object ref = this.paymentsAccountId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.paymentsAccountId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPaymentsAccountId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.paymentsAccountId_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPaymentsAccountId() {
            this.paymentsAccountId_ = Invoice.getDefaultInstance().getPaymentsAccountId();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setPaymentsAccountIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.paymentsAccountId_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPaymentsProfileId() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public String getPaymentsProfileId() {
            Object ref = this.paymentsProfileId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.paymentsProfileId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPaymentsProfileIdBytes() {
            Object ref = this.paymentsProfileId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.paymentsProfileId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPaymentsProfileId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.paymentsProfileId_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearPaymentsProfileId() {
            this.paymentsProfileId_ = Invoice.getDefaultInstance().getPaymentsProfileId();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setPaymentsProfileIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.paymentsProfileId_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasIssueDate() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public String getIssueDate() {
            Object ref = this.issueDate_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.issueDate_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIssueDateBytes() {
            Object ref = this.issueDate_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.issueDate_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setIssueDate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.issueDate_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearIssueDate() {
            this.issueDate_ = Invoice.getDefaultInstance().getIssueDate();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setIssueDateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.issueDate_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDueDate() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getDueDate() {
            Object ref = this.dueDate_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.dueDate_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDueDateBytes() {
            Object ref = this.dueDate_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.dueDate_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDueDate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.dueDate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearDueDate() {
            this.dueDate_ = Invoice.getDefaultInstance().getDueDate();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setDueDateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.dueDate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasServiceDateRange() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public DateRange getServiceDateRange() {
            if (this.serviceDateRangeBuilder_ == null) {
                return this.serviceDateRange_ == null ? DateRange.getDefaultInstance() : this.serviceDateRange_;
            }
            return (DateRange)this.serviceDateRangeBuilder_.getMessage();
        }

        public Builder setServiceDateRange(DateRange value) {
            if (this.serviceDateRangeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.serviceDateRange_ = value;
            } else {
                this.serviceDateRangeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setServiceDateRange(DateRange.Builder builderForValue) {
            if (this.serviceDateRangeBuilder_ == null) {
                this.serviceDateRange_ = builderForValue.build();
            } else {
                this.serviceDateRangeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeServiceDateRange(DateRange value) {
            if (this.serviceDateRangeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.serviceDateRange_ != null && this.serviceDateRange_ != DateRange.getDefaultInstance()) {
                    this.getServiceDateRangeBuilder().mergeFrom(value);
                } else {
                    this.serviceDateRange_ = value;
                }
            } else {
                this.serviceDateRangeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.serviceDateRange_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearServiceDateRange() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.serviceDateRange_ = null;
            if (this.serviceDateRangeBuilder_ != null) {
                this.serviceDateRangeBuilder_.dispose();
                this.serviceDateRangeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DateRange.Builder getServiceDateRangeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (DateRange.Builder)this.getServiceDateRangeFieldBuilder().getBuilder();
        }

        @Override
        public DateRangeOrBuilder getServiceDateRangeOrBuilder() {
            if (this.serviceDateRangeBuilder_ != null) {
                return (DateRangeOrBuilder)this.serviceDateRangeBuilder_.getMessageOrBuilder();
            }
            return this.serviceDateRange_ == null ? DateRange.getDefaultInstance() : this.serviceDateRange_;
        }

        private SingleFieldBuilderV3<DateRange, DateRange.Builder, DateRangeOrBuilder> getServiceDateRangeFieldBuilder() {
            if (this.serviceDateRangeBuilder_ == null) {
                this.serviceDateRangeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getServiceDateRange(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.serviceDateRange_ = null;
            }
            return this.serviceDateRangeBuilder_;
        }

        @Override
        public boolean hasCurrencyCode() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public String getCurrencyCode() {
            Object ref = this.currencyCode_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.currencyCode_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCurrencyCodeBytes() {
            Object ref = this.currencyCode_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.currencyCode_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCurrencyCode(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.currencyCode_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearCurrencyCode() {
            this.currencyCode_ = Invoice.getDefaultInstance().getCurrencyCode();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setCurrencyCodeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.currencyCode_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public long getAdjustmentsSubtotalAmountMicros() {
            return this.adjustmentsSubtotalAmountMicros_;
        }

        public Builder setAdjustmentsSubtotalAmountMicros(long value) {
            this.adjustmentsSubtotalAmountMicros_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearAdjustmentsSubtotalAmountMicros() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.adjustmentsSubtotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getAdjustmentsTaxAmountMicros() {
            return this.adjustmentsTaxAmountMicros_;
        }

        public Builder setAdjustmentsTaxAmountMicros(long value) {
            this.adjustmentsTaxAmountMicros_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearAdjustmentsTaxAmountMicros() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.adjustmentsTaxAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getAdjustmentsTotalAmountMicros() {
            return this.adjustmentsTotalAmountMicros_;
        }

        public Builder setAdjustmentsTotalAmountMicros(long value) {
            this.adjustmentsTotalAmountMicros_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearAdjustmentsTotalAmountMicros() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.adjustmentsTotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getRegulatoryCostsSubtotalAmountMicros() {
            return this.regulatoryCostsSubtotalAmountMicros_;
        }

        public Builder setRegulatoryCostsSubtotalAmountMicros(long value) {
            this.regulatoryCostsSubtotalAmountMicros_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearRegulatoryCostsSubtotalAmountMicros() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.regulatoryCostsSubtotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getRegulatoryCostsTaxAmountMicros() {
            return this.regulatoryCostsTaxAmountMicros_;
        }

        public Builder setRegulatoryCostsTaxAmountMicros(long value) {
            this.regulatoryCostsTaxAmountMicros_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearRegulatoryCostsTaxAmountMicros() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.regulatoryCostsTaxAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getRegulatoryCostsTotalAmountMicros() {
            return this.regulatoryCostsTotalAmountMicros_;
        }

        public Builder setRegulatoryCostsTotalAmountMicros(long value) {
            this.regulatoryCostsTotalAmountMicros_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearRegulatoryCostsTotalAmountMicros() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.regulatoryCostsTotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExportChargeSubtotalAmountMicros() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public long getExportChargeSubtotalAmountMicros() {
            return this.exportChargeSubtotalAmountMicros_;
        }

        public Builder setExportChargeSubtotalAmountMicros(long value) {
            this.exportChargeSubtotalAmountMicros_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearExportChargeSubtotalAmountMicros() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.exportChargeSubtotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExportChargeTaxAmountMicros() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public long getExportChargeTaxAmountMicros() {
            return this.exportChargeTaxAmountMicros_;
        }

        public Builder setExportChargeTaxAmountMicros(long value) {
            this.exportChargeTaxAmountMicros_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearExportChargeTaxAmountMicros() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.exportChargeTaxAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasExportChargeTotalAmountMicros() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public long getExportChargeTotalAmountMicros() {
            return this.exportChargeTotalAmountMicros_;
        }

        public Builder setExportChargeTotalAmountMicros(long value) {
            this.exportChargeTotalAmountMicros_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearExportChargeTotalAmountMicros() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.exportChargeTotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasSubtotalAmountMicros() {
            return (this.bitField0_ & 0x80000) != 0;
        }

        @Override
        public long getSubtotalAmountMicros() {
            return this.subtotalAmountMicros_;
        }

        public Builder setSubtotalAmountMicros(long value) {
            this.subtotalAmountMicros_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        public Builder clearSubtotalAmountMicros() {
            this.bitField0_ &= 0xFFF7FFFF;
            this.subtotalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTaxAmountMicros() {
            return (this.bitField0_ & 0x100000) != 0;
        }

        @Override
        public long getTaxAmountMicros() {
            return this.taxAmountMicros_;
        }

        public Builder setTaxAmountMicros(long value) {
            this.taxAmountMicros_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder clearTaxAmountMicros() {
            this.bitField0_ &= 0xFFEFFFFF;
            this.taxAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTotalAmountMicros() {
            return (this.bitField0_ & 0x200000) != 0;
        }

        @Override
        public long getTotalAmountMicros() {
            return this.totalAmountMicros_;
        }

        public Builder setTotalAmountMicros(long value) {
            this.totalAmountMicros_ = value;
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder clearTotalAmountMicros() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.totalAmountMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCorrectedInvoice() {
            return (this.bitField0_ & 0x400000) != 0;
        }

        @Override
        public String getCorrectedInvoice() {
            Object ref = this.correctedInvoice_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.correctedInvoice_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCorrectedInvoiceBytes() {
            Object ref = this.correctedInvoice_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.correctedInvoice_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCorrectedInvoice(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.correctedInvoice_ = value;
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder clearCorrectedInvoice() {
            this.correctedInvoice_ = Invoice.getDefaultInstance().getCorrectedInvoice();
            this.bitField0_ &= 0xFFBFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setCorrectedInvoiceBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.correctedInvoice_ = value;
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        private void ensureReplacedInvoicesIsMutable() {
            if (!this.replacedInvoices_.isModifiable()) {
                this.replacedInvoices_ = new LazyStringArrayList((LazyStringList)this.replacedInvoices_);
            }
            this.bitField0_ |= 0x800000;
        }

        public ProtocolStringList getReplacedInvoicesList() {
            this.replacedInvoices_.makeImmutable();
            return this.replacedInvoices_;
        }

        @Override
        public int getReplacedInvoicesCount() {
            return this.replacedInvoices_.size();
        }

        @Override
        public String getReplacedInvoices(int index) {
            return this.replacedInvoices_.get(index);
        }

        @Override
        public ByteString getReplacedInvoicesBytes(int index) {
            return this.replacedInvoices_.getByteString(index);
        }

        public Builder setReplacedInvoices(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReplacedInvoicesIsMutable();
            this.replacedInvoices_.set(index, value);
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder addReplacedInvoices(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureReplacedInvoicesIsMutable();
            this.replacedInvoices_.add((Object)value);
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder addAllReplacedInvoices(Iterable<String> values) {
            this.ensureReplacedInvoicesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.replacedInvoices_);
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder clearReplacedInvoices() {
            this.replacedInvoices_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFF7FFFFF;
            this.onChanged();
            return this;
        }

        public Builder addReplacedInvoicesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.ensureReplacedInvoicesIsMutable();
            this.replacedInvoices_.add(value);
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPdfUrl() {
            return (this.bitField0_ & 0x1000000) != 0;
        }

        @Override
        public String getPdfUrl() {
            Object ref = this.pdfUrl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.pdfUrl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPdfUrlBytes() {
            Object ref = this.pdfUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pdfUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPdfUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pdfUrl_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        public Builder clearPdfUrl() {
            this.pdfUrl_ = Invoice.getDefaultInstance().getPdfUrl();
            this.bitField0_ &= 0xFEFFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setPdfUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Invoice.checkByteStringIsUtf8((ByteString)value);
            this.pdfUrl_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        private void ensureAccountBudgetSummariesIsMutable() {
            if ((this.bitField0_ & 0x2000000) == 0) {
                this.accountBudgetSummaries_ = new ArrayList<AccountBudgetSummary>(this.accountBudgetSummaries_);
                this.bitField0_ |= 0x2000000;
            }
        }

        @Override
        public List<AccountBudgetSummary> getAccountBudgetSummariesList() {
            if (this.accountBudgetSummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.accountBudgetSummaries_);
            }
            return this.accountBudgetSummariesBuilder_.getMessageList();
        }

        @Override
        public int getAccountBudgetSummariesCount() {
            if (this.accountBudgetSummariesBuilder_ == null) {
                return this.accountBudgetSummaries_.size();
            }
            return this.accountBudgetSummariesBuilder_.getCount();
        }

        @Override
        public AccountBudgetSummary getAccountBudgetSummaries(int index) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                return this.accountBudgetSummaries_.get(index);
            }
            return (AccountBudgetSummary)this.accountBudgetSummariesBuilder_.getMessage(index);
        }

        public Builder setAccountBudgetSummaries(int index, AccountBudgetSummary value) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.set(index, value);
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAccountBudgetSummaries(int index, AccountBudgetSummary.Builder builderForValue) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccountBudgetSummaries(AccountBudgetSummary value) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.add(value);
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccountBudgetSummaries(int index, AccountBudgetSummary value) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.add(index, value);
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccountBudgetSummaries(AccountBudgetSummary.Builder builderForValue) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccountBudgetSummaries(int index, AccountBudgetSummary.Builder builderForValue) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAccountBudgetSummaries(Iterable<? extends AccountBudgetSummary> values) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.ensureAccountBudgetSummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.accountBudgetSummaries_);
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAccountBudgetSummaries() {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.accountBudgetSummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFDFFFFFF;
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAccountBudgetSummaries(int index) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.ensureAccountBudgetSummariesIsMutable();
                this.accountBudgetSummaries_.remove(index);
                this.onChanged();
            } else {
                this.accountBudgetSummariesBuilder_.remove(index);
            }
            return this;
        }

        public AccountBudgetSummary.Builder getAccountBudgetSummariesBuilder(int index) {
            return (AccountBudgetSummary.Builder)this.getAccountBudgetSummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public AccountBudgetSummaryOrBuilder getAccountBudgetSummariesOrBuilder(int index) {
            if (this.accountBudgetSummariesBuilder_ == null) {
                return this.accountBudgetSummaries_.get(index);
            }
            return (AccountBudgetSummaryOrBuilder)this.accountBudgetSummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AccountBudgetSummaryOrBuilder> getAccountBudgetSummariesOrBuilderList() {
            if (this.accountBudgetSummariesBuilder_ != null) {
                return this.accountBudgetSummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.accountBudgetSummaries_);
        }

        public AccountBudgetSummary.Builder addAccountBudgetSummariesBuilder() {
            return (AccountBudgetSummary.Builder)this.getAccountBudgetSummariesFieldBuilder().addBuilder((AbstractMessage)AccountBudgetSummary.getDefaultInstance());
        }

        public AccountBudgetSummary.Builder addAccountBudgetSummariesBuilder(int index) {
            return (AccountBudgetSummary.Builder)this.getAccountBudgetSummariesFieldBuilder().addBuilder(index, (AbstractMessage)AccountBudgetSummary.getDefaultInstance());
        }

        public List<AccountBudgetSummary.Builder> getAccountBudgetSummariesBuilderList() {
            return this.getAccountBudgetSummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AccountBudgetSummary, AccountBudgetSummary.Builder, AccountBudgetSummaryOrBuilder> getAccountBudgetSummariesFieldBuilder() {
            if (this.accountBudgetSummariesBuilder_ == null) {
                this.accountBudgetSummariesBuilder_ = new RepeatedFieldBuilderV3(this.accountBudgetSummaries_, (this.bitField0_ & 0x2000000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.accountBudgetSummaries_ = null;
            }
            return this.accountBudgetSummariesBuilder_;
        }

        private void ensureAccountSummariesIsMutable() {
            if ((this.bitField0_ & 0x4000000) == 0) {
                this.accountSummaries_ = new ArrayList<AccountSummary>(this.accountSummaries_);
                this.bitField0_ |= 0x4000000;
            }
        }

        @Override
        public List<AccountSummary> getAccountSummariesList() {
            if (this.accountSummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.accountSummaries_);
            }
            return this.accountSummariesBuilder_.getMessageList();
        }

        @Override
        public int getAccountSummariesCount() {
            if (this.accountSummariesBuilder_ == null) {
                return this.accountSummaries_.size();
            }
            return this.accountSummariesBuilder_.getCount();
        }

        @Override
        public AccountSummary getAccountSummaries(int index) {
            if (this.accountSummariesBuilder_ == null) {
                return this.accountSummaries_.get(index);
            }
            return (AccountSummary)this.accountSummariesBuilder_.getMessage(index);
        }

        public Builder setAccountSummaries(int index, AccountSummary value) {
            if (this.accountSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.set(index, value);
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAccountSummaries(int index, AccountSummary.Builder builderForValue) {
            if (this.accountSummariesBuilder_ == null) {
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccountSummaries(AccountSummary value) {
            if (this.accountSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.add(value);
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccountSummaries(int index, AccountSummary value) {
            if (this.accountSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.add(index, value);
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAccountSummaries(AccountSummary.Builder builderForValue) {
            if (this.accountSummariesBuilder_ == null) {
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAccountSummaries(int index, AccountSummary.Builder builderForValue) {
            if (this.accountSummariesBuilder_ == null) {
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAccountSummaries(Iterable<? extends AccountSummary> values) {
            if (this.accountSummariesBuilder_ == null) {
                this.ensureAccountSummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.accountSummaries_);
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAccountSummaries() {
            if (this.accountSummariesBuilder_ == null) {
                this.accountSummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFBFFFFFF;
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAccountSummaries(int index) {
            if (this.accountSummariesBuilder_ == null) {
                this.ensureAccountSummariesIsMutable();
                this.accountSummaries_.remove(index);
                this.onChanged();
            } else {
                this.accountSummariesBuilder_.remove(index);
            }
            return this;
        }

        public AccountSummary.Builder getAccountSummariesBuilder(int index) {
            return (AccountSummary.Builder)this.getAccountSummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public AccountSummaryOrBuilder getAccountSummariesOrBuilder(int index) {
            if (this.accountSummariesBuilder_ == null) {
                return this.accountSummaries_.get(index);
            }
            return (AccountSummaryOrBuilder)this.accountSummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AccountSummaryOrBuilder> getAccountSummariesOrBuilderList() {
            if (this.accountSummariesBuilder_ != null) {
                return this.accountSummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.accountSummaries_);
        }

        public AccountSummary.Builder addAccountSummariesBuilder() {
            return (AccountSummary.Builder)this.getAccountSummariesFieldBuilder().addBuilder((AbstractMessage)AccountSummary.getDefaultInstance());
        }

        public AccountSummary.Builder addAccountSummariesBuilder(int index) {
            return (AccountSummary.Builder)this.getAccountSummariesFieldBuilder().addBuilder(index, (AbstractMessage)AccountSummary.getDefaultInstance());
        }

        public List<AccountSummary.Builder> getAccountSummariesBuilderList() {
            return this.getAccountSummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AccountSummary, AccountSummary.Builder, AccountSummaryOrBuilder> getAccountSummariesFieldBuilder() {
            if (this.accountSummariesBuilder_ == null) {
                this.accountSummariesBuilder_ = new RepeatedFieldBuilderV3(this.accountSummaries_, (this.bitField0_ & 0x4000000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.accountSummaries_ = null;
            }
            return this.accountSummariesBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AccountBudgetSummary
    extends GeneratedMessageV3
    implements AccountBudgetSummaryOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int CUSTOMER_FIELD_NUMBER = 10;
        private volatile Object customer_ = "";
        public static final int CUSTOMER_DESCRIPTIVE_NAME_FIELD_NUMBER = 11;
        private volatile Object customerDescriptiveName_ = "";
        public static final int ACCOUNT_BUDGET_FIELD_NUMBER = 12;
        private volatile Object accountBudget_ = "";
        public static final int ACCOUNT_BUDGET_NAME_FIELD_NUMBER = 13;
        private volatile Object accountBudgetName_ = "";
        public static final int PURCHASE_ORDER_NUMBER_FIELD_NUMBER = 14;
        private volatile Object purchaseOrderNumber_ = "";
        public static final int SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 15;
        private long subtotalAmountMicros_ = 0L;
        public static final int TAX_AMOUNT_MICROS_FIELD_NUMBER = 16;
        private long taxAmountMicros_ = 0L;
        public static final int TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 17;
        private long totalAmountMicros_ = 0L;
        public static final int BILLABLE_ACTIVITY_DATE_RANGE_FIELD_NUMBER = 9;
        private DateRange billableActivityDateRange_;
        public static final int SERVED_AMOUNT_MICROS_FIELD_NUMBER = 18;
        private long servedAmountMicros_ = 0L;
        public static final int BILLED_AMOUNT_MICROS_FIELD_NUMBER = 19;
        private long billedAmountMicros_ = 0L;
        public static final int OVERDELIVERY_AMOUNT_MICROS_FIELD_NUMBER = 20;
        private long overdeliveryAmountMicros_ = 0L;
        public static final int INVALID_ACTIVITY_AMOUNT_MICROS_FIELD_NUMBER = 21;
        private long invalidActivityAmountMicros_ = 0L;
        public static final int INVALID_ACTIVITY_SUMMARIES_FIELD_NUMBER = 22;
        private List<InvalidActivitySummary> invalidActivitySummaries_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AccountBudgetSummary DEFAULT_INSTANCE = new AccountBudgetSummary();
        private static final Parser<AccountBudgetSummary> PARSER = new AbstractParser<AccountBudgetSummary>(){

            public AccountBudgetSummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AccountBudgetSummary.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AccountBudgetSummary(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AccountBudgetSummary() {
            this.customer_ = "";
            this.customerDescriptiveName_ = "";
            this.accountBudget_ = "";
            this.accountBudgetName_ = "";
            this.purchaseOrderNumber_ = "";
            this.invalidActivitySummaries_ = Collections.emptyList();
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AccountBudgetSummary();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountBudgetSummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountBudgetSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AccountBudgetSummary.class, Builder.class);
        }

        @Override
        public boolean hasCustomer() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getCustomer() {
            Object ref = this.customer_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.customer_ = s;
            return s;
        }

        @Override
        public ByteString getCustomerBytes() {
            Object ref = this.customer_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customer_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasCustomerDescriptiveName() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getCustomerDescriptiveName() {
            Object ref = this.customerDescriptiveName_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.customerDescriptiveName_ = s;
            return s;
        }

        @Override
        public ByteString getCustomerDescriptiveNameBytes() {
            Object ref = this.customerDescriptiveName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerDescriptiveName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasAccountBudget() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getAccountBudget() {
            Object ref = this.accountBudget_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.accountBudget_ = s;
            return s;
        }

        @Override
        public ByteString getAccountBudgetBytes() {
            Object ref = this.accountBudget_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.accountBudget_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasAccountBudgetName() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public String getAccountBudgetName() {
            Object ref = this.accountBudgetName_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.accountBudgetName_ = s;
            return s;
        }

        @Override
        public ByteString getAccountBudgetNameBytes() {
            Object ref = this.accountBudgetName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.accountBudgetName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasPurchaseOrderNumber() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getPurchaseOrderNumber() {
            Object ref = this.purchaseOrderNumber_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.purchaseOrderNumber_ = s;
            return s;
        }

        @Override
        public ByteString getPurchaseOrderNumberBytes() {
            Object ref = this.purchaseOrderNumber_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.purchaseOrderNumber_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasSubtotalAmountMicros() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public long getSubtotalAmountMicros() {
            return this.subtotalAmountMicros_;
        }

        @Override
        public boolean hasTaxAmountMicros() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public long getTaxAmountMicros() {
            return this.taxAmountMicros_;
        }

        @Override
        public boolean hasTotalAmountMicros() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public long getTotalAmountMicros() {
            return this.totalAmountMicros_;
        }

        @Override
        public boolean hasBillableActivityDateRange() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public DateRange getBillableActivityDateRange() {
            return this.billableActivityDateRange_ == null ? DateRange.getDefaultInstance() : this.billableActivityDateRange_;
        }

        @Override
        public DateRangeOrBuilder getBillableActivityDateRangeOrBuilder() {
            return this.billableActivityDateRange_ == null ? DateRange.getDefaultInstance() : this.billableActivityDateRange_;
        }

        @Override
        public boolean hasServedAmountMicros() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public long getServedAmountMicros() {
            return this.servedAmountMicros_;
        }

        @Override
        public boolean hasBilledAmountMicros() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public long getBilledAmountMicros() {
            return this.billedAmountMicros_;
        }

        @Override
        public boolean hasOverdeliveryAmountMicros() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public long getOverdeliveryAmountMicros() {
            return this.overdeliveryAmountMicros_;
        }

        @Override
        public boolean hasInvalidActivityAmountMicros() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public long getInvalidActivityAmountMicros() {
            return this.invalidActivityAmountMicros_;
        }

        @Override
        public List<InvalidActivitySummary> getInvalidActivitySummariesList() {
            return this.invalidActivitySummaries_;
        }

        @Override
        public List<? extends InvalidActivitySummaryOrBuilder> getInvalidActivitySummariesOrBuilderList() {
            return this.invalidActivitySummaries_;
        }

        @Override
        public int getInvalidActivitySummariesCount() {
            return this.invalidActivitySummaries_.size();
        }

        @Override
        public InvalidActivitySummary getInvalidActivitySummaries(int index) {
            return this.invalidActivitySummaries_.get(index);
        }

        @Override
        public InvalidActivitySummaryOrBuilder getInvalidActivitySummariesOrBuilder(int index) {
            return this.invalidActivitySummaries_.get(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 0x100) != 0) {
                output.writeMessage(9, (MessageLite)this.getBillableActivityDateRange());
            }
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.customer_);
            }
            if ((this.bitField0_ & 2) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.customerDescriptiveName_);
            }
            if ((this.bitField0_ & 4) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.accountBudget_);
            }
            if ((this.bitField0_ & 8) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.accountBudgetName_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.purchaseOrderNumber_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                output.writeInt64(15, this.subtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                output.writeInt64(16, this.taxAmountMicros_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                output.writeInt64(17, this.totalAmountMicros_);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                output.writeInt64(18, this.servedAmountMicros_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                output.writeInt64(19, this.billedAmountMicros_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                output.writeInt64(20, this.overdeliveryAmountMicros_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                output.writeInt64(21, this.invalidActivityAmountMicros_);
            }
            for (int i = 0; i < this.invalidActivitySummaries_.size(); ++i) {
                output.writeMessage(22, (MessageLite)this.invalidActivitySummaries_.get(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 0x100) != 0) {
                size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getBillableActivityDateRange());
            }
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.customer_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.customerDescriptiveName_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.accountBudget_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.accountBudgetName_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.purchaseOrderNumber_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                size += CodedOutputStream.computeInt64Size((int)15, (long)this.subtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                size += CodedOutputStream.computeInt64Size((int)16, (long)this.taxAmountMicros_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                size += CodedOutputStream.computeInt64Size((int)17, (long)this.totalAmountMicros_);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                size += CodedOutputStream.computeInt64Size((int)18, (long)this.servedAmountMicros_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                size += CodedOutputStream.computeInt64Size((int)19, (long)this.billedAmountMicros_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                size += CodedOutputStream.computeInt64Size((int)20, (long)this.overdeliveryAmountMicros_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)21, (long)this.invalidActivityAmountMicros_);
            }
            for (int i = 0; i < this.invalidActivitySummaries_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)((MessageLite)this.invalidActivitySummaries_.get(i)));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AccountBudgetSummary)) {
                return super.equals(obj);
            }
            AccountBudgetSummary other = (AccountBudgetSummary)obj;
            if (this.hasCustomer() != other.hasCustomer()) {
                return false;
            }
            if (this.hasCustomer() && !this.getCustomer().equals(other.getCustomer())) {
                return false;
            }
            if (this.hasCustomerDescriptiveName() != other.hasCustomerDescriptiveName()) {
                return false;
            }
            if (this.hasCustomerDescriptiveName() && !this.getCustomerDescriptiveName().equals(other.getCustomerDescriptiveName())) {
                return false;
            }
            if (this.hasAccountBudget() != other.hasAccountBudget()) {
                return false;
            }
            if (this.hasAccountBudget() && !this.getAccountBudget().equals(other.getAccountBudget())) {
                return false;
            }
            if (this.hasAccountBudgetName() != other.hasAccountBudgetName()) {
                return false;
            }
            if (this.hasAccountBudgetName() && !this.getAccountBudgetName().equals(other.getAccountBudgetName())) {
                return false;
            }
            if (this.hasPurchaseOrderNumber() != other.hasPurchaseOrderNumber()) {
                return false;
            }
            if (this.hasPurchaseOrderNumber() && !this.getPurchaseOrderNumber().equals(other.getPurchaseOrderNumber())) {
                return false;
            }
            if (this.hasSubtotalAmountMicros() != other.hasSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasSubtotalAmountMicros() && this.getSubtotalAmountMicros() != other.getSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasTaxAmountMicros() != other.hasTaxAmountMicros()) {
                return false;
            }
            if (this.hasTaxAmountMicros() && this.getTaxAmountMicros() != other.getTaxAmountMicros()) {
                return false;
            }
            if (this.hasTotalAmountMicros() != other.hasTotalAmountMicros()) {
                return false;
            }
            if (this.hasTotalAmountMicros() && this.getTotalAmountMicros() != other.getTotalAmountMicros()) {
                return false;
            }
            if (this.hasBillableActivityDateRange() != other.hasBillableActivityDateRange()) {
                return false;
            }
            if (this.hasBillableActivityDateRange() && !this.getBillableActivityDateRange().equals(other.getBillableActivityDateRange())) {
                return false;
            }
            if (this.hasServedAmountMicros() != other.hasServedAmountMicros()) {
                return false;
            }
            if (this.hasServedAmountMicros() && this.getServedAmountMicros() != other.getServedAmountMicros()) {
                return false;
            }
            if (this.hasBilledAmountMicros() != other.hasBilledAmountMicros()) {
                return false;
            }
            if (this.hasBilledAmountMicros() && this.getBilledAmountMicros() != other.getBilledAmountMicros()) {
                return false;
            }
            if (this.hasOverdeliveryAmountMicros() != other.hasOverdeliveryAmountMicros()) {
                return false;
            }
            if (this.hasOverdeliveryAmountMicros() && this.getOverdeliveryAmountMicros() != other.getOverdeliveryAmountMicros()) {
                return false;
            }
            if (this.hasInvalidActivityAmountMicros() != other.hasInvalidActivityAmountMicros()) {
                return false;
            }
            if (this.hasInvalidActivityAmountMicros() && this.getInvalidActivityAmountMicros() != other.getInvalidActivityAmountMicros()) {
                return false;
            }
            if (!this.getInvalidActivitySummariesList().equals(other.getInvalidActivitySummariesList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AccountBudgetSummary.getDescriptor().hashCode();
            if (this.hasCustomer()) {
                hash = 37 * hash + 10;
                hash = 53 * hash + this.getCustomer().hashCode();
            }
            if (this.hasCustomerDescriptiveName()) {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getCustomerDescriptiveName().hashCode();
            }
            if (this.hasAccountBudget()) {
                hash = 37 * hash + 12;
                hash = 53 * hash + this.getAccountBudget().hashCode();
            }
            if (this.hasAccountBudgetName()) {
                hash = 37 * hash + 13;
                hash = 53 * hash + this.getAccountBudgetName().hashCode();
            }
            if (this.hasPurchaseOrderNumber()) {
                hash = 37 * hash + 14;
                hash = 53 * hash + this.getPurchaseOrderNumber().hashCode();
            }
            if (this.hasSubtotalAmountMicros()) {
                hash = 37 * hash + 15;
                hash = 53 * hash + Internal.hashLong((long)this.getSubtotalAmountMicros());
            }
            if (this.hasTaxAmountMicros()) {
                hash = 37 * hash + 16;
                hash = 53 * hash + Internal.hashLong((long)this.getTaxAmountMicros());
            }
            if (this.hasTotalAmountMicros()) {
                hash = 37 * hash + 17;
                hash = 53 * hash + Internal.hashLong((long)this.getTotalAmountMicros());
            }
            if (this.hasBillableActivityDateRange()) {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getBillableActivityDateRange().hashCode();
            }
            if (this.hasServedAmountMicros()) {
                hash = 37 * hash + 18;
                hash = 53 * hash + Internal.hashLong((long)this.getServedAmountMicros());
            }
            if (this.hasBilledAmountMicros()) {
                hash = 37 * hash + 19;
                hash = 53 * hash + Internal.hashLong((long)this.getBilledAmountMicros());
            }
            if (this.hasOverdeliveryAmountMicros()) {
                hash = 37 * hash + 20;
                hash = 53 * hash + Internal.hashLong((long)this.getOverdeliveryAmountMicros());
            }
            if (this.hasInvalidActivityAmountMicros()) {
                hash = 37 * hash + 21;
                hash = 53 * hash + Internal.hashLong((long)this.getInvalidActivityAmountMicros());
            }
            if (this.getInvalidActivitySummariesCount() > 0) {
                hash = 37 * hash + 22;
                hash = 53 * hash + this.getInvalidActivitySummariesList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AccountBudgetSummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data);
        }

        public static AccountBudgetSummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountBudgetSummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data);
        }

        public static AccountBudgetSummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountBudgetSummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data);
        }

        public static AccountBudgetSummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountBudgetSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountBudgetSummary parseFrom(InputStream input) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AccountBudgetSummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AccountBudgetSummary parseDelimitedFrom(InputStream input) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AccountBudgetSummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AccountBudgetSummary parseFrom(CodedInputStream input) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AccountBudgetSummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountBudgetSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AccountBudgetSummary.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AccountBudgetSummary prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AccountBudgetSummary getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AccountBudgetSummary> parser() {
            return PARSER;
        }

        public Parser<AccountBudgetSummary> getParserForType() {
            return PARSER;
        }

        public AccountBudgetSummary getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AccountBudgetSummaryOrBuilder {
            private int bitField0_;
            private Object customer_ = "";
            private Object customerDescriptiveName_ = "";
            private Object accountBudget_ = "";
            private Object accountBudgetName_ = "";
            private Object purchaseOrderNumber_ = "";
            private long subtotalAmountMicros_;
            private long taxAmountMicros_;
            private long totalAmountMicros_;
            private DateRange billableActivityDateRange_;
            private SingleFieldBuilderV3<DateRange, DateRange.Builder, DateRangeOrBuilder> billableActivityDateRangeBuilder_;
            private long servedAmountMicros_;
            private long billedAmountMicros_;
            private long overdeliveryAmountMicros_;
            private long invalidActivityAmountMicros_;
            private List<InvalidActivitySummary> invalidActivitySummaries_ = Collections.emptyList();
            private RepeatedFieldBuilderV3<InvalidActivitySummary, InvalidActivitySummary.Builder, InvalidActivitySummaryOrBuilder> invalidActivitySummariesBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountBudgetSummary_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountBudgetSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AccountBudgetSummary.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    this.getBillableActivityDateRangeFieldBuilder();
                    this.getInvalidActivitySummariesFieldBuilder();
                }
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.customer_ = "";
                this.customerDescriptiveName_ = "";
                this.accountBudget_ = "";
                this.accountBudgetName_ = "";
                this.purchaseOrderNumber_ = "";
                this.subtotalAmountMicros_ = 0L;
                this.taxAmountMicros_ = 0L;
                this.totalAmountMicros_ = 0L;
                this.billableActivityDateRange_ = null;
                if (this.billableActivityDateRangeBuilder_ != null) {
                    this.billableActivityDateRangeBuilder_.dispose();
                    this.billableActivityDateRangeBuilder_ = null;
                }
                this.servedAmountMicros_ = 0L;
                this.billedAmountMicros_ = 0L;
                this.overdeliveryAmountMicros_ = 0L;
                this.invalidActivityAmountMicros_ = 0L;
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.invalidActivitySummaries_ = Collections.emptyList();
                } else {
                    this.invalidActivitySummaries_ = null;
                    this.invalidActivitySummariesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFDFFF;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountBudgetSummary_descriptor;
            }

            public AccountBudgetSummary getDefaultInstanceForType() {
                return AccountBudgetSummary.getDefaultInstance();
            }

            public AccountBudgetSummary build() {
                AccountBudgetSummary result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AccountBudgetSummary buildPartial() {
                AccountBudgetSummary result = new AccountBudgetSummary(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(AccountBudgetSummary result) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    if ((this.bitField0_ & 0x2000) != 0) {
                        this.invalidActivitySummaries_ = Collections.unmodifiableList(this.invalidActivitySummaries_);
                        this.bitField0_ &= 0xFFFFDFFF;
                    }
                    result.invalidActivitySummaries_ = this.invalidActivitySummaries_;
                } else {
                    result.invalidActivitySummaries_ = this.invalidActivitySummariesBuilder_.build();
                }
            }

            private void buildPartial0(AccountBudgetSummary result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.customer_ = this.customer_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.customerDescriptiveName_ = this.customerDescriptiveName_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.accountBudget_ = this.accountBudget_;
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.accountBudgetName_ = this.accountBudgetName_;
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.purchaseOrderNumber_ = this.purchaseOrderNumber_;
                    to_bitField0_ |= 0x10;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.subtotalAmountMicros_ = this.subtotalAmountMicros_;
                    to_bitField0_ |= 0x20;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.taxAmountMicros_ = this.taxAmountMicros_;
                    to_bitField0_ |= 0x40;
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    result.totalAmountMicros_ = this.totalAmountMicros_;
                    to_bitField0_ |= 0x80;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    result.billableActivityDateRange_ = this.billableActivityDateRangeBuilder_ == null ? this.billableActivityDateRange_ : (DateRange)this.billableActivityDateRangeBuilder_.build();
                    to_bitField0_ |= 0x100;
                }
                if ((from_bitField0_ & 0x200) != 0) {
                    result.servedAmountMicros_ = this.servedAmountMicros_;
                    to_bitField0_ |= 0x200;
                }
                if ((from_bitField0_ & 0x400) != 0) {
                    result.billedAmountMicros_ = this.billedAmountMicros_;
                    to_bitField0_ |= 0x400;
                }
                if ((from_bitField0_ & 0x800) != 0) {
                    result.overdeliveryAmountMicros_ = this.overdeliveryAmountMicros_;
                    to_bitField0_ |= 0x800;
                }
                if ((from_bitField0_ & 0x1000) != 0) {
                    result.invalidActivityAmountMicros_ = this.invalidActivityAmountMicros_;
                    to_bitField0_ |= 0x1000;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AccountBudgetSummary) {
                    return this.mergeFrom((AccountBudgetSummary)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AccountBudgetSummary other) {
                if (other == AccountBudgetSummary.getDefaultInstance()) {
                    return this;
                }
                if (other.hasCustomer()) {
                    this.customer_ = other.customer_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.hasCustomerDescriptiveName()) {
                    this.customerDescriptiveName_ = other.customerDescriptiveName_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (other.hasAccountBudget()) {
                    this.accountBudget_ = other.accountBudget_;
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                if (other.hasAccountBudgetName()) {
                    this.accountBudgetName_ = other.accountBudgetName_;
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                if (other.hasPurchaseOrderNumber()) {
                    this.purchaseOrderNumber_ = other.purchaseOrderNumber_;
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                if (other.hasSubtotalAmountMicros()) {
                    this.setSubtotalAmountMicros(other.getSubtotalAmountMicros());
                }
                if (other.hasTaxAmountMicros()) {
                    this.setTaxAmountMicros(other.getTaxAmountMicros());
                }
                if (other.hasTotalAmountMicros()) {
                    this.setTotalAmountMicros(other.getTotalAmountMicros());
                }
                if (other.hasBillableActivityDateRange()) {
                    this.mergeBillableActivityDateRange(other.getBillableActivityDateRange());
                }
                if (other.hasServedAmountMicros()) {
                    this.setServedAmountMicros(other.getServedAmountMicros());
                }
                if (other.hasBilledAmountMicros()) {
                    this.setBilledAmountMicros(other.getBilledAmountMicros());
                }
                if (other.hasOverdeliveryAmountMicros()) {
                    this.setOverdeliveryAmountMicros(other.getOverdeliveryAmountMicros());
                }
                if (other.hasInvalidActivityAmountMicros()) {
                    this.setInvalidActivityAmountMicros(other.getInvalidActivityAmountMicros());
                }
                if (this.invalidActivitySummariesBuilder_ == null) {
                    if (!other.invalidActivitySummaries_.isEmpty()) {
                        if (this.invalidActivitySummaries_.isEmpty()) {
                            this.invalidActivitySummaries_ = other.invalidActivitySummaries_;
                            this.bitField0_ &= 0xFFFFDFFF;
                        } else {
                            this.ensureInvalidActivitySummariesIsMutable();
                            this.invalidActivitySummaries_.addAll(other.invalidActivitySummaries_);
                        }
                        this.onChanged();
                    }
                } else if (!other.invalidActivitySummaries_.isEmpty()) {
                    if (this.invalidActivitySummariesBuilder_.isEmpty()) {
                        this.invalidActivitySummariesBuilder_.dispose();
                        this.invalidActivitySummariesBuilder_ = null;
                        this.invalidActivitySummaries_ = other.invalidActivitySummaries_;
                        this.bitField0_ &= 0xFFFFDFFF;
                        this.invalidActivitySummariesBuilder_ = alwaysUseFieldBuilders ? this.getInvalidActivitySummariesFieldBuilder() : null;
                    } else {
                        this.invalidActivitySummariesBuilder_.addAllMessages((Iterable)other.invalidActivitySummaries_);
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block22: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block22;
                            }
                            case 74: {
                                input.readMessage((MessageLite.Builder)this.getBillableActivityDateRangeFieldBuilder().getBuilder(), extensionRegistry);
                                this.bitField0_ |= 0x100;
                                continue block22;
                            }
                            case 82: {
                                this.customer_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block22;
                            }
                            case 90: {
                                this.customerDescriptiveName_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block22;
                            }
                            case 98: {
                                this.accountBudget_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 4;
                                continue block22;
                            }
                            case 106: {
                                this.accountBudgetName_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 8;
                                continue block22;
                            }
                            case 114: {
                                this.purchaseOrderNumber_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x10;
                                continue block22;
                            }
                            case 120: {
                                this.subtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x20;
                                continue block22;
                            }
                            case 128: {
                                this.taxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x40;
                                continue block22;
                            }
                            case 136: {
                                this.totalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x80;
                                continue block22;
                            }
                            case 144: {
                                this.servedAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x200;
                                continue block22;
                            }
                            case 152: {
                                this.billedAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x400;
                                continue block22;
                            }
                            case 160: {
                                this.overdeliveryAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x800;
                                continue block22;
                            }
                            case 168: {
                                this.invalidActivityAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x1000;
                                continue block22;
                            }
                            case 178: {
                                InvalidActivitySummary m = (InvalidActivitySummary)input.readMessage(InvalidActivitySummary.parser(), extensionRegistry);
                                if (this.invalidActivitySummariesBuilder_ == null) {
                                    this.ensureInvalidActivitySummariesIsMutable();
                                    this.invalidActivitySummaries_.add(m);
                                    continue block22;
                                }
                                this.invalidActivitySummariesBuilder_.addMessage((AbstractMessage)m);
                                continue block22;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasCustomer() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getCustomer() {
                Object ref = this.customer_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.customer_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getCustomerBytes() {
                Object ref = this.customer_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.customer_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setCustomer(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.customer_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCustomer() {
                this.customer_ = AccountBudgetSummary.getDefaultInstance().getCustomer();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setCustomerBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountBudgetSummary.checkByteStringIsUtf8((ByteString)value);
                this.customer_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasCustomerDescriptiveName() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public String getCustomerDescriptiveName() {
                Object ref = this.customerDescriptiveName_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.customerDescriptiveName_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getCustomerDescriptiveNameBytes() {
                Object ref = this.customerDescriptiveName_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.customerDescriptiveName_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setCustomerDescriptiveName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.customerDescriptiveName_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearCustomerDescriptiveName() {
                this.customerDescriptiveName_ = AccountBudgetSummary.getDefaultInstance().getCustomerDescriptiveName();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setCustomerDescriptiveNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountBudgetSummary.checkByteStringIsUtf8((ByteString)value);
                this.customerDescriptiveName_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasAccountBudget() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public String getAccountBudget() {
                Object ref = this.accountBudget_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.accountBudget_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getAccountBudgetBytes() {
                Object ref = this.accountBudget_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.accountBudget_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setAccountBudget(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.accountBudget_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearAccountBudget() {
                this.accountBudget_ = AccountBudgetSummary.getDefaultInstance().getAccountBudget();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder setAccountBudgetBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountBudgetSummary.checkByteStringIsUtf8((ByteString)value);
                this.accountBudget_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasAccountBudgetName() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public String getAccountBudgetName() {
                Object ref = this.accountBudgetName_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.accountBudgetName_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getAccountBudgetNameBytes() {
                Object ref = this.accountBudgetName_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.accountBudgetName_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setAccountBudgetName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.accountBudgetName_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearAccountBudgetName() {
                this.accountBudgetName_ = AccountBudgetSummary.getDefaultInstance().getAccountBudgetName();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder setAccountBudgetNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountBudgetSummary.checkByteStringIsUtf8((ByteString)value);
                this.accountBudgetName_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasPurchaseOrderNumber() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public String getPurchaseOrderNumber() {
                Object ref = this.purchaseOrderNumber_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.purchaseOrderNumber_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getPurchaseOrderNumberBytes() {
                Object ref = this.purchaseOrderNumber_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.purchaseOrderNumber_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setPurchaseOrderNumber(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.purchaseOrderNumber_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearPurchaseOrderNumber() {
                this.purchaseOrderNumber_ = AccountBudgetSummary.getDefaultInstance().getPurchaseOrderNumber();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            public Builder setPurchaseOrderNumberBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountBudgetSummary.checkByteStringIsUtf8((ByteString)value);
                this.purchaseOrderNumber_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasSubtotalAmountMicros() {
                return (this.bitField0_ & 0x20) != 0;
            }

            @Override
            public long getSubtotalAmountMicros() {
                return this.subtotalAmountMicros_;
            }

            public Builder setSubtotalAmountMicros(long value) {
                this.subtotalAmountMicros_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.subtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTaxAmountMicros() {
                return (this.bitField0_ & 0x40) != 0;
            }

            @Override
            public long getTaxAmountMicros() {
                return this.taxAmountMicros_;
            }

            public Builder setTaxAmountMicros(long value) {
                this.taxAmountMicros_ = value;
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder clearTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFFFBF;
                this.taxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTotalAmountMicros() {
                return (this.bitField0_ & 0x80) != 0;
            }

            @Override
            public long getTotalAmountMicros() {
                return this.totalAmountMicros_;
            }

            public Builder setTotalAmountMicros(long value) {
                this.totalAmountMicros_ = value;
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder clearTotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.totalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBillableActivityDateRange() {
                return (this.bitField0_ & 0x100) != 0;
            }

            @Override
            public DateRange getBillableActivityDateRange() {
                if (this.billableActivityDateRangeBuilder_ == null) {
                    return this.billableActivityDateRange_ == null ? DateRange.getDefaultInstance() : this.billableActivityDateRange_;
                }
                return (DateRange)this.billableActivityDateRangeBuilder_.getMessage();
            }

            public Builder setBillableActivityDateRange(DateRange value) {
                if (this.billableActivityDateRangeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.billableActivityDateRange_ = value;
                } else {
                    this.billableActivityDateRangeBuilder_.setMessage((AbstractMessage)value);
                }
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder setBillableActivityDateRange(DateRange.Builder builderForValue) {
                if (this.billableActivityDateRangeBuilder_ == null) {
                    this.billableActivityDateRange_ = builderForValue.build();
                } else {
                    this.billableActivityDateRangeBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder mergeBillableActivityDateRange(DateRange value) {
                if (this.billableActivityDateRangeBuilder_ == null) {
                    if ((this.bitField0_ & 0x100) != 0 && this.billableActivityDateRange_ != null && this.billableActivityDateRange_ != DateRange.getDefaultInstance()) {
                        this.getBillableActivityDateRangeBuilder().mergeFrom(value);
                    } else {
                        this.billableActivityDateRange_ = value;
                    }
                } else {
                    this.billableActivityDateRangeBuilder_.mergeFrom((AbstractMessage)value);
                }
                if (this.billableActivityDateRange_ != null) {
                    this.bitField0_ |= 0x100;
                    this.onChanged();
                }
                return this;
            }

            public Builder clearBillableActivityDateRange() {
                this.bitField0_ &= 0xFFFFFEFF;
                this.billableActivityDateRange_ = null;
                if (this.billableActivityDateRangeBuilder_ != null) {
                    this.billableActivityDateRangeBuilder_.dispose();
                    this.billableActivityDateRangeBuilder_ = null;
                }
                this.onChanged();
                return this;
            }

            public DateRange.Builder getBillableActivityDateRangeBuilder() {
                this.bitField0_ |= 0x100;
                this.onChanged();
                return (DateRange.Builder)this.getBillableActivityDateRangeFieldBuilder().getBuilder();
            }

            @Override
            public DateRangeOrBuilder getBillableActivityDateRangeOrBuilder() {
                if (this.billableActivityDateRangeBuilder_ != null) {
                    return (DateRangeOrBuilder)this.billableActivityDateRangeBuilder_.getMessageOrBuilder();
                }
                return this.billableActivityDateRange_ == null ? DateRange.getDefaultInstance() : this.billableActivityDateRange_;
            }

            private SingleFieldBuilderV3<DateRange, DateRange.Builder, DateRangeOrBuilder> getBillableActivityDateRangeFieldBuilder() {
                if (this.billableActivityDateRangeBuilder_ == null) {
                    this.billableActivityDateRangeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBillableActivityDateRange(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.billableActivityDateRange_ = null;
                }
                return this.billableActivityDateRangeBuilder_;
            }

            @Override
            public boolean hasServedAmountMicros() {
                return (this.bitField0_ & 0x200) != 0;
            }

            @Override
            public long getServedAmountMicros() {
                return this.servedAmountMicros_;
            }

            public Builder setServedAmountMicros(long value) {
                this.servedAmountMicros_ = value;
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder clearServedAmountMicros() {
                this.bitField0_ &= 0xFFFFFDFF;
                this.servedAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBilledAmountMicros() {
                return (this.bitField0_ & 0x400) != 0;
            }

            @Override
            public long getBilledAmountMicros() {
                return this.billedAmountMicros_;
            }

            public Builder setBilledAmountMicros(long value) {
                this.billedAmountMicros_ = value;
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder clearBilledAmountMicros() {
                this.bitField0_ &= 0xFFFFFBFF;
                this.billedAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOverdeliveryAmountMicros() {
                return (this.bitField0_ & 0x800) != 0;
            }

            @Override
            public long getOverdeliveryAmountMicros() {
                return this.overdeliveryAmountMicros_;
            }

            public Builder setOverdeliveryAmountMicros(long value) {
                this.overdeliveryAmountMicros_ = value;
                this.bitField0_ |= 0x800;
                this.onChanged();
                return this;
            }

            public Builder clearOverdeliveryAmountMicros() {
                this.bitField0_ &= 0xFFFFF7FF;
                this.overdeliveryAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasInvalidActivityAmountMicros() {
                return (this.bitField0_ & 0x1000) != 0;
            }

            @Override
            public long getInvalidActivityAmountMicros() {
                return this.invalidActivityAmountMicros_;
            }

            public Builder setInvalidActivityAmountMicros(long value) {
                this.invalidActivityAmountMicros_ = value;
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            public Builder clearInvalidActivityAmountMicros() {
                this.bitField0_ &= 0xFFFFEFFF;
                this.invalidActivityAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            private void ensureInvalidActivitySummariesIsMutable() {
                if ((this.bitField0_ & 0x2000) == 0) {
                    this.invalidActivitySummaries_ = new ArrayList<InvalidActivitySummary>(this.invalidActivitySummaries_);
                    this.bitField0_ |= 0x2000;
                }
            }

            @Override
            public List<InvalidActivitySummary> getInvalidActivitySummariesList() {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    return Collections.unmodifiableList(this.invalidActivitySummaries_);
                }
                return this.invalidActivitySummariesBuilder_.getMessageList();
            }

            @Override
            public int getInvalidActivitySummariesCount() {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    return this.invalidActivitySummaries_.size();
                }
                return this.invalidActivitySummariesBuilder_.getCount();
            }

            @Override
            public InvalidActivitySummary getInvalidActivitySummaries(int index) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    return this.invalidActivitySummaries_.get(index);
                }
                return (InvalidActivitySummary)this.invalidActivitySummariesBuilder_.getMessage(index);
            }

            public Builder setInvalidActivitySummaries(int index, InvalidActivitySummary value) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.set(index, value);
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.setMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder setInvalidActivitySummaries(int index, InvalidActivitySummary.Builder builderForValue) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addInvalidActivitySummaries(InvalidActivitySummary value) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.add(value);
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.addMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder addInvalidActivitySummaries(int index, InvalidActivitySummary value) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.add(index, value);
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.addMessage(index, (AbstractMessage)value);
                }
                return this;
            }

            public Builder addInvalidActivitySummaries(InvalidActivitySummary.Builder builderForValue) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addInvalidActivitySummaries(int index, InvalidActivitySummary.Builder builderForValue) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllInvalidActivitySummaries(Iterable<? extends InvalidActivitySummary> values) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.ensureInvalidActivitySummariesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.invalidActivitySummaries_);
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearInvalidActivitySummaries() {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.invalidActivitySummaries_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.clear();
                }
                return this;
            }

            public Builder removeInvalidActivitySummaries(int index) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.ensureInvalidActivitySummariesIsMutable();
                    this.invalidActivitySummaries_.remove(index);
                    this.onChanged();
                } else {
                    this.invalidActivitySummariesBuilder_.remove(index);
                }
                return this;
            }

            public InvalidActivitySummary.Builder getInvalidActivitySummariesBuilder(int index) {
                return (InvalidActivitySummary.Builder)this.getInvalidActivitySummariesFieldBuilder().getBuilder(index);
            }

            @Override
            public InvalidActivitySummaryOrBuilder getInvalidActivitySummariesOrBuilder(int index) {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    return this.invalidActivitySummaries_.get(index);
                }
                return (InvalidActivitySummaryOrBuilder)this.invalidActivitySummariesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends InvalidActivitySummaryOrBuilder> getInvalidActivitySummariesOrBuilderList() {
                if (this.invalidActivitySummariesBuilder_ != null) {
                    return this.invalidActivitySummariesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.invalidActivitySummaries_);
            }

            public InvalidActivitySummary.Builder addInvalidActivitySummariesBuilder() {
                return (InvalidActivitySummary.Builder)this.getInvalidActivitySummariesFieldBuilder().addBuilder((AbstractMessage)InvalidActivitySummary.getDefaultInstance());
            }

            public InvalidActivitySummary.Builder addInvalidActivitySummariesBuilder(int index) {
                return (InvalidActivitySummary.Builder)this.getInvalidActivitySummariesFieldBuilder().addBuilder(index, (AbstractMessage)InvalidActivitySummary.getDefaultInstance());
            }

            public List<InvalidActivitySummary.Builder> getInvalidActivitySummariesBuilderList() {
                return this.getInvalidActivitySummariesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilderV3<InvalidActivitySummary, InvalidActivitySummary.Builder, InvalidActivitySummaryOrBuilder> getInvalidActivitySummariesFieldBuilder() {
                if (this.invalidActivitySummariesBuilder_ == null) {
                    this.invalidActivitySummariesBuilder_ = new RepeatedFieldBuilderV3(this.invalidActivitySummaries_, (this.bitField0_ & 0x2000) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.invalidActivitySummaries_ = null;
                }
                return this.invalidActivitySummariesBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AccountBudgetSummaryOrBuilder
    extends MessageOrBuilder {
        public boolean hasCustomer();

        public String getCustomer();

        public ByteString getCustomerBytes();

        public boolean hasCustomerDescriptiveName();

        public String getCustomerDescriptiveName();

        public ByteString getCustomerDescriptiveNameBytes();

        public boolean hasAccountBudget();

        public String getAccountBudget();

        public ByteString getAccountBudgetBytes();

        public boolean hasAccountBudgetName();

        public String getAccountBudgetName();

        public ByteString getAccountBudgetNameBytes();

        public boolean hasPurchaseOrderNumber();

        public String getPurchaseOrderNumber();

        public ByteString getPurchaseOrderNumberBytes();

        public boolean hasSubtotalAmountMicros();

        public long getSubtotalAmountMicros();

        public boolean hasTaxAmountMicros();

        public long getTaxAmountMicros();

        public boolean hasTotalAmountMicros();

        public long getTotalAmountMicros();

        public boolean hasBillableActivityDateRange();

        public DateRange getBillableActivityDateRange();

        public DateRangeOrBuilder getBillableActivityDateRangeOrBuilder();

        public boolean hasServedAmountMicros();

        public long getServedAmountMicros();

        public boolean hasBilledAmountMicros();

        public long getBilledAmountMicros();

        public boolean hasOverdeliveryAmountMicros();

        public long getOverdeliveryAmountMicros();

        public boolean hasInvalidActivityAmountMicros();

        public long getInvalidActivityAmountMicros();

        public List<InvalidActivitySummary> getInvalidActivitySummariesList();

        public InvalidActivitySummary getInvalidActivitySummaries(int var1);

        public int getInvalidActivitySummariesCount();

        public List<? extends InvalidActivitySummaryOrBuilder> getInvalidActivitySummariesOrBuilderList();

        public InvalidActivitySummaryOrBuilder getInvalidActivitySummariesOrBuilder(int var1);
    }

    public static final class AccountSummary
    extends GeneratedMessageV3
    implements AccountSummaryOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int CUSTOMER_FIELD_NUMBER = 1;
        private volatile Object customer_ = "";
        public static final int BILLING_CORRECTION_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 2;
        private long billingCorrectionSubtotalAmountMicros_ = 0L;
        public static final int BILLING_CORRECTION_TAX_AMOUNT_MICROS_FIELD_NUMBER = 3;
        private long billingCorrectionTaxAmountMicros_ = 0L;
        public static final int BILLING_CORRECTION_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 4;
        private long billingCorrectionTotalAmountMicros_ = 0L;
        public static final int COUPON_ADJUSTMENT_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 5;
        private long couponAdjustmentSubtotalAmountMicros_ = 0L;
        public static final int COUPON_ADJUSTMENT_TAX_AMOUNT_MICROS_FIELD_NUMBER = 6;
        private long couponAdjustmentTaxAmountMicros_ = 0L;
        public static final int COUPON_ADJUSTMENT_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 7;
        private long couponAdjustmentTotalAmountMicros_ = 0L;
        public static final int EXCESS_CREDIT_ADJUSTMENT_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 8;
        private long excessCreditAdjustmentSubtotalAmountMicros_ = 0L;
        public static final int EXCESS_CREDIT_ADJUSTMENT_TAX_AMOUNT_MICROS_FIELD_NUMBER = 9;
        private long excessCreditAdjustmentTaxAmountMicros_ = 0L;
        public static final int EXCESS_CREDIT_ADJUSTMENT_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 10;
        private long excessCreditAdjustmentTotalAmountMicros_ = 0L;
        public static final int REGULATORY_COSTS_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 11;
        private long regulatoryCostsSubtotalAmountMicros_ = 0L;
        public static final int REGULATORY_COSTS_TAX_AMOUNT_MICROS_FIELD_NUMBER = 12;
        private long regulatoryCostsTaxAmountMicros_ = 0L;
        public static final int REGULATORY_COSTS_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 13;
        private long regulatoryCostsTotalAmountMicros_ = 0L;
        public static final int EXPORT_CHARGE_SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 17;
        private long exportChargeSubtotalAmountMicros_ = 0L;
        public static final int EXPORT_CHARGE_TAX_AMOUNT_MICROS_FIELD_NUMBER = 18;
        private long exportChargeTaxAmountMicros_ = 0L;
        public static final int EXPORT_CHARGE_TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 19;
        private long exportChargeTotalAmountMicros_ = 0L;
        public static final int SUBTOTAL_AMOUNT_MICROS_FIELD_NUMBER = 14;
        private long subtotalAmountMicros_ = 0L;
        public static final int TAX_AMOUNT_MICROS_FIELD_NUMBER = 15;
        private long taxAmountMicros_ = 0L;
        public static final int TOTAL_AMOUNT_MICROS_FIELD_NUMBER = 16;
        private long totalAmountMicros_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AccountSummary DEFAULT_INSTANCE = new AccountSummary();
        private static final Parser<AccountSummary> PARSER = new AbstractParser<AccountSummary>(){

            public AccountSummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AccountSummary.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AccountSummary(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AccountSummary() {
            this.customer_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AccountSummary();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountSummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AccountSummary.class, Builder.class);
        }

        @Override
        public boolean hasCustomer() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getCustomer() {
            Object ref = this.customer_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.customer_ = s;
            return s;
        }

        @Override
        public ByteString getCustomerBytes() {
            Object ref = this.customer_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customer_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasBillingCorrectionSubtotalAmountMicros() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getBillingCorrectionSubtotalAmountMicros() {
            return this.billingCorrectionSubtotalAmountMicros_;
        }

        @Override
        public boolean hasBillingCorrectionTaxAmountMicros() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public long getBillingCorrectionTaxAmountMicros() {
            return this.billingCorrectionTaxAmountMicros_;
        }

        @Override
        public boolean hasBillingCorrectionTotalAmountMicros() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public long getBillingCorrectionTotalAmountMicros() {
            return this.billingCorrectionTotalAmountMicros_;
        }

        @Override
        public boolean hasCouponAdjustmentSubtotalAmountMicros() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public long getCouponAdjustmentSubtotalAmountMicros() {
            return this.couponAdjustmentSubtotalAmountMicros_;
        }

        @Override
        public boolean hasCouponAdjustmentTaxAmountMicros() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public long getCouponAdjustmentTaxAmountMicros() {
            return this.couponAdjustmentTaxAmountMicros_;
        }

        @Override
        public boolean hasCouponAdjustmentTotalAmountMicros() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public long getCouponAdjustmentTotalAmountMicros() {
            return this.couponAdjustmentTotalAmountMicros_;
        }

        @Override
        public boolean hasExcessCreditAdjustmentSubtotalAmountMicros() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public long getExcessCreditAdjustmentSubtotalAmountMicros() {
            return this.excessCreditAdjustmentSubtotalAmountMicros_;
        }

        @Override
        public boolean hasExcessCreditAdjustmentTaxAmountMicros() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public long getExcessCreditAdjustmentTaxAmountMicros() {
            return this.excessCreditAdjustmentTaxAmountMicros_;
        }

        @Override
        public boolean hasExcessCreditAdjustmentTotalAmountMicros() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public long getExcessCreditAdjustmentTotalAmountMicros() {
            return this.excessCreditAdjustmentTotalAmountMicros_;
        }

        @Override
        public boolean hasRegulatoryCostsSubtotalAmountMicros() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public long getRegulatoryCostsSubtotalAmountMicros() {
            return this.regulatoryCostsSubtotalAmountMicros_;
        }

        @Override
        public boolean hasRegulatoryCostsTaxAmountMicros() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public long getRegulatoryCostsTaxAmountMicros() {
            return this.regulatoryCostsTaxAmountMicros_;
        }

        @Override
        public boolean hasRegulatoryCostsTotalAmountMicros() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public long getRegulatoryCostsTotalAmountMicros() {
            return this.regulatoryCostsTotalAmountMicros_;
        }

        @Override
        public boolean hasExportChargeSubtotalAmountMicros() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public long getExportChargeSubtotalAmountMicros() {
            return this.exportChargeSubtotalAmountMicros_;
        }

        @Override
        public boolean hasExportChargeTaxAmountMicros() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public long getExportChargeTaxAmountMicros() {
            return this.exportChargeTaxAmountMicros_;
        }

        @Override
        public boolean hasExportChargeTotalAmountMicros() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public long getExportChargeTotalAmountMicros() {
            return this.exportChargeTotalAmountMicros_;
        }

        @Override
        public boolean hasSubtotalAmountMicros() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public long getSubtotalAmountMicros() {
            return this.subtotalAmountMicros_;
        }

        @Override
        public boolean hasTaxAmountMicros() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public long getTaxAmountMicros() {
            return this.taxAmountMicros_;
        }

        @Override
        public boolean hasTotalAmountMicros() {
            return (this.bitField0_ & 0x40000) != 0;
        }

        @Override
        public long getTotalAmountMicros() {
            return this.totalAmountMicros_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customer_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeInt64(2, this.billingCorrectionSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeInt64(3, this.billingCorrectionTaxAmountMicros_);
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeInt64(4, this.billingCorrectionTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                output.writeInt64(5, this.couponAdjustmentSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                output.writeInt64(6, this.couponAdjustmentTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                output.writeInt64(7, this.couponAdjustmentTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                output.writeInt64(8, this.excessCreditAdjustmentSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x100) != 0) {
                output.writeInt64(9, this.excessCreditAdjustmentTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                output.writeInt64(10, this.excessCreditAdjustmentTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                output.writeInt64(11, this.regulatoryCostsSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                output.writeInt64(12, this.regulatoryCostsTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                output.writeInt64(13, this.regulatoryCostsTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x10000) != 0) {
                output.writeInt64(14, this.subtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x20000) != 0) {
                output.writeInt64(15, this.taxAmountMicros_);
            }
            if ((this.bitField0_ & 0x40000) != 0) {
                output.writeInt64(16, this.totalAmountMicros_);
            }
            if ((this.bitField0_ & 0x2000) != 0) {
                output.writeInt64(17, this.exportChargeSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x4000) != 0) {
                output.writeInt64(18, this.exportChargeTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x8000) != 0) {
                output.writeInt64(19, this.exportChargeTotalAmountMicros_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customer_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeInt64Size((int)2, (long)this.billingCorrectionSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeInt64Size((int)3, (long)this.billingCorrectionTaxAmountMicros_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputStream.computeInt64Size((int)4, (long)this.billingCorrectionTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += CodedOutputStream.computeInt64Size((int)5, (long)this.couponAdjustmentSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                size += CodedOutputStream.computeInt64Size((int)6, (long)this.couponAdjustmentTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                size += CodedOutputStream.computeInt64Size((int)7, (long)this.couponAdjustmentTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                size += CodedOutputStream.computeInt64Size((int)8, (long)this.excessCreditAdjustmentSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x100) != 0) {
                size += CodedOutputStream.computeInt64Size((int)9, (long)this.excessCreditAdjustmentTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                size += CodedOutputStream.computeInt64Size((int)10, (long)this.excessCreditAdjustmentTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                size += CodedOutputStream.computeInt64Size((int)11, (long)this.regulatoryCostsSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                size += CodedOutputStream.computeInt64Size((int)12, (long)this.regulatoryCostsTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)13, (long)this.regulatoryCostsTotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x10000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)14, (long)this.subtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x20000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)15, (long)this.taxAmountMicros_);
            }
            if ((this.bitField0_ & 0x40000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)16, (long)this.totalAmountMicros_);
            }
            if ((this.bitField0_ & 0x2000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)17, (long)this.exportChargeSubtotalAmountMicros_);
            }
            if ((this.bitField0_ & 0x4000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)18, (long)this.exportChargeTaxAmountMicros_);
            }
            if ((this.bitField0_ & 0x8000) != 0) {
                size += CodedOutputStream.computeInt64Size((int)19, (long)this.exportChargeTotalAmountMicros_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AccountSummary)) {
                return super.equals(obj);
            }
            AccountSummary other = (AccountSummary)obj;
            if (this.hasCustomer() != other.hasCustomer()) {
                return false;
            }
            if (this.hasCustomer() && !this.getCustomer().equals(other.getCustomer())) {
                return false;
            }
            if (this.hasBillingCorrectionSubtotalAmountMicros() != other.hasBillingCorrectionSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasBillingCorrectionSubtotalAmountMicros() && this.getBillingCorrectionSubtotalAmountMicros() != other.getBillingCorrectionSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasBillingCorrectionTaxAmountMicros() != other.hasBillingCorrectionTaxAmountMicros()) {
                return false;
            }
            if (this.hasBillingCorrectionTaxAmountMicros() && this.getBillingCorrectionTaxAmountMicros() != other.getBillingCorrectionTaxAmountMicros()) {
                return false;
            }
            if (this.hasBillingCorrectionTotalAmountMicros() != other.hasBillingCorrectionTotalAmountMicros()) {
                return false;
            }
            if (this.hasBillingCorrectionTotalAmountMicros() && this.getBillingCorrectionTotalAmountMicros() != other.getBillingCorrectionTotalAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentSubtotalAmountMicros() != other.hasCouponAdjustmentSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentSubtotalAmountMicros() && this.getCouponAdjustmentSubtotalAmountMicros() != other.getCouponAdjustmentSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentTaxAmountMicros() != other.hasCouponAdjustmentTaxAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentTaxAmountMicros() && this.getCouponAdjustmentTaxAmountMicros() != other.getCouponAdjustmentTaxAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentTotalAmountMicros() != other.hasCouponAdjustmentTotalAmountMicros()) {
                return false;
            }
            if (this.hasCouponAdjustmentTotalAmountMicros() && this.getCouponAdjustmentTotalAmountMicros() != other.getCouponAdjustmentTotalAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentSubtotalAmountMicros() != other.hasExcessCreditAdjustmentSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentSubtotalAmountMicros() && this.getExcessCreditAdjustmentSubtotalAmountMicros() != other.getExcessCreditAdjustmentSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentTaxAmountMicros() != other.hasExcessCreditAdjustmentTaxAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentTaxAmountMicros() && this.getExcessCreditAdjustmentTaxAmountMicros() != other.getExcessCreditAdjustmentTaxAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentTotalAmountMicros() != other.hasExcessCreditAdjustmentTotalAmountMicros()) {
                return false;
            }
            if (this.hasExcessCreditAdjustmentTotalAmountMicros() && this.getExcessCreditAdjustmentTotalAmountMicros() != other.getExcessCreditAdjustmentTotalAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsSubtotalAmountMicros() != other.hasRegulatoryCostsSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsSubtotalAmountMicros() && this.getRegulatoryCostsSubtotalAmountMicros() != other.getRegulatoryCostsSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsTaxAmountMicros() != other.hasRegulatoryCostsTaxAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsTaxAmountMicros() && this.getRegulatoryCostsTaxAmountMicros() != other.getRegulatoryCostsTaxAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsTotalAmountMicros() != other.hasRegulatoryCostsTotalAmountMicros()) {
                return false;
            }
            if (this.hasRegulatoryCostsTotalAmountMicros() && this.getRegulatoryCostsTotalAmountMicros() != other.getRegulatoryCostsTotalAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeSubtotalAmountMicros() != other.hasExportChargeSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeSubtotalAmountMicros() && this.getExportChargeSubtotalAmountMicros() != other.getExportChargeSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeTaxAmountMicros() != other.hasExportChargeTaxAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeTaxAmountMicros() && this.getExportChargeTaxAmountMicros() != other.getExportChargeTaxAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeTotalAmountMicros() != other.hasExportChargeTotalAmountMicros()) {
                return false;
            }
            if (this.hasExportChargeTotalAmountMicros() && this.getExportChargeTotalAmountMicros() != other.getExportChargeTotalAmountMicros()) {
                return false;
            }
            if (this.hasSubtotalAmountMicros() != other.hasSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasSubtotalAmountMicros() && this.getSubtotalAmountMicros() != other.getSubtotalAmountMicros()) {
                return false;
            }
            if (this.hasTaxAmountMicros() != other.hasTaxAmountMicros()) {
                return false;
            }
            if (this.hasTaxAmountMicros() && this.getTaxAmountMicros() != other.getTaxAmountMicros()) {
                return false;
            }
            if (this.hasTotalAmountMicros() != other.hasTotalAmountMicros()) {
                return false;
            }
            if (this.hasTotalAmountMicros() && this.getTotalAmountMicros() != other.getTotalAmountMicros()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AccountSummary.getDescriptor().hashCode();
            if (this.hasCustomer()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getCustomer().hashCode();
            }
            if (this.hasBillingCorrectionSubtotalAmountMicros()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + Internal.hashLong((long)this.getBillingCorrectionSubtotalAmountMicros());
            }
            if (this.hasBillingCorrectionTaxAmountMicros()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)this.getBillingCorrectionTaxAmountMicros());
            }
            if (this.hasBillingCorrectionTotalAmountMicros()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + Internal.hashLong((long)this.getBillingCorrectionTotalAmountMicros());
            }
            if (this.hasCouponAdjustmentSubtotalAmountMicros()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + Internal.hashLong((long)this.getCouponAdjustmentSubtotalAmountMicros());
            }
            if (this.hasCouponAdjustmentTaxAmountMicros()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + Internal.hashLong((long)this.getCouponAdjustmentTaxAmountMicros());
            }
            if (this.hasCouponAdjustmentTotalAmountMicros()) {
                hash = 37 * hash + 7;
                hash = 53 * hash + Internal.hashLong((long)this.getCouponAdjustmentTotalAmountMicros());
            }
            if (this.hasExcessCreditAdjustmentSubtotalAmountMicros()) {
                hash = 37 * hash + 8;
                hash = 53 * hash + Internal.hashLong((long)this.getExcessCreditAdjustmentSubtotalAmountMicros());
            }
            if (this.hasExcessCreditAdjustmentTaxAmountMicros()) {
                hash = 37 * hash + 9;
                hash = 53 * hash + Internal.hashLong((long)this.getExcessCreditAdjustmentTaxAmountMicros());
            }
            if (this.hasExcessCreditAdjustmentTotalAmountMicros()) {
                hash = 37 * hash + 10;
                hash = 53 * hash + Internal.hashLong((long)this.getExcessCreditAdjustmentTotalAmountMicros());
            }
            if (this.hasRegulatoryCostsSubtotalAmountMicros()) {
                hash = 37 * hash + 11;
                hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsSubtotalAmountMicros());
            }
            if (this.hasRegulatoryCostsTaxAmountMicros()) {
                hash = 37 * hash + 12;
                hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsTaxAmountMicros());
            }
            if (this.hasRegulatoryCostsTotalAmountMicros()) {
                hash = 37 * hash + 13;
                hash = 53 * hash + Internal.hashLong((long)this.getRegulatoryCostsTotalAmountMicros());
            }
            if (this.hasExportChargeSubtotalAmountMicros()) {
                hash = 37 * hash + 17;
                hash = 53 * hash + Internal.hashLong((long)this.getExportChargeSubtotalAmountMicros());
            }
            if (this.hasExportChargeTaxAmountMicros()) {
                hash = 37 * hash + 18;
                hash = 53 * hash + Internal.hashLong((long)this.getExportChargeTaxAmountMicros());
            }
            if (this.hasExportChargeTotalAmountMicros()) {
                hash = 37 * hash + 19;
                hash = 53 * hash + Internal.hashLong((long)this.getExportChargeTotalAmountMicros());
            }
            if (this.hasSubtotalAmountMicros()) {
                hash = 37 * hash + 14;
                hash = 53 * hash + Internal.hashLong((long)this.getSubtotalAmountMicros());
            }
            if (this.hasTaxAmountMicros()) {
                hash = 37 * hash + 15;
                hash = 53 * hash + Internal.hashLong((long)this.getTaxAmountMicros());
            }
            if (this.hasTotalAmountMicros()) {
                hash = 37 * hash + 16;
                hash = 53 * hash + Internal.hashLong((long)this.getTotalAmountMicros());
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AccountSummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data);
        }

        public static AccountSummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountSummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data);
        }

        public static AccountSummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountSummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data);
        }

        public static AccountSummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AccountSummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AccountSummary parseFrom(InputStream input) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AccountSummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AccountSummary parseDelimitedFrom(InputStream input) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AccountSummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AccountSummary parseFrom(CodedInputStream input) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AccountSummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AccountSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AccountSummary.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AccountSummary prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AccountSummary getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AccountSummary> parser() {
            return PARSER;
        }

        public Parser<AccountSummary> getParserForType() {
            return PARSER;
        }

        public AccountSummary getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AccountSummaryOrBuilder {
            private int bitField0_;
            private Object customer_ = "";
            private long billingCorrectionSubtotalAmountMicros_;
            private long billingCorrectionTaxAmountMicros_;
            private long billingCorrectionTotalAmountMicros_;
            private long couponAdjustmentSubtotalAmountMicros_;
            private long couponAdjustmentTaxAmountMicros_;
            private long couponAdjustmentTotalAmountMicros_;
            private long excessCreditAdjustmentSubtotalAmountMicros_;
            private long excessCreditAdjustmentTaxAmountMicros_;
            private long excessCreditAdjustmentTotalAmountMicros_;
            private long regulatoryCostsSubtotalAmountMicros_;
            private long regulatoryCostsTaxAmountMicros_;
            private long regulatoryCostsTotalAmountMicros_;
            private long exportChargeSubtotalAmountMicros_;
            private long exportChargeTaxAmountMicros_;
            private long exportChargeTotalAmountMicros_;
            private long subtotalAmountMicros_;
            private long taxAmountMicros_;
            private long totalAmountMicros_;

            public static final Descriptors.Descriptor getDescriptor() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountSummary_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(AccountSummary.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.customer_ = "";
                this.billingCorrectionSubtotalAmountMicros_ = 0L;
                this.billingCorrectionTaxAmountMicros_ = 0L;
                this.billingCorrectionTotalAmountMicros_ = 0L;
                this.couponAdjustmentSubtotalAmountMicros_ = 0L;
                this.couponAdjustmentTaxAmountMicros_ = 0L;
                this.couponAdjustmentTotalAmountMicros_ = 0L;
                this.excessCreditAdjustmentSubtotalAmountMicros_ = 0L;
                this.excessCreditAdjustmentTaxAmountMicros_ = 0L;
                this.excessCreditAdjustmentTotalAmountMicros_ = 0L;
                this.regulatoryCostsSubtotalAmountMicros_ = 0L;
                this.regulatoryCostsTaxAmountMicros_ = 0L;
                this.regulatoryCostsTotalAmountMicros_ = 0L;
                this.exportChargeSubtotalAmountMicros_ = 0L;
                this.exportChargeTaxAmountMicros_ = 0L;
                this.exportChargeTotalAmountMicros_ = 0L;
                this.subtotalAmountMicros_ = 0L;
                this.taxAmountMicros_ = 0L;
                this.totalAmountMicros_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_AccountSummary_descriptor;
            }

            public AccountSummary getDefaultInstanceForType() {
                return AccountSummary.getDefaultInstance();
            }

            public AccountSummary build() {
                AccountSummary result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AccountSummary buildPartial() {
                AccountSummary result = new AccountSummary(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(AccountSummary result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.customer_ = this.customer_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.billingCorrectionSubtotalAmountMicros_ = this.billingCorrectionSubtotalAmountMicros_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.billingCorrectionTaxAmountMicros_ = this.billingCorrectionTaxAmountMicros_;
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.billingCorrectionTotalAmountMicros_ = this.billingCorrectionTotalAmountMicros_;
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.couponAdjustmentSubtotalAmountMicros_ = this.couponAdjustmentSubtotalAmountMicros_;
                    to_bitField0_ |= 0x10;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.couponAdjustmentTaxAmountMicros_ = this.couponAdjustmentTaxAmountMicros_;
                    to_bitField0_ |= 0x20;
                }
                if ((from_bitField0_ & 0x40) != 0) {
                    result.couponAdjustmentTotalAmountMicros_ = this.couponAdjustmentTotalAmountMicros_;
                    to_bitField0_ |= 0x40;
                }
                if ((from_bitField0_ & 0x80) != 0) {
                    result.excessCreditAdjustmentSubtotalAmountMicros_ = this.excessCreditAdjustmentSubtotalAmountMicros_;
                    to_bitField0_ |= 0x80;
                }
                if ((from_bitField0_ & 0x100) != 0) {
                    result.excessCreditAdjustmentTaxAmountMicros_ = this.excessCreditAdjustmentTaxAmountMicros_;
                    to_bitField0_ |= 0x100;
                }
                if ((from_bitField0_ & 0x200) != 0) {
                    result.excessCreditAdjustmentTotalAmountMicros_ = this.excessCreditAdjustmentTotalAmountMicros_;
                    to_bitField0_ |= 0x200;
                }
                if ((from_bitField0_ & 0x400) != 0) {
                    result.regulatoryCostsSubtotalAmountMicros_ = this.regulatoryCostsSubtotalAmountMicros_;
                    to_bitField0_ |= 0x400;
                }
                if ((from_bitField0_ & 0x800) != 0) {
                    result.regulatoryCostsTaxAmountMicros_ = this.regulatoryCostsTaxAmountMicros_;
                    to_bitField0_ |= 0x800;
                }
                if ((from_bitField0_ & 0x1000) != 0) {
                    result.regulatoryCostsTotalAmountMicros_ = this.regulatoryCostsTotalAmountMicros_;
                    to_bitField0_ |= 0x1000;
                }
                if ((from_bitField0_ & 0x2000) != 0) {
                    result.exportChargeSubtotalAmountMicros_ = this.exportChargeSubtotalAmountMicros_;
                    to_bitField0_ |= 0x2000;
                }
                if ((from_bitField0_ & 0x4000) != 0) {
                    result.exportChargeTaxAmountMicros_ = this.exportChargeTaxAmountMicros_;
                    to_bitField0_ |= 0x4000;
                }
                if ((from_bitField0_ & 0x8000) != 0) {
                    result.exportChargeTotalAmountMicros_ = this.exportChargeTotalAmountMicros_;
                    to_bitField0_ |= 0x8000;
                }
                if ((from_bitField0_ & 0x10000) != 0) {
                    result.subtotalAmountMicros_ = this.subtotalAmountMicros_;
                    to_bitField0_ |= 0x10000;
                }
                if ((from_bitField0_ & 0x20000) != 0) {
                    result.taxAmountMicros_ = this.taxAmountMicros_;
                    to_bitField0_ |= 0x20000;
                }
                if ((from_bitField0_ & 0x40000) != 0) {
                    result.totalAmountMicros_ = this.totalAmountMicros_;
                    to_bitField0_ |= 0x40000;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AccountSummary) {
                    return this.mergeFrom((AccountSummary)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AccountSummary other) {
                if (other == AccountSummary.getDefaultInstance()) {
                    return this;
                }
                if (other.hasCustomer()) {
                    this.customer_ = other.customer_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.hasBillingCorrectionSubtotalAmountMicros()) {
                    this.setBillingCorrectionSubtotalAmountMicros(other.getBillingCorrectionSubtotalAmountMicros());
                }
                if (other.hasBillingCorrectionTaxAmountMicros()) {
                    this.setBillingCorrectionTaxAmountMicros(other.getBillingCorrectionTaxAmountMicros());
                }
                if (other.hasBillingCorrectionTotalAmountMicros()) {
                    this.setBillingCorrectionTotalAmountMicros(other.getBillingCorrectionTotalAmountMicros());
                }
                if (other.hasCouponAdjustmentSubtotalAmountMicros()) {
                    this.setCouponAdjustmentSubtotalAmountMicros(other.getCouponAdjustmentSubtotalAmountMicros());
                }
                if (other.hasCouponAdjustmentTaxAmountMicros()) {
                    this.setCouponAdjustmentTaxAmountMicros(other.getCouponAdjustmentTaxAmountMicros());
                }
                if (other.hasCouponAdjustmentTotalAmountMicros()) {
                    this.setCouponAdjustmentTotalAmountMicros(other.getCouponAdjustmentTotalAmountMicros());
                }
                if (other.hasExcessCreditAdjustmentSubtotalAmountMicros()) {
                    this.setExcessCreditAdjustmentSubtotalAmountMicros(other.getExcessCreditAdjustmentSubtotalAmountMicros());
                }
                if (other.hasExcessCreditAdjustmentTaxAmountMicros()) {
                    this.setExcessCreditAdjustmentTaxAmountMicros(other.getExcessCreditAdjustmentTaxAmountMicros());
                }
                if (other.hasExcessCreditAdjustmentTotalAmountMicros()) {
                    this.setExcessCreditAdjustmentTotalAmountMicros(other.getExcessCreditAdjustmentTotalAmountMicros());
                }
                if (other.hasRegulatoryCostsSubtotalAmountMicros()) {
                    this.setRegulatoryCostsSubtotalAmountMicros(other.getRegulatoryCostsSubtotalAmountMicros());
                }
                if (other.hasRegulatoryCostsTaxAmountMicros()) {
                    this.setRegulatoryCostsTaxAmountMicros(other.getRegulatoryCostsTaxAmountMicros());
                }
                if (other.hasRegulatoryCostsTotalAmountMicros()) {
                    this.setRegulatoryCostsTotalAmountMicros(other.getRegulatoryCostsTotalAmountMicros());
                }
                if (other.hasExportChargeSubtotalAmountMicros()) {
                    this.setExportChargeSubtotalAmountMicros(other.getExportChargeSubtotalAmountMicros());
                }
                if (other.hasExportChargeTaxAmountMicros()) {
                    this.setExportChargeTaxAmountMicros(other.getExportChargeTaxAmountMicros());
                }
                if (other.hasExportChargeTotalAmountMicros()) {
                    this.setExportChargeTotalAmountMicros(other.getExportChargeTotalAmountMicros());
                }
                if (other.hasSubtotalAmountMicros()) {
                    this.setSubtotalAmountMicros(other.getSubtotalAmountMicros());
                }
                if (other.hasTaxAmountMicros()) {
                    this.setTaxAmountMicros(other.getTaxAmountMicros());
                }
                if (other.hasTotalAmountMicros()) {
                    this.setTotalAmountMicros(other.getTotalAmountMicros());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block27: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block27;
                            }
                            case 10: {
                                this.customer_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block27;
                            }
                            case 16: {
                                this.billingCorrectionSubtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 2;
                                continue block27;
                            }
                            case 24: {
                                this.billingCorrectionTaxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 4;
                                continue block27;
                            }
                            case 32: {
                                this.billingCorrectionTotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 8;
                                continue block27;
                            }
                            case 40: {
                                this.couponAdjustmentSubtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x10;
                                continue block27;
                            }
                            case 48: {
                                this.couponAdjustmentTaxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x20;
                                continue block27;
                            }
                            case 56: {
                                this.couponAdjustmentTotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x40;
                                continue block27;
                            }
                            case 64: {
                                this.excessCreditAdjustmentSubtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x80;
                                continue block27;
                            }
                            case 72: {
                                this.excessCreditAdjustmentTaxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x100;
                                continue block27;
                            }
                            case 80: {
                                this.excessCreditAdjustmentTotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x200;
                                continue block27;
                            }
                            case 88: {
                                this.regulatoryCostsSubtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x400;
                                continue block27;
                            }
                            case 96: {
                                this.regulatoryCostsTaxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x800;
                                continue block27;
                            }
                            case 104: {
                                this.regulatoryCostsTotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x1000;
                                continue block27;
                            }
                            case 112: {
                                this.subtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x10000;
                                continue block27;
                            }
                            case 120: {
                                this.taxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x20000;
                                continue block27;
                            }
                            case 128: {
                                this.totalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x40000;
                                continue block27;
                            }
                            case 136: {
                                this.exportChargeSubtotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x2000;
                                continue block27;
                            }
                            case 144: {
                                this.exportChargeTaxAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x4000;
                                continue block27;
                            }
                            case 152: {
                                this.exportChargeTotalAmountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x8000;
                                continue block27;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasCustomer() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getCustomer() {
                Object ref = this.customer_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.customer_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getCustomerBytes() {
                Object ref = this.customer_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.customer_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setCustomer(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.customer_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearCustomer() {
                this.customer_ = AccountSummary.getDefaultInstance().getCustomer();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setCustomerBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AccountSummary.checkByteStringIsUtf8((ByteString)value);
                this.customer_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBillingCorrectionSubtotalAmountMicros() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public long getBillingCorrectionSubtotalAmountMicros() {
                return this.billingCorrectionSubtotalAmountMicros_;
            }

            public Builder setBillingCorrectionSubtotalAmountMicros(long value) {
                this.billingCorrectionSubtotalAmountMicros_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearBillingCorrectionSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.billingCorrectionSubtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBillingCorrectionTaxAmountMicros() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public long getBillingCorrectionTaxAmountMicros() {
                return this.billingCorrectionTaxAmountMicros_;
            }

            public Builder setBillingCorrectionTaxAmountMicros(long value) {
                this.billingCorrectionTaxAmountMicros_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearBillingCorrectionTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.billingCorrectionTaxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBillingCorrectionTotalAmountMicros() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public long getBillingCorrectionTotalAmountMicros() {
                return this.billingCorrectionTotalAmountMicros_;
            }

            public Builder setBillingCorrectionTotalAmountMicros(long value) {
                this.billingCorrectionTotalAmountMicros_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearBillingCorrectionTotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.billingCorrectionTotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasCouponAdjustmentSubtotalAmountMicros() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public long getCouponAdjustmentSubtotalAmountMicros() {
                return this.couponAdjustmentSubtotalAmountMicros_;
            }

            public Builder setCouponAdjustmentSubtotalAmountMicros(long value) {
                this.couponAdjustmentSubtotalAmountMicros_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearCouponAdjustmentSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.couponAdjustmentSubtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasCouponAdjustmentTaxAmountMicros() {
                return (this.bitField0_ & 0x20) != 0;
            }

            @Override
            public long getCouponAdjustmentTaxAmountMicros() {
                return this.couponAdjustmentTaxAmountMicros_;
            }

            public Builder setCouponAdjustmentTaxAmountMicros(long value) {
                this.couponAdjustmentTaxAmountMicros_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearCouponAdjustmentTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.couponAdjustmentTaxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasCouponAdjustmentTotalAmountMicros() {
                return (this.bitField0_ & 0x40) != 0;
            }

            @Override
            public long getCouponAdjustmentTotalAmountMicros() {
                return this.couponAdjustmentTotalAmountMicros_;
            }

            public Builder setCouponAdjustmentTotalAmountMicros(long value) {
                this.couponAdjustmentTotalAmountMicros_ = value;
                this.bitField0_ |= 0x40;
                this.onChanged();
                return this;
            }

            public Builder clearCouponAdjustmentTotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFFBF;
                this.couponAdjustmentTotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExcessCreditAdjustmentSubtotalAmountMicros() {
                return (this.bitField0_ & 0x80) != 0;
            }

            @Override
            public long getExcessCreditAdjustmentSubtotalAmountMicros() {
                return this.excessCreditAdjustmentSubtotalAmountMicros_;
            }

            public Builder setExcessCreditAdjustmentSubtotalAmountMicros(long value) {
                this.excessCreditAdjustmentSubtotalAmountMicros_ = value;
                this.bitField0_ |= 0x80;
                this.onChanged();
                return this;
            }

            public Builder clearExcessCreditAdjustmentSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFF7F;
                this.excessCreditAdjustmentSubtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExcessCreditAdjustmentTaxAmountMicros() {
                return (this.bitField0_ & 0x100) != 0;
            }

            @Override
            public long getExcessCreditAdjustmentTaxAmountMicros() {
                return this.excessCreditAdjustmentTaxAmountMicros_;
            }

            public Builder setExcessCreditAdjustmentTaxAmountMicros(long value) {
                this.excessCreditAdjustmentTaxAmountMicros_ = value;
                this.bitField0_ |= 0x100;
                this.onChanged();
                return this;
            }

            public Builder clearExcessCreditAdjustmentTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFFEFF;
                this.excessCreditAdjustmentTaxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExcessCreditAdjustmentTotalAmountMicros() {
                return (this.bitField0_ & 0x200) != 0;
            }

            @Override
            public long getExcessCreditAdjustmentTotalAmountMicros() {
                return this.excessCreditAdjustmentTotalAmountMicros_;
            }

            public Builder setExcessCreditAdjustmentTotalAmountMicros(long value) {
                this.excessCreditAdjustmentTotalAmountMicros_ = value;
                this.bitField0_ |= 0x200;
                this.onChanged();
                return this;
            }

            public Builder clearExcessCreditAdjustmentTotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFDFF;
                this.excessCreditAdjustmentTotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRegulatoryCostsSubtotalAmountMicros() {
                return (this.bitField0_ & 0x400) != 0;
            }

            @Override
            public long getRegulatoryCostsSubtotalAmountMicros() {
                return this.regulatoryCostsSubtotalAmountMicros_;
            }

            public Builder setRegulatoryCostsSubtotalAmountMicros(long value) {
                this.regulatoryCostsSubtotalAmountMicros_ = value;
                this.bitField0_ |= 0x400;
                this.onChanged();
                return this;
            }

            public Builder clearRegulatoryCostsSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFFBFF;
                this.regulatoryCostsSubtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRegulatoryCostsTaxAmountMicros() {
                return (this.bitField0_ & 0x800) != 0;
            }

            @Override
            public long getRegulatoryCostsTaxAmountMicros() {
                return this.regulatoryCostsTaxAmountMicros_;
            }

            public Builder setRegulatoryCostsTaxAmountMicros(long value) {
                this.regulatoryCostsTaxAmountMicros_ = value;
                this.bitField0_ |= 0x800;
                this.onChanged();
                return this;
            }

            public Builder clearRegulatoryCostsTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFF7FF;
                this.regulatoryCostsTaxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasRegulatoryCostsTotalAmountMicros() {
                return (this.bitField0_ & 0x1000) != 0;
            }

            @Override
            public long getRegulatoryCostsTotalAmountMicros() {
                return this.regulatoryCostsTotalAmountMicros_;
            }

            public Builder setRegulatoryCostsTotalAmountMicros(long value) {
                this.regulatoryCostsTotalAmountMicros_ = value;
                this.bitField0_ |= 0x1000;
                this.onChanged();
                return this;
            }

            public Builder clearRegulatoryCostsTotalAmountMicros() {
                this.bitField0_ &= 0xFFFFEFFF;
                this.regulatoryCostsTotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExportChargeSubtotalAmountMicros() {
                return (this.bitField0_ & 0x2000) != 0;
            }

            @Override
            public long getExportChargeSubtotalAmountMicros() {
                return this.exportChargeSubtotalAmountMicros_;
            }

            public Builder setExportChargeSubtotalAmountMicros(long value) {
                this.exportChargeSubtotalAmountMicros_ = value;
                this.bitField0_ |= 0x2000;
                this.onChanged();
                return this;
            }

            public Builder clearExportChargeSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFFDFFF;
                this.exportChargeSubtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExportChargeTaxAmountMicros() {
                return (this.bitField0_ & 0x4000) != 0;
            }

            @Override
            public long getExportChargeTaxAmountMicros() {
                return this.exportChargeTaxAmountMicros_;
            }

            public Builder setExportChargeTaxAmountMicros(long value) {
                this.exportChargeTaxAmountMicros_ = value;
                this.bitField0_ |= 0x4000;
                this.onChanged();
                return this;
            }

            public Builder clearExportChargeTaxAmountMicros() {
                this.bitField0_ &= 0xFFFFBFFF;
                this.exportChargeTaxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasExportChargeTotalAmountMicros() {
                return (this.bitField0_ & 0x8000) != 0;
            }

            @Override
            public long getExportChargeTotalAmountMicros() {
                return this.exportChargeTotalAmountMicros_;
            }

            public Builder setExportChargeTotalAmountMicros(long value) {
                this.exportChargeTotalAmountMicros_ = value;
                this.bitField0_ |= 0x8000;
                this.onChanged();
                return this;
            }

            public Builder clearExportChargeTotalAmountMicros() {
                this.bitField0_ &= 0xFFFF7FFF;
                this.exportChargeTotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasSubtotalAmountMicros() {
                return (this.bitField0_ & 0x10000) != 0;
            }

            @Override
            public long getSubtotalAmountMicros() {
                return this.subtotalAmountMicros_;
            }

            public Builder setSubtotalAmountMicros(long value) {
                this.subtotalAmountMicros_ = value;
                this.bitField0_ |= 0x10000;
                this.onChanged();
                return this;
            }

            public Builder clearSubtotalAmountMicros() {
                this.bitField0_ &= 0xFFFEFFFF;
                this.subtotalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTaxAmountMicros() {
                return (this.bitField0_ & 0x20000) != 0;
            }

            @Override
            public long getTaxAmountMicros() {
                return this.taxAmountMicros_;
            }

            public Builder setTaxAmountMicros(long value) {
                this.taxAmountMicros_ = value;
                this.bitField0_ |= 0x20000;
                this.onChanged();
                return this;
            }

            public Builder clearTaxAmountMicros() {
                this.bitField0_ &= 0xFFFDFFFF;
                this.taxAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasTotalAmountMicros() {
                return (this.bitField0_ & 0x40000) != 0;
            }

            @Override
            public long getTotalAmountMicros() {
                return this.totalAmountMicros_;
            }

            public Builder setTotalAmountMicros(long value) {
                this.totalAmountMicros_ = value;
                this.bitField0_ |= 0x40000;
                this.onChanged();
                return this;
            }

            public Builder clearTotalAmountMicros() {
                this.bitField0_ &= 0xFFFBFFFF;
                this.totalAmountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AccountSummaryOrBuilder
    extends MessageOrBuilder {
        public boolean hasCustomer();

        public String getCustomer();

        public ByteString getCustomerBytes();

        public boolean hasBillingCorrectionSubtotalAmountMicros();

        public long getBillingCorrectionSubtotalAmountMicros();

        public boolean hasBillingCorrectionTaxAmountMicros();

        public long getBillingCorrectionTaxAmountMicros();

        public boolean hasBillingCorrectionTotalAmountMicros();

        public long getBillingCorrectionTotalAmountMicros();

        public boolean hasCouponAdjustmentSubtotalAmountMicros();

        public long getCouponAdjustmentSubtotalAmountMicros();

        public boolean hasCouponAdjustmentTaxAmountMicros();

        public long getCouponAdjustmentTaxAmountMicros();

        public boolean hasCouponAdjustmentTotalAmountMicros();

        public long getCouponAdjustmentTotalAmountMicros();

        public boolean hasExcessCreditAdjustmentSubtotalAmountMicros();

        public long getExcessCreditAdjustmentSubtotalAmountMicros();

        public boolean hasExcessCreditAdjustmentTaxAmountMicros();

        public long getExcessCreditAdjustmentTaxAmountMicros();

        public boolean hasExcessCreditAdjustmentTotalAmountMicros();

        public long getExcessCreditAdjustmentTotalAmountMicros();

        public boolean hasRegulatoryCostsSubtotalAmountMicros();

        public long getRegulatoryCostsSubtotalAmountMicros();

        public boolean hasRegulatoryCostsTaxAmountMicros();

        public long getRegulatoryCostsTaxAmountMicros();

        public boolean hasRegulatoryCostsTotalAmountMicros();

        public long getRegulatoryCostsTotalAmountMicros();

        public boolean hasExportChargeSubtotalAmountMicros();

        public long getExportChargeSubtotalAmountMicros();

        public boolean hasExportChargeTaxAmountMicros();

        public long getExportChargeTaxAmountMicros();

        public boolean hasExportChargeTotalAmountMicros();

        public long getExportChargeTotalAmountMicros();

        public boolean hasSubtotalAmountMicros();

        public long getSubtotalAmountMicros();

        public boolean hasTaxAmountMicros();

        public long getTaxAmountMicros();

        public boolean hasTotalAmountMicros();

        public long getTotalAmountMicros();
    }

    public static final class InvalidActivitySummary
    extends GeneratedMessageV3
    implements InvalidActivitySummaryOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int ORIGINAL_MONTH_OF_SERVICE_FIELD_NUMBER = 1;
        private int originalMonthOfService_ = 0;
        public static final int ORIGINAL_YEAR_OF_SERVICE_FIELD_NUMBER = 2;
        private volatile Object originalYearOfService_ = "";
        public static final int ORIGINAL_INVOICE_ID_FIELD_NUMBER = 3;
        private volatile Object originalInvoiceId_ = "";
        public static final int ORIGINAL_ACCOUNT_BUDGET_NAME_FIELD_NUMBER = 4;
        private volatile Object originalAccountBudgetName_ = "";
        public static final int ORIGINAL_PURCHASE_ORDER_NUMBER_FIELD_NUMBER = 5;
        private volatile Object originalPurchaseOrderNumber_ = "";
        public static final int AMOUNT_MICROS_FIELD_NUMBER = 6;
        private long amountMicros_ = 0L;
        private byte memoizedIsInitialized = (byte)-1;
        private static final InvalidActivitySummary DEFAULT_INSTANCE = new InvalidActivitySummary();
        private static final Parser<InvalidActivitySummary> PARSER = new AbstractParser<InvalidActivitySummary>(){

            public InvalidActivitySummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = InvalidActivitySummary.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private InvalidActivitySummary(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private InvalidActivitySummary() {
            this.originalMonthOfService_ = 0;
            this.originalYearOfService_ = "";
            this.originalInvoiceId_ = "";
            this.originalAccountBudgetName_ = "";
            this.originalPurchaseOrderNumber_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new InvalidActivitySummary();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_InvalidActivitySummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_InvalidActivitySummary_fieldAccessorTable.ensureFieldAccessorsInitialized(InvalidActivitySummary.class, Builder.class);
        }

        @Override
        public boolean hasOriginalMonthOfService() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getOriginalMonthOfServiceValue() {
            return this.originalMonthOfService_;
        }

        @Override
        public MonthOfYearEnum.MonthOfYear getOriginalMonthOfService() {
            MonthOfYearEnum.MonthOfYear result = MonthOfYearEnum.MonthOfYear.forNumber(this.originalMonthOfService_);
            return result == null ? MonthOfYearEnum.MonthOfYear.UNRECOGNIZED : result;
        }

        @Override
        public boolean hasOriginalYearOfService() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getOriginalYearOfService() {
            Object ref = this.originalYearOfService_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.originalYearOfService_ = s;
            return s;
        }

        @Override
        public ByteString getOriginalYearOfServiceBytes() {
            Object ref = this.originalYearOfService_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.originalYearOfService_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasOriginalInvoiceId() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getOriginalInvoiceId() {
            Object ref = this.originalInvoiceId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.originalInvoiceId_ = s;
            return s;
        }

        @Override
        public ByteString getOriginalInvoiceIdBytes() {
            Object ref = this.originalInvoiceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.originalInvoiceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasOriginalAccountBudgetName() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public String getOriginalAccountBudgetName() {
            Object ref = this.originalAccountBudgetName_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.originalAccountBudgetName_ = s;
            return s;
        }

        @Override
        public ByteString getOriginalAccountBudgetNameBytes() {
            Object ref = this.originalAccountBudgetName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.originalAccountBudgetName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasOriginalPurchaseOrderNumber() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public String getOriginalPurchaseOrderNumber() {
            Object ref = this.originalPurchaseOrderNumber_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.originalPurchaseOrderNumber_ = s;
            return s;
        }

        @Override
        public ByteString getOriginalPurchaseOrderNumberBytes() {
            Object ref = this.originalPurchaseOrderNumber_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.originalPurchaseOrderNumber_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasAmountMicros() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public long getAmountMicros() {
            return this.amountMicros_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeEnum(1, this.originalMonthOfService_);
            }
            if ((this.bitField0_ & 2) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.originalYearOfService_);
            }
            if ((this.bitField0_ & 4) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.originalInvoiceId_);
            }
            if ((this.bitField0_ & 8) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.originalAccountBudgetName_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.originalPurchaseOrderNumber_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                output.writeInt64(6, this.amountMicros_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeEnumSize((int)1, (int)this.originalMonthOfService_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.originalYearOfService_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.originalInvoiceId_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.originalAccountBudgetName_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.originalPurchaseOrderNumber_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                size += CodedOutputStream.computeInt64Size((int)6, (long)this.amountMicros_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof InvalidActivitySummary)) {
                return super.equals(obj);
            }
            InvalidActivitySummary other = (InvalidActivitySummary)obj;
            if (this.hasOriginalMonthOfService() != other.hasOriginalMonthOfService()) {
                return false;
            }
            if (this.hasOriginalMonthOfService() && this.originalMonthOfService_ != other.originalMonthOfService_) {
                return false;
            }
            if (this.hasOriginalYearOfService() != other.hasOriginalYearOfService()) {
                return false;
            }
            if (this.hasOriginalYearOfService() && !this.getOriginalYearOfService().equals(other.getOriginalYearOfService())) {
                return false;
            }
            if (this.hasOriginalInvoiceId() != other.hasOriginalInvoiceId()) {
                return false;
            }
            if (this.hasOriginalInvoiceId() && !this.getOriginalInvoiceId().equals(other.getOriginalInvoiceId())) {
                return false;
            }
            if (this.hasOriginalAccountBudgetName() != other.hasOriginalAccountBudgetName()) {
                return false;
            }
            if (this.hasOriginalAccountBudgetName() && !this.getOriginalAccountBudgetName().equals(other.getOriginalAccountBudgetName())) {
                return false;
            }
            if (this.hasOriginalPurchaseOrderNumber() != other.hasOriginalPurchaseOrderNumber()) {
                return false;
            }
            if (this.hasOriginalPurchaseOrderNumber() && !this.getOriginalPurchaseOrderNumber().equals(other.getOriginalPurchaseOrderNumber())) {
                return false;
            }
            if (this.hasAmountMicros() != other.hasAmountMicros()) {
                return false;
            }
            if (this.hasAmountMicros() && this.getAmountMicros() != other.getAmountMicros()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + InvalidActivitySummary.getDescriptor().hashCode();
            if (this.hasOriginalMonthOfService()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.originalMonthOfService_;
            }
            if (this.hasOriginalYearOfService()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getOriginalYearOfService().hashCode();
            }
            if (this.hasOriginalInvoiceId()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getOriginalInvoiceId().hashCode();
            }
            if (this.hasOriginalAccountBudgetName()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getOriginalAccountBudgetName().hashCode();
            }
            if (this.hasOriginalPurchaseOrderNumber()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getOriginalPurchaseOrderNumber().hashCode();
            }
            if (this.hasAmountMicros()) {
                hash = 37 * hash + 6;
                hash = 53 * hash + Internal.hashLong((long)this.getAmountMicros());
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static InvalidActivitySummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data);
        }

        public static InvalidActivitySummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InvalidActivitySummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data);
        }

        public static InvalidActivitySummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InvalidActivitySummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data);
        }

        public static InvalidActivitySummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (InvalidActivitySummary)PARSER.parseFrom(data, extensionRegistry);
        }

        public static InvalidActivitySummary parseFrom(InputStream input) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static InvalidActivitySummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InvalidActivitySummary parseDelimitedFrom(InputStream input) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static InvalidActivitySummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static InvalidActivitySummary parseFrom(CodedInputStream input) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static InvalidActivitySummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (InvalidActivitySummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return InvalidActivitySummary.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(InvalidActivitySummary prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static InvalidActivitySummary getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<InvalidActivitySummary> parser() {
            return PARSER;
        }

        public Parser<InvalidActivitySummary> getParserForType() {
            return PARSER;
        }

        public InvalidActivitySummary getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements InvalidActivitySummaryOrBuilder {
            private int bitField0_;
            private int originalMonthOfService_ = 0;
            private Object originalYearOfService_ = "";
            private Object originalInvoiceId_ = "";
            private Object originalAccountBudgetName_ = "";
            private Object originalPurchaseOrderNumber_ = "";
            private long amountMicros_;

            public static final Descriptors.Descriptor getDescriptor() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_InvalidActivitySummary_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_InvalidActivitySummary_fieldAccessorTable.ensureFieldAccessorsInitialized(InvalidActivitySummary.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.originalMonthOfService_ = 0;
                this.originalYearOfService_ = "";
                this.originalInvoiceId_ = "";
                this.originalAccountBudgetName_ = "";
                this.originalPurchaseOrderNumber_ = "";
                this.amountMicros_ = 0L;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return InvoiceProto.internal_static_google_ads_googleads_v20_resources_Invoice_InvalidActivitySummary_descriptor;
            }

            public InvalidActivitySummary getDefaultInstanceForType() {
                return InvalidActivitySummary.getDefaultInstance();
            }

            public InvalidActivitySummary build() {
                InvalidActivitySummary result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public InvalidActivitySummary buildPartial() {
                InvalidActivitySummary result = new InvalidActivitySummary(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(InvalidActivitySummary result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.originalMonthOfService_ = this.originalMonthOfService_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.originalYearOfService_ = this.originalYearOfService_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.originalInvoiceId_ = this.originalInvoiceId_;
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.originalAccountBudgetName_ = this.originalAccountBudgetName_;
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.originalPurchaseOrderNumber_ = this.originalPurchaseOrderNumber_;
                    to_bitField0_ |= 0x10;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.amountMicros_ = this.amountMicros_;
                    to_bitField0_ |= 0x20;
                }
                result.bitField0_ |= to_bitField0_;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof InvalidActivitySummary) {
                    return this.mergeFrom((InvalidActivitySummary)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(InvalidActivitySummary other) {
                if (other == InvalidActivitySummary.getDefaultInstance()) {
                    return this;
                }
                if (other.hasOriginalMonthOfService()) {
                    this.setOriginalMonthOfService(other.getOriginalMonthOfService());
                }
                if (other.hasOriginalYearOfService()) {
                    this.originalYearOfService_ = other.originalYearOfService_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (other.hasOriginalInvoiceId()) {
                    this.originalInvoiceId_ = other.originalInvoiceId_;
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                if (other.hasOriginalAccountBudgetName()) {
                    this.originalAccountBudgetName_ = other.originalAccountBudgetName_;
                    this.bitField0_ |= 8;
                    this.onChanged();
                }
                if (other.hasOriginalPurchaseOrderNumber()) {
                    this.originalPurchaseOrderNumber_ = other.originalPurchaseOrderNumber_;
                    this.bitField0_ |= 0x10;
                    this.onChanged();
                }
                if (other.hasAmountMicros()) {
                    this.setAmountMicros(other.getAmountMicros());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 8: {
                                this.originalMonthOfService_ = input.readEnum();
                                this.bitField0_ |= 1;
                                continue block14;
                            }
                            case 18: {
                                this.originalYearOfService_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 26: {
                                this.originalInvoiceId_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 4;
                                continue block14;
                            }
                            case 34: {
                                this.originalAccountBudgetName_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 8;
                                continue block14;
                            }
                            case 42: {
                                this.originalPurchaseOrderNumber_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 0x10;
                                continue block14;
                            }
                            case 48: {
                                this.amountMicros_ = input.readInt64();
                                this.bitField0_ |= 0x20;
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasOriginalMonthOfService() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getOriginalMonthOfServiceValue() {
                return this.originalMonthOfService_;
            }

            public Builder setOriginalMonthOfServiceValue(int value) {
                this.originalMonthOfService_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public MonthOfYearEnum.MonthOfYear getOriginalMonthOfService() {
                MonthOfYearEnum.MonthOfYear result = MonthOfYearEnum.MonthOfYear.forNumber(this.originalMonthOfService_);
                return result == null ? MonthOfYearEnum.MonthOfYear.UNRECOGNIZED : result;
            }

            public Builder setOriginalMonthOfService(MonthOfYearEnum.MonthOfYear value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.originalMonthOfService_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearOriginalMonthOfService() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.originalMonthOfService_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOriginalYearOfService() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public String getOriginalYearOfService() {
                Object ref = this.originalYearOfService_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.originalYearOfService_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getOriginalYearOfServiceBytes() {
                Object ref = this.originalYearOfService_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.originalYearOfService_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setOriginalYearOfService(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.originalYearOfService_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearOriginalYearOfService() {
                this.originalYearOfService_ = InvalidActivitySummary.getDefaultInstance().getOriginalYearOfService();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setOriginalYearOfServiceBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InvalidActivitySummary.checkByteStringIsUtf8((ByteString)value);
                this.originalYearOfService_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOriginalInvoiceId() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public String getOriginalInvoiceId() {
                Object ref = this.originalInvoiceId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.originalInvoiceId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getOriginalInvoiceIdBytes() {
                Object ref = this.originalInvoiceId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.originalInvoiceId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setOriginalInvoiceId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.originalInvoiceId_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearOriginalInvoiceId() {
                this.originalInvoiceId_ = InvalidActivitySummary.getDefaultInstance().getOriginalInvoiceId();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder setOriginalInvoiceIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InvalidActivitySummary.checkByteStringIsUtf8((ByteString)value);
                this.originalInvoiceId_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOriginalAccountBudgetName() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public String getOriginalAccountBudgetName() {
                Object ref = this.originalAccountBudgetName_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.originalAccountBudgetName_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getOriginalAccountBudgetNameBytes() {
                Object ref = this.originalAccountBudgetName_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.originalAccountBudgetName_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setOriginalAccountBudgetName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.originalAccountBudgetName_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearOriginalAccountBudgetName() {
                this.originalAccountBudgetName_ = InvalidActivitySummary.getDefaultInstance().getOriginalAccountBudgetName();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder setOriginalAccountBudgetNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InvalidActivitySummary.checkByteStringIsUtf8((ByteString)value);
                this.originalAccountBudgetName_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasOriginalPurchaseOrderNumber() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public String getOriginalPurchaseOrderNumber() {
                Object ref = this.originalPurchaseOrderNumber_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.originalPurchaseOrderNumber_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getOriginalPurchaseOrderNumberBytes() {
                Object ref = this.originalPurchaseOrderNumber_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.originalPurchaseOrderNumber_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setOriginalPurchaseOrderNumber(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.originalPurchaseOrderNumber_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearOriginalPurchaseOrderNumber() {
                this.originalPurchaseOrderNumber_ = InvalidActivitySummary.getDefaultInstance().getOriginalPurchaseOrderNumber();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
                return this;
            }

            public Builder setOriginalPurchaseOrderNumberBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                InvalidActivitySummary.checkByteStringIsUtf8((ByteString)value);
                this.originalPurchaseOrderNumber_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasAmountMicros() {
                return (this.bitField0_ & 0x20) != 0;
            }

            @Override
            public long getAmountMicros() {
                return this.amountMicros_;
            }

            public Builder setAmountMicros(long value) {
                this.amountMicros_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearAmountMicros() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.amountMicros_ = 0L;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface InvalidActivitySummaryOrBuilder
    extends MessageOrBuilder {
        public boolean hasOriginalMonthOfService();

        public int getOriginalMonthOfServiceValue();

        public MonthOfYearEnum.MonthOfYear getOriginalMonthOfService();

        public boolean hasOriginalYearOfService();

        public String getOriginalYearOfService();

        public ByteString getOriginalYearOfServiceBytes();

        public boolean hasOriginalInvoiceId();

        public String getOriginalInvoiceId();

        public ByteString getOriginalInvoiceIdBytes();

        public boolean hasOriginalAccountBudgetName();

        public String getOriginalAccountBudgetName();

        public ByteString getOriginalAccountBudgetNameBytes();

        public boolean hasOriginalPurchaseOrderNumber();

        public String getOriginalPurchaseOrderNumber();

        public ByteString getOriginalPurchaseOrderNumberBytes();

        public boolean hasAmountMicros();

        public long getAmountMicros();
    }
}

