/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PaymentsAccountName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PAYMENTS_ACCOUNT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/paymentsAccounts/{payments_account_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String paymentsAccountId;

    @Deprecated
    protected PaymentsAccountName() {
        this.customerId = null;
        this.paymentsAccountId = null;
    }

    private PaymentsAccountName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.paymentsAccountId = (String)Preconditions.checkNotNull((Object)builder.getPaymentsAccountId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPaymentsAccountId() {
        return this.paymentsAccountId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PaymentsAccountName of(String customerId, String paymentsAccountId) {
        return PaymentsAccountName.newBuilder().setCustomerId(customerId).setPaymentsAccountId(paymentsAccountId).build();
    }

    public static String format(String customerId, String paymentsAccountId) {
        return PaymentsAccountName.newBuilder().setCustomerId(customerId).setPaymentsAccountId(paymentsAccountId).build().toString();
    }

    public static PaymentsAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PAYMENTS_ACCOUNT_ID.validatedMatch(formattedString, "PaymentsAccountName.parse: formattedString not in valid format");
        return PaymentsAccountName.of((String)matchMap.get("customer_id"), (String)matchMap.get("payments_account_id"));
    }

    public static List<PaymentsAccountName> parseList(List<String> formattedStrings) {
        ArrayList<PaymentsAccountName> list = new ArrayList<PaymentsAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PaymentsAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PaymentsAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PaymentsAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PAYMENTS_ACCOUNT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PaymentsAccountName paymentsAccountName = this;
            synchronized (paymentsAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.paymentsAccountId != null) {
                        fieldMapBuilder.put((Object)"payments_account_id", (Object)this.paymentsAccountId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PAYMENTS_ACCOUNT_ID.instantiate(new String[]{"customer_id", this.customerId, "payments_account_id", this.paymentsAccountId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PaymentsAccountName that = (PaymentsAccountName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.paymentsAccountId, that.paymentsAccountId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.paymentsAccountId);
    }

    public static class Builder {
        private String customerId;
        private String paymentsAccountId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getPaymentsAccountId() {
            return this.paymentsAccountId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setPaymentsAccountId(String paymentsAccountId) {
            this.paymentsAccountId = paymentsAccountId;
            return this;
        }

        private Builder(PaymentsAccountName paymentsAccountName) {
            this.customerId = paymentsAccountName.customerId;
            this.paymentsAccountId = paymentsAccountName.paymentsAccountId;
        }

        public PaymentsAccountName build() {
            return new PaymentsAccountName(this);
        }
    }
}

