/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProductGroupViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ADGROUP_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/productGroupViews/{adgroup_id}~{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adgroupId;
    private final String criterionId;

    @Deprecated
    protected ProductGroupViewName() {
        this.customerId = null;
        this.adgroupId = null;
        this.criterionId = null;
    }

    private ProductGroupViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adgroupId = (String)Preconditions.checkNotNull((Object)builder.getAdgroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdgroupId() {
        return this.adgroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProductGroupViewName of(String customerId, String adgroupId, String criterionId) {
        return ProductGroupViewName.newBuilder().setCustomerId(customerId).setAdgroupId(adgroupId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String adgroupId, String criterionId) {
        return ProductGroupViewName.newBuilder().setCustomerId(customerId).setAdgroupId(adgroupId).setCriterionId(criterionId).build().toString();
    }

    public static ProductGroupViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ADGROUP_ID_CRITERION_ID.validatedMatch(formattedString, "ProductGroupViewName.parse: formattedString not in valid format");
        return ProductGroupViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("adgroup_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<ProductGroupViewName> parseList(List<String> formattedStrings) {
        ArrayList<ProductGroupViewName> list = new ArrayList<ProductGroupViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProductGroupViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProductGroupViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProductGroupViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ADGROUP_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProductGroupViewName productGroupViewName = this;
            synchronized (productGroupViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adgroupId != null) {
                        fieldMapBuilder.put((Object)"adgroup_id", (Object)this.adgroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ADGROUP_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "adgroup_id", this.adgroupId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProductGroupViewName that = (ProductGroupViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adgroupId, that.adgroupId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adgroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String adgroupId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdgroupId() {
            return this.adgroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdgroupId(String adgroupId) {
            this.adgroupId = adgroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(ProductGroupViewName productGroupViewName) {
            this.customerId = productGroupViewName.customerId;
            this.adgroupId = productGroupViewName.adgroupId;
            this.criterionId = productGroupViewName.criterionId;
        }

        public ProductGroupViewName build() {
            return new ProductGroupViewName(this);
        }
    }
}

