/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.enums.IdentityVerificationProgramEnum;
import com.google.ads.googleads.v20.services.GetIdentityVerificationRequest;
import com.google.ads.googleads.v20.services.GetIdentityVerificationResponse;
import com.google.ads.googleads.v20.services.IdentityVerificationServiceSettings;
import com.google.ads.googleads.v20.services.StartIdentityVerificationRequest;
import com.google.ads.googleads.v20.services.stub.IdentityVerificationServiceStub;
import com.google.ads.googleads.v20.services.stub.IdentityVerificationServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class IdentityVerificationServiceClient
implements BackgroundResource {
    private final IdentityVerificationServiceSettings settings;
    private final IdentityVerificationServiceStub stub;

    public static final IdentityVerificationServiceClient create() throws IOException {
        return IdentityVerificationServiceClient.create(IdentityVerificationServiceSettings.newBuilder().build());
    }

    public static final IdentityVerificationServiceClient create(IdentityVerificationServiceSettings settings) throws IOException {
        return new IdentityVerificationServiceClient(settings);
    }

    public static final IdentityVerificationServiceClient create(IdentityVerificationServiceStub stub) {
        return new IdentityVerificationServiceClient(stub);
    }

    protected IdentityVerificationServiceClient(IdentityVerificationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IdentityVerificationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected IdentityVerificationServiceClient(IdentityVerificationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final IdentityVerificationServiceSettings getSettings() {
        return this.settings;
    }

    public IdentityVerificationServiceStub getStub() {
        return this.stub;
    }

    public final void startIdentityVerification(String customerId, IdentityVerificationProgramEnum.IdentityVerificationProgram verificationProgram) {
        StartIdentityVerificationRequest request = StartIdentityVerificationRequest.newBuilder().setCustomerId(customerId).setVerificationProgram(verificationProgram).build();
        this.startIdentityVerification(request);
    }

    public final void startIdentityVerification(StartIdentityVerificationRequest request) {
        this.startIdentityVerificationCallable().call((Object)request);
    }

    public final UnaryCallable<StartIdentityVerificationRequest, Empty> startIdentityVerificationCallable() {
        return this.stub.startIdentityVerificationCallable();
    }

    public final GetIdentityVerificationResponse getIdentityVerification(String customerId) {
        GetIdentityVerificationRequest request = GetIdentityVerificationRequest.newBuilder().setCustomerId(customerId).build();
        return this.getIdentityVerification(request);
    }

    public final GetIdentityVerificationResponse getIdentityVerification(GetIdentityVerificationRequest request) {
        return (GetIdentityVerificationResponse)this.getIdentityVerificationCallable().call((Object)request);
    }

    public final UnaryCallable<GetIdentityVerificationRequest, GetIdentityVerificationResponse> getIdentityVerificationCallable() {
        return this.stub.getIdentityVerificationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

