/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v20.services;

import com.google.ads.googleads.v20.services.GenerateShareablePreviewsRequest;
import com.google.ads.googleads.v20.services.GenerateShareablePreviewsResponse;
import com.google.ads.googleads.v20.services.ShareablePreview;
import com.google.ads.googleads.v20.services.ShareablePreviewServiceSettings;
import com.google.ads.googleads.v20.services.stub.ShareablePreviewServiceStub;
import com.google.ads.googleads.v20.services.stub.ShareablePreviewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ShareablePreviewServiceClient
implements BackgroundResource {
    private final ShareablePreviewServiceSettings settings;
    private final ShareablePreviewServiceStub stub;

    public static final ShareablePreviewServiceClient create() throws IOException {
        return ShareablePreviewServiceClient.create(ShareablePreviewServiceSettings.newBuilder().build());
    }

    public static final ShareablePreviewServiceClient create(ShareablePreviewServiceSettings settings) throws IOException {
        return new ShareablePreviewServiceClient(settings);
    }

    public static final ShareablePreviewServiceClient create(ShareablePreviewServiceStub stub) {
        return new ShareablePreviewServiceClient(stub);
    }

    protected ShareablePreviewServiceClient(ShareablePreviewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ShareablePreviewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ShareablePreviewServiceClient(ShareablePreviewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ShareablePreviewServiceSettings getSettings() {
        return this.settings;
    }

    public ShareablePreviewServiceStub getStub() {
        return this.stub;
    }

    public final GenerateShareablePreviewsResponse generateShareablePreviews(String customerId, List<ShareablePreview> shareablePreviews) {
        GenerateShareablePreviewsRequest request = GenerateShareablePreviewsRequest.newBuilder().setCustomerId(customerId).addAllShareablePreviews(shareablePreviews).build();
        return this.generateShareablePreviews(request);
    }

    public final GenerateShareablePreviewsResponse generateShareablePreviews(GenerateShareablePreviewsRequest request) {
        return (GenerateShareablePreviewsResponse)this.generateShareablePreviewsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateShareablePreviewsRequest, GenerateShareablePreviewsResponse> generateShareablePreviewsCallable() {
        return this.stub.generateShareablePreviewsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

