/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetGroupTopCombinationViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_GROUP_ID_ASSET_COMBINATION_CATEGORY = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetGroupTopCombinationViews/{asset_group_id}~{asset_combination_category}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetGroupId;
    private final String assetCombinationCategory;

    @Deprecated
    protected AssetGroupTopCombinationViewName() {
        this.customerId = null;
        this.assetGroupId = null;
        this.assetCombinationCategory = null;
    }

    private AssetGroupTopCombinationViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetGroupId = (String)Preconditions.checkNotNull((Object)builder.getAssetGroupId());
        this.assetCombinationCategory = (String)Preconditions.checkNotNull((Object)builder.getAssetCombinationCategory());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public String getAssetCombinationCategory() {
        return this.assetCombinationCategory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetGroupTopCombinationViewName of(String customerId, String assetGroupId, String assetCombinationCategory) {
        return AssetGroupTopCombinationViewName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setAssetCombinationCategory(assetCombinationCategory).build();
    }

    public static String format(String customerId, String assetGroupId, String assetCombinationCategory) {
        return AssetGroupTopCombinationViewName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setAssetCombinationCategory(assetCombinationCategory).build().toString();
    }

    public static AssetGroupTopCombinationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_GROUP_ID_ASSET_COMBINATION_CATEGORY.validatedMatch(formattedString, "AssetGroupTopCombinationViewName.parse: formattedString not in valid format");
        return AssetGroupTopCombinationViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_group_id"), (String)matchMap.get("asset_combination_category"));
    }

    public static List<AssetGroupTopCombinationViewName> parseList(List<String> formattedStrings) {
        ArrayList<AssetGroupTopCombinationViewName> list = new ArrayList<AssetGroupTopCombinationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetGroupTopCombinationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetGroupTopCombinationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetGroupTopCombinationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_GROUP_ID_ASSET_COMBINATION_CATEGORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetGroupTopCombinationViewName assetGroupTopCombinationViewName = this;
            synchronized (assetGroupTopCombinationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetGroupId != null) {
                        fieldMapBuilder.put((Object)"asset_group_id", (Object)this.assetGroupId);
                    }
                    if (this.assetCombinationCategory != null) {
                        fieldMapBuilder.put((Object)"asset_combination_category", (Object)this.assetCombinationCategory);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_GROUP_ID_ASSET_COMBINATION_CATEGORY.instantiate(new String[]{"customer_id", this.customerId, "asset_group_id", this.assetGroupId, "asset_combination_category", this.assetCombinationCategory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetGroupTopCombinationViewName that = (AssetGroupTopCombinationViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetGroupId, that.assetGroupId) && Objects.equals(this.assetCombinationCategory, that.assetCombinationCategory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetCombinationCategory);
    }

    public static class Builder {
        private String customerId;
        private String assetGroupId;
        private String assetCombinationCategory;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetGroupId() {
            return this.assetGroupId;
        }

        public String getAssetCombinationCategory() {
            return this.assetCombinationCategory;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetGroupId(String assetGroupId) {
            this.assetGroupId = assetGroupId;
            return this;
        }

        public Builder setAssetCombinationCategory(String assetCombinationCategory) {
            this.assetCombinationCategory = assetCombinationCategory;
            return this;
        }

        private Builder(AssetGroupTopCombinationViewName assetGroupTopCombinationViewName) {
            this.customerId = assetGroupTopCombinationViewName.customerId;
            this.assetGroupId = assetGroupTopCombinationViewName.assetGroupId;
            this.assetCombinationCategory = assetGroupTopCombinationViewName.assetCombinationCategory;
        }

        public AssetGroupTopCombinationViewName build() {
            return new AssetGroupTopCombinationViewName(this);
        }
    }
}

