/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelAggregateAssetViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ADVERTISING_CHANNEL_TYPE_ASSET_ID_ASSET_SOURCE_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/channelAggregateAssetViews/{advertising_channel_type}~{asset_id}~{asset_source}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String advertisingChannelType;
    private final String assetId;
    private final String assetSource;
    private final String fieldType;

    @Deprecated
    protected ChannelAggregateAssetViewName() {
        this.customerId = null;
        this.advertisingChannelType = null;
        this.assetId = null;
        this.assetSource = null;
        this.fieldType = null;
    }

    private ChannelAggregateAssetViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.advertisingChannelType = (String)Preconditions.checkNotNull((Object)builder.getAdvertisingChannelType());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.assetSource = (String)Preconditions.checkNotNull((Object)builder.getAssetSource());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdvertisingChannelType() {
        return this.advertisingChannelType;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getAssetSource() {
        return this.assetSource;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelAggregateAssetViewName of(String customerId, String advertisingChannelType, String assetId, String assetSource, String fieldType) {
        return ChannelAggregateAssetViewName.newBuilder().setCustomerId(customerId).setAdvertisingChannelType(advertisingChannelType).setAssetId(assetId).setAssetSource(assetSource).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String advertisingChannelType, String assetId, String assetSource, String fieldType) {
        return ChannelAggregateAssetViewName.newBuilder().setCustomerId(customerId).setAdvertisingChannelType(advertisingChannelType).setAssetId(assetId).setAssetSource(assetSource).setFieldType(fieldType).build().toString();
    }

    public static ChannelAggregateAssetViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ADVERTISING_CHANNEL_TYPE_ASSET_ID_ASSET_SOURCE_FIELD_TYPE.validatedMatch(formattedString, "ChannelAggregateAssetViewName.parse: formattedString not in valid format");
        return ChannelAggregateAssetViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("advertising_channel_type"), (String)matchMap.get("asset_id"), (String)matchMap.get("asset_source"), (String)matchMap.get("field_type"));
    }

    public static List<ChannelAggregateAssetViewName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelAggregateAssetViewName> list = new ArrayList<ChannelAggregateAssetViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelAggregateAssetViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelAggregateAssetViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelAggregateAssetViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ADVERTISING_CHANNEL_TYPE_ASSET_ID_ASSET_SOURCE_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelAggregateAssetViewName channelAggregateAssetViewName = this;
            synchronized (channelAggregateAssetViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.advertisingChannelType != null) {
                        fieldMapBuilder.put((Object)"advertising_channel_type", (Object)this.advertisingChannelType);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.assetSource != null) {
                        fieldMapBuilder.put((Object)"asset_source", (Object)this.assetSource);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ADVERTISING_CHANNEL_TYPE_ASSET_ID_ASSET_SOURCE_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "advertising_channel_type", this.advertisingChannelType, "asset_id", this.assetId, "asset_source", this.assetSource, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ChannelAggregateAssetViewName that = (ChannelAggregateAssetViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.advertisingChannelType, that.advertisingChannelType) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.assetSource, that.assetSource) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.advertisingChannelType);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetSource);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String advertisingChannelType;
        private String assetId;
        private String assetSource;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdvertisingChannelType() {
            return this.advertisingChannelType;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getAssetSource() {
            return this.assetSource;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdvertisingChannelType(String advertisingChannelType) {
            this.advertisingChannelType = advertisingChannelType;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setAssetSource(String assetSource) {
            this.assetSource = assetSource;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(ChannelAggregateAssetViewName channelAggregateAssetViewName) {
            this.customerId = channelAggregateAssetViewName.customerId;
            this.advertisingChannelType = channelAggregateAssetViewName.advertisingChannelType;
            this.assetId = channelAggregateAssetViewName.assetId;
            this.assetSource = channelAggregateAssetViewName.assetSource;
            this.fieldType = channelAggregateAssetViewName.fieldType;
        }

        public ChannelAggregateAssetViewName build() {
            return new ChannelAggregateAssetViewName(this);
        }
    }
}

