/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocalServicesVerificationArtifactName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_GLS_VERIFICATION_ARTIFACT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/localServicesVerificationArtifacts/{gls_verification_artifact_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String glsVerificationArtifactId;

    @Deprecated
    protected LocalServicesVerificationArtifactName() {
        this.customerId = null;
        this.glsVerificationArtifactId = null;
    }

    private LocalServicesVerificationArtifactName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.glsVerificationArtifactId = (String)Preconditions.checkNotNull((Object)builder.getGlsVerificationArtifactId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getGlsVerificationArtifactId() {
        return this.glsVerificationArtifactId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocalServicesVerificationArtifactName of(String customerId, String glsVerificationArtifactId) {
        return LocalServicesVerificationArtifactName.newBuilder().setCustomerId(customerId).setGlsVerificationArtifactId(glsVerificationArtifactId).build();
    }

    public static String format(String customerId, String glsVerificationArtifactId) {
        return LocalServicesVerificationArtifactName.newBuilder().setCustomerId(customerId).setGlsVerificationArtifactId(glsVerificationArtifactId).build().toString();
    }

    public static LocalServicesVerificationArtifactName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_GLS_VERIFICATION_ARTIFACT_ID.validatedMatch(formattedString, "LocalServicesVerificationArtifactName.parse: formattedString not in valid format");
        return LocalServicesVerificationArtifactName.of((String)matchMap.get("customer_id"), (String)matchMap.get("gls_verification_artifact_id"));
    }

    public static List<LocalServicesVerificationArtifactName> parseList(List<String> formattedStrings) {
        ArrayList<LocalServicesVerificationArtifactName> list = new ArrayList<LocalServicesVerificationArtifactName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocalServicesVerificationArtifactName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocalServicesVerificationArtifactName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocalServicesVerificationArtifactName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_GLS_VERIFICATION_ARTIFACT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocalServicesVerificationArtifactName localServicesVerificationArtifactName = this;
            synchronized (localServicesVerificationArtifactName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.glsVerificationArtifactId != null) {
                        fieldMapBuilder.put((Object)"gls_verification_artifact_id", (Object)this.glsVerificationArtifactId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_GLS_VERIFICATION_ARTIFACT_ID.instantiate(new String[]{"customer_id", this.customerId, "gls_verification_artifact_id", this.glsVerificationArtifactId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocalServicesVerificationArtifactName that = (LocalServicesVerificationArtifactName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.glsVerificationArtifactId, that.glsVerificationArtifactId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glsVerificationArtifactId);
    }

    public static class Builder {
        private String customerId;
        private String glsVerificationArtifactId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getGlsVerificationArtifactId() {
            return this.glsVerificationArtifactId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setGlsVerificationArtifactId(String glsVerificationArtifactId) {
            this.glsVerificationArtifactId = glsVerificationArtifactId;
            return this;
        }

        private Builder(LocalServicesVerificationArtifactName localServicesVerificationArtifactName) {
            this.customerId = localServicesVerificationArtifactName.customerId;
            this.glsVerificationArtifactId = localServicesVerificationArtifactName.glsVerificationArtifactId;
        }

        public LocalServicesVerificationArtifactName build() {
            return new LocalServicesVerificationArtifactName(this);
        }
    }
}

