/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v21.services.stub;

import com.google.ads.googleads.v21.services.CreateProductLinkRequest;
import com.google.ads.googleads.v21.services.CreateProductLinkResponse;
import com.google.ads.googleads.v21.services.RemoveProductLinkRequest;
import com.google.ads.googleads.v21.services.RemoveProductLinkResponse;
import com.google.ads.googleads.v21.services.stub.GrpcProductLinkServiceCallableFactory;
import com.google.ads.googleads.v21.services.stub.ProductLinkServiceStub;
import com.google.ads.googleads.v21.services.stub.ProductLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcProductLinkServiceStub
extends ProductLinkServiceStub {
    private static final MethodDescriptor<CreateProductLinkRequest, CreateProductLinkResponse> createProductLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.ProductLinkService/CreateProductLink").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProductLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateProductLinkResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemoveProductLinkRequest, RemoveProductLinkResponse> removeProductLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v21.services.ProductLinkService/RemoveProductLink").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveProductLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RemoveProductLinkResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateProductLinkRequest, CreateProductLinkResponse> createProductLinkCallable;
    private final UnaryCallable<RemoveProductLinkRequest, RemoveProductLinkResponse> removeProductLinkCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProductLinkServiceStub create(ProductLinkServiceStubSettings settings) throws IOException {
        return new GrpcProductLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProductLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProductLinkServiceStub(ProductLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProductLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProductLinkServiceStub(ProductLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProductLinkServiceStub(ProductLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcProductLinkServiceCallableFactory());
    }

    protected GrpcProductLinkServiceStub(ProductLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createProductLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProductLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings removeProductLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeProductLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.createProductLinkCallable = callableFactory.createUnaryCallable(createProductLinkTransportSettings, settings.createProductLinkSettings(), clientContext);
        this.removeProductLinkCallable = callableFactory.createUnaryCallable(removeProductLinkTransportSettings, settings.removeProductLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateProductLinkRequest, CreateProductLinkResponse> createProductLinkCallable() {
        return this.createProductLinkCallable;
    }

    @Override
    public UnaryCallable<RemoveProductLinkRequest, RemoveProductLinkResponse> removeProductLinkCallable() {
        return this.removeProductLinkCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

