/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupCriterionLabelName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_LABEL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupCriterionLabels/{ad_group_id}~{criterion_id}~{label_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String criterionId;
    private final String labelId;

    @Deprecated
    protected AdGroupCriterionLabelName() {
        this.customerId = null;
        this.adGroupId = null;
        this.criterionId = null;
        this.labelId = null;
    }

    private AdGroupCriterionLabelName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
        this.labelId = (String)Preconditions.checkNotNull((Object)builder.getLabelId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupCriterionLabelName of(String customerId, String adGroupId, String criterionId, String labelId) {
        return AdGroupCriterionLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setLabelId(labelId).build();
    }

    public static String format(String customerId, String adGroupId, String criterionId, String labelId) {
        return AdGroupCriterionLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).setLabelId(labelId).build().toString();
    }

    public static AdGroupCriterionLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_LABEL_ID.validatedMatch(formattedString, "AdGroupCriterionLabelName.parse: formattedString not in valid format");
        return AdGroupCriterionLabelName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("criterion_id"), (String)matchMap.get("label_id"));
    }

    public static List<AdGroupCriterionLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCriterionLabelName> list = new ArrayList<AdGroupCriterionLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCriterionLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCriterionLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCriterionLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_LABEL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCriterionLabelName adGroupCriterionLabelName = this;
            synchronized (adGroupCriterionLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    if (this.labelId != null) {
                        fieldMapBuilder.put((Object)"label_id", (Object)this.labelId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID_LABEL_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "criterion_id", this.criterionId, "label_id", this.labelId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupCriterionLabelName that = (AdGroupCriterionLabelName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.criterionId, that.criterionId) && Objects.equals(this.labelId, that.labelId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.criterionId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.labelId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String criterionId;
        private String labelId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        public Builder setLabelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        private Builder(AdGroupCriterionLabelName adGroupCriterionLabelName) {
            this.customerId = adGroupCriterionLabelName.customerId;
            this.adGroupId = adGroupCriterionLabelName.adGroupId;
            this.criterionId = adGroupCriterionLabelName.criterionId;
            this.labelId = adGroupCriterionLabelName.labelId;
        }

        public AdGroupCriterionLabelName build() {
            return new AdGroupCriterionLabelName(this);
        }
    }
}

