/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/ads/{ad_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adId;

    @Deprecated
    protected AdName() {
        this.customerId = null;
        this.adId = null;
    }

    private AdName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adId = (String)Preconditions.checkNotNull((Object)builder.getAdId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdId() {
        return this.adId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdName of(String customerId, String adId) {
        return AdName.newBuilder().setCustomerId(customerId).setAdId(adId).build();
    }

    public static String format(String customerId, String adId) {
        return AdName.newBuilder().setCustomerId(customerId).setAdId(adId).build().toString();
    }

    public static AdName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_ID.validatedMatch(formattedString, "AdName.parse: formattedString not in valid format");
        return AdName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_id"));
    }

    public static List<AdName> parseList(List<String> formattedStrings) {
        ArrayList<AdName> list = new ArrayList<AdName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdName adName = this;
            synchronized (adName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adId != null) {
                        fieldMapBuilder.put((Object)"ad_id", (Object)this.adId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_id", this.adId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdName that = (AdName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adId, that.adId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adId);
    }

    public static class Builder {
        private String customerId;
        private String adId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdId() {
            return this.adId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdId(String adId) {
            this.adId = adId;
            return this;
        }

        private Builder(AdName adName) {
            this.customerId = adName.customerId;
            this.adId = adName.adId;
        }

        public AdName build() {
            return new AdName(this);
        }
    }
}

