/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AiMaxSearchTermAdCombinationViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_LANDING_PAGE_HEADLINE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/aiMaxSearchTermAdCombinationViews/{ad_group_id}~{search_term}~{landing_page}~{headline}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String searchTerm;
    private final String landingPage;
    private final String headline;

    @Deprecated
    protected AiMaxSearchTermAdCombinationViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.searchTerm = null;
        this.landingPage = null;
        this.headline = null;
    }

    private AiMaxSearchTermAdCombinationViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.searchTerm = (String)Preconditions.checkNotNull((Object)builder.getSearchTerm());
        this.landingPage = (String)Preconditions.checkNotNull((Object)builder.getLandingPage());
        this.headline = (String)Preconditions.checkNotNull((Object)builder.getHeadline());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String getLandingPage() {
        return this.landingPage;
    }

    public String getHeadline() {
        return this.headline;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AiMaxSearchTermAdCombinationViewName of(String customerId, String adGroupId, String searchTerm, String landingPage, String headline) {
        return AiMaxSearchTermAdCombinationViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setSearchTerm(searchTerm).setLandingPage(landingPage).setHeadline(headline).build();
    }

    public static String format(String customerId, String adGroupId, String searchTerm, String landingPage, String headline) {
        return AiMaxSearchTermAdCombinationViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setSearchTerm(searchTerm).setLandingPage(landingPage).setHeadline(headline).build().toString();
    }

    public static AiMaxSearchTermAdCombinationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_LANDING_PAGE_HEADLINE.validatedMatch(formattedString, "AiMaxSearchTermAdCombinationViewName.parse: formattedString not in valid format");
        return AiMaxSearchTermAdCombinationViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("search_term"), (String)matchMap.get("landing_page"), (String)matchMap.get("headline"));
    }

    public static List<AiMaxSearchTermAdCombinationViewName> parseList(List<String> formattedStrings) {
        ArrayList<AiMaxSearchTermAdCombinationViewName> list = new ArrayList<AiMaxSearchTermAdCombinationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AiMaxSearchTermAdCombinationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AiMaxSearchTermAdCombinationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AiMaxSearchTermAdCombinationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_LANDING_PAGE_HEADLINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AiMaxSearchTermAdCombinationViewName aiMaxSearchTermAdCombinationViewName = this;
            synchronized (aiMaxSearchTermAdCombinationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.searchTerm != null) {
                        fieldMapBuilder.put((Object)"search_term", (Object)this.searchTerm);
                    }
                    if (this.landingPage != null) {
                        fieldMapBuilder.put((Object)"landing_page", (Object)this.landingPage);
                    }
                    if (this.headline != null) {
                        fieldMapBuilder.put((Object)"headline", (Object)this.headline);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_SEARCH_TERM_LANDING_PAGE_HEADLINE.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "search_term", this.searchTerm, "landing_page", this.landingPage, "headline", this.headline});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AiMaxSearchTermAdCombinationViewName that = (AiMaxSearchTermAdCombinationViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.searchTerm, that.searchTerm) && Objects.equals(this.landingPage, that.landingPage) && Objects.equals(this.headline, that.headline);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.searchTerm);
        h *= 1000003;
        h ^= Objects.hashCode(this.landingPage);
        h *= 1000003;
        return h ^= Objects.hashCode(this.headline);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String searchTerm;
        private String landingPage;
        private String headline;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getSearchTerm() {
            return this.searchTerm;
        }

        public String getLandingPage() {
            return this.landingPage;
        }

        public String getHeadline() {
            return this.headline;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setSearchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public Builder setLandingPage(String landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        public Builder setHeadline(String headline) {
            this.headline = headline;
            return this;
        }

        private Builder(AiMaxSearchTermAdCombinationViewName aiMaxSearchTermAdCombinationViewName) {
            this.customerId = aiMaxSearchTermAdCombinationViewName.customerId;
            this.adGroupId = aiMaxSearchTermAdCombinationViewName.adGroupId;
            this.searchTerm = aiMaxSearchTermAdCombinationViewName.searchTerm;
            this.landingPage = aiMaxSearchTermAdCombinationViewName.landingPage;
            this.headline = aiMaxSearchTermAdCombinationViewName.headline;
        }

        public AiMaxSearchTermAdCombinationViewName build() {
            return new AiMaxSearchTermAdCombinationViewName(this);
        }
    }
}

