/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AndroidPrivacySharedKeyGoogleNetworkTypeName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_NETWORK_TYPE_ANDROID_PRIVACY_INTERACTION_DATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/androidPrivacySharedKeyGoogleNetworkTypes/{campaign_id}~{android_privacy_interaction_type}~{android_privacy_network_type}~{android_privacy_interaction_date}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String androidPrivacyInteractionType;
    private final String androidPrivacyNetworkType;
    private final String androidPrivacyInteractionDate;

    @Deprecated
    protected AndroidPrivacySharedKeyGoogleNetworkTypeName() {
        this.customerId = null;
        this.campaignId = null;
        this.androidPrivacyInteractionType = null;
        this.androidPrivacyNetworkType = null;
        this.androidPrivacyInteractionDate = null;
    }

    private AndroidPrivacySharedKeyGoogleNetworkTypeName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.androidPrivacyInteractionType = (String)Preconditions.checkNotNull((Object)builder.getAndroidPrivacyInteractionType());
        this.androidPrivacyNetworkType = (String)Preconditions.checkNotNull((Object)builder.getAndroidPrivacyNetworkType());
        this.androidPrivacyInteractionDate = (String)Preconditions.checkNotNull((Object)builder.getAndroidPrivacyInteractionDate());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAndroidPrivacyInteractionType() {
        return this.androidPrivacyInteractionType;
    }

    public String getAndroidPrivacyNetworkType() {
        return this.androidPrivacyNetworkType;
    }

    public String getAndroidPrivacyInteractionDate() {
        return this.androidPrivacyInteractionDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AndroidPrivacySharedKeyGoogleNetworkTypeName of(String customerId, String campaignId, String androidPrivacyInteractionType, String androidPrivacyNetworkType, String androidPrivacyInteractionDate) {
        return AndroidPrivacySharedKeyGoogleNetworkTypeName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAndroidPrivacyInteractionType(androidPrivacyInteractionType).setAndroidPrivacyNetworkType(androidPrivacyNetworkType).setAndroidPrivacyInteractionDate(androidPrivacyInteractionDate).build();
    }

    public static String format(String customerId, String campaignId, String androidPrivacyInteractionType, String androidPrivacyNetworkType, String androidPrivacyInteractionDate) {
        return AndroidPrivacySharedKeyGoogleNetworkTypeName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAndroidPrivacyInteractionType(androidPrivacyInteractionType).setAndroidPrivacyNetworkType(androidPrivacyNetworkType).setAndroidPrivacyInteractionDate(androidPrivacyInteractionDate).build().toString();
    }

    public static AndroidPrivacySharedKeyGoogleNetworkTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_NETWORK_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.validatedMatch(formattedString, "AndroidPrivacySharedKeyGoogleNetworkTypeName.parse: formattedString not in valid format");
        return AndroidPrivacySharedKeyGoogleNetworkTypeName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("android_privacy_interaction_type"), (String)matchMap.get("android_privacy_network_type"), (String)matchMap.get("android_privacy_interaction_date"));
    }

    public static List<AndroidPrivacySharedKeyGoogleNetworkTypeName> parseList(List<String> formattedStrings) {
        ArrayList<AndroidPrivacySharedKeyGoogleNetworkTypeName> list = new ArrayList<AndroidPrivacySharedKeyGoogleNetworkTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AndroidPrivacySharedKeyGoogleNetworkTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AndroidPrivacySharedKeyGoogleNetworkTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AndroidPrivacySharedKeyGoogleNetworkTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_NETWORK_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AndroidPrivacySharedKeyGoogleNetworkTypeName androidPrivacySharedKeyGoogleNetworkTypeName = this;
            synchronized (androidPrivacySharedKeyGoogleNetworkTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.androidPrivacyInteractionType != null) {
                        fieldMapBuilder.put((Object)"android_privacy_interaction_type", (Object)this.androidPrivacyInteractionType);
                    }
                    if (this.androidPrivacyNetworkType != null) {
                        fieldMapBuilder.put((Object)"android_privacy_network_type", (Object)this.androidPrivacyNetworkType);
                    }
                    if (this.androidPrivacyInteractionDate != null) {
                        fieldMapBuilder.put((Object)"android_privacy_interaction_date", (Object)this.androidPrivacyInteractionDate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_ANDROID_PRIVACY_INTERACTION_TYPE_ANDROID_PRIVACY_NETWORK_TYPE_ANDROID_PRIVACY_INTERACTION_DATE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "android_privacy_interaction_type", this.androidPrivacyInteractionType, "android_privacy_network_type", this.androidPrivacyNetworkType, "android_privacy_interaction_date", this.androidPrivacyInteractionDate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AndroidPrivacySharedKeyGoogleNetworkTypeName that = (AndroidPrivacySharedKeyGoogleNetworkTypeName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.androidPrivacyInteractionType, that.androidPrivacyInteractionType) && Objects.equals(this.androidPrivacyNetworkType, that.androidPrivacyNetworkType) && Objects.equals(this.androidPrivacyInteractionDate, that.androidPrivacyInteractionDate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.androidPrivacyInteractionType);
        h *= 1000003;
        h ^= Objects.hashCode(this.androidPrivacyNetworkType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.androidPrivacyInteractionDate);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String androidPrivacyInteractionType;
        private String androidPrivacyNetworkType;
        private String androidPrivacyInteractionDate;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAndroidPrivacyInteractionType() {
            return this.androidPrivacyInteractionType;
        }

        public String getAndroidPrivacyNetworkType() {
            return this.androidPrivacyNetworkType;
        }

        public String getAndroidPrivacyInteractionDate() {
            return this.androidPrivacyInteractionDate;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAndroidPrivacyInteractionType(String androidPrivacyInteractionType) {
            this.androidPrivacyInteractionType = androidPrivacyInteractionType;
            return this;
        }

        public Builder setAndroidPrivacyNetworkType(String androidPrivacyNetworkType) {
            this.androidPrivacyNetworkType = androidPrivacyNetworkType;
            return this;
        }

        public Builder setAndroidPrivacyInteractionDate(String androidPrivacyInteractionDate) {
            this.androidPrivacyInteractionDate = androidPrivacyInteractionDate;
            return this;
        }

        private Builder(AndroidPrivacySharedKeyGoogleNetworkTypeName androidPrivacySharedKeyGoogleNetworkTypeName) {
            this.customerId = androidPrivacySharedKeyGoogleNetworkTypeName.customerId;
            this.campaignId = androidPrivacySharedKeyGoogleNetworkTypeName.campaignId;
            this.androidPrivacyInteractionType = androidPrivacySharedKeyGoogleNetworkTypeName.androidPrivacyInteractionType;
            this.androidPrivacyNetworkType = androidPrivacySharedKeyGoogleNetworkTypeName.androidPrivacyNetworkType;
            this.androidPrivacyInteractionDate = androidPrivacySharedKeyGoogleNetworkTypeName.androidPrivacyInteractionDate;
        }

        public AndroidPrivacySharedKeyGoogleNetworkTypeName build() {
            return new AndroidPrivacySharedKeyGoogleNetworkTypeName(this);
        }
    }
}

