/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignGoalConfigName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_UNIFIED_GOAL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignGoalConfigs/{campaign_id}~{unified_goal_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String unifiedGoalId;

    @Deprecated
    protected CampaignGoalConfigName() {
        this.customerId = null;
        this.campaignId = null;
        this.unifiedGoalId = null;
    }

    private CampaignGoalConfigName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.unifiedGoalId = (String)Preconditions.checkNotNull((Object)builder.getUnifiedGoalId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getUnifiedGoalId() {
        return this.unifiedGoalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignGoalConfigName of(String customerId, String campaignId, String unifiedGoalId) {
        return CampaignGoalConfigName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setUnifiedGoalId(unifiedGoalId).build();
    }

    public static String format(String customerId, String campaignId, String unifiedGoalId) {
        return CampaignGoalConfigName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setUnifiedGoalId(unifiedGoalId).build().toString();
    }

    public static CampaignGoalConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_UNIFIED_GOAL_ID.validatedMatch(formattedString, "CampaignGoalConfigName.parse: formattedString not in valid format");
        return CampaignGoalConfigName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("unified_goal_id"));
    }

    public static List<CampaignGoalConfigName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignGoalConfigName> list = new ArrayList<CampaignGoalConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignGoalConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignGoalConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignGoalConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_UNIFIED_GOAL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignGoalConfigName campaignGoalConfigName = this;
            synchronized (campaignGoalConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.unifiedGoalId != null) {
                        fieldMapBuilder.put((Object)"unified_goal_id", (Object)this.unifiedGoalId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_UNIFIED_GOAL_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "unified_goal_id", this.unifiedGoalId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignGoalConfigName that = (CampaignGoalConfigName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.unifiedGoalId, that.unifiedGoalId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unifiedGoalId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String unifiedGoalId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getUnifiedGoalId() {
            return this.unifiedGoalId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setUnifiedGoalId(String unifiedGoalId) {
            this.unifiedGoalId = unifiedGoalId;
            return this;
        }

        private Builder(CampaignGoalConfigName campaignGoalConfigName) {
            this.customerId = campaignGoalConfigName.customerId;
            this.campaignId = campaignGoalConfigName.campaignId;
            this.unifiedGoalId = campaignGoalConfigName.unifiedGoalId;
        }

        public CampaignGoalConfigName build() {
            return new CampaignGoalConfigName(this);
        }
    }
}

