/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CarrierConstantName
implements ResourceName {
    private static final PathTemplate CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"carrierConstants/{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String criterionId;

    @Deprecated
    protected CarrierConstantName() {
        this.criterionId = null;
    }

    private CarrierConstantName(Builder builder) {
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CarrierConstantName of(String criterionId) {
        return CarrierConstantName.newBuilder().setCriterionId(criterionId).build();
    }

    public static String format(String criterionId) {
        return CarrierConstantName.newBuilder().setCriterionId(criterionId).build().toString();
    }

    public static CarrierConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CRITERION_ID.validatedMatch(formattedString, "CarrierConstantName.parse: formattedString not in valid format");
        return CarrierConstantName.of((String)matchMap.get("criterion_id"));
    }

    public static List<CarrierConstantName> parseList(List<String> formattedStrings) {
        ArrayList<CarrierConstantName> list = new ArrayList<CarrierConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CarrierConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CarrierConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CarrierConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CarrierConstantName carrierConstantName = this;
            synchronized (carrierConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CRITERION_ID.instantiate(new String[]{"criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CarrierConstantName that = (CarrierConstantName)o;
            return Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String criterionId;

        protected Builder() {
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(CarrierConstantName carrierConstantName) {
            this.criterionId = carrierConstantName.criterionId;
        }

        public CarrierConstantName build() {
            return new CarrierConstantName(this);
        }
    }
}

