/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerSearchTermInsightName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CLUSTER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerSearchTermInsights/{cluster_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String clusterId;

    @Deprecated
    protected CustomerSearchTermInsightName() {
        this.customerId = null;
        this.clusterId = null;
    }

    private CustomerSearchTermInsightName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.clusterId = (String)Preconditions.checkNotNull((Object)builder.getClusterId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerSearchTermInsightName of(String customerId, String clusterId) {
        return CustomerSearchTermInsightName.newBuilder().setCustomerId(customerId).setClusterId(clusterId).build();
    }

    public static String format(String customerId, String clusterId) {
        return CustomerSearchTermInsightName.newBuilder().setCustomerId(customerId).setClusterId(clusterId).build().toString();
    }

    public static CustomerSearchTermInsightName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CLUSTER_ID.validatedMatch(formattedString, "CustomerSearchTermInsightName.parse: formattedString not in valid format");
        return CustomerSearchTermInsightName.of((String)matchMap.get("customer_id"), (String)matchMap.get("cluster_id"));
    }

    public static List<CustomerSearchTermInsightName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerSearchTermInsightName> list = new ArrayList<CustomerSearchTermInsightName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerSearchTermInsightName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerSearchTermInsightName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerSearchTermInsightName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CLUSTER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerSearchTermInsightName customerSearchTermInsightName = this;
            synchronized (customerSearchTermInsightName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.clusterId != null) {
                        fieldMapBuilder.put((Object)"cluster_id", (Object)this.clusterId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CLUSTER_ID.instantiate(new String[]{"customer_id", this.customerId, "cluster_id", this.clusterId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerSearchTermInsightName that = (CustomerSearchTermInsightName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.clusterId, that.clusterId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clusterId);
    }

    public static class Builder {
        private String customerId;
        private String clusterId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        private Builder(CustomerSearchTermInsightName customerSearchTermInsightName) {
            this.customerId = customerSearchTermInsightName.customerId;
            this.clusterId = customerSearchTermInsightName.clusterId;
        }

        public CustomerSearchTermInsightName build() {
            return new CustomerSearchTermInsightName(this);
        }
    }
}

