/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FinalUrlExpansionAssetViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE_URL_FP = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/finalUrlExpansionAssetViews/{campaign_id}~{asset_id}~{field_type}~{url_fp}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String assetId;
    private final String fieldType;
    private final String urlFp;

    @Deprecated
    protected FinalUrlExpansionAssetViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.assetId = null;
        this.fieldType = null;
        this.urlFp = null;
    }

    private FinalUrlExpansionAssetViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
        this.urlFp = (String)Preconditions.checkNotNull((Object)builder.getUrlFp());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getUrlFp() {
        return this.urlFp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FinalUrlExpansionAssetViewName of(String customerId, String campaignId, String assetId, String fieldType, String urlFp) {
        return FinalUrlExpansionAssetViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setFieldType(fieldType).setUrlFp(urlFp).build();
    }

    public static String format(String customerId, String campaignId, String assetId, String fieldType, String urlFp) {
        return FinalUrlExpansionAssetViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setFieldType(fieldType).setUrlFp(urlFp).build().toString();
    }

    public static FinalUrlExpansionAssetViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE_URL_FP.validatedMatch(formattedString, "FinalUrlExpansionAssetViewName.parse: formattedString not in valid format");
        return FinalUrlExpansionAssetViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("field_type"), (String)matchMap.get("url_fp"));
    }

    public static List<FinalUrlExpansionAssetViewName> parseList(List<String> formattedStrings) {
        ArrayList<FinalUrlExpansionAssetViewName> list = new ArrayList<FinalUrlExpansionAssetViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FinalUrlExpansionAssetViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FinalUrlExpansionAssetViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FinalUrlExpansionAssetViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE_URL_FP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FinalUrlExpansionAssetViewName finalUrlExpansionAssetViewName = this;
            synchronized (finalUrlExpansionAssetViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    if (this.urlFp != null) {
                        fieldMapBuilder.put((Object)"url_fp", (Object)this.urlFp);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE_URL_FP.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "asset_id", this.assetId, "field_type", this.fieldType, "url_fp", this.urlFp});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FinalUrlExpansionAssetViewName that = (FinalUrlExpansionAssetViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.fieldType, that.fieldType) && Objects.equals(this.urlFp, that.urlFp);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        h ^= Objects.hashCode(this.fieldType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.urlFp);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String assetId;
        private String fieldType;
        private String urlFp;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getUrlFp() {
            return this.urlFp;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder setUrlFp(String urlFp) {
            this.urlFp = urlFp;
            return this;
        }

        private Builder(FinalUrlExpansionAssetViewName finalUrlExpansionAssetViewName) {
            this.customerId = finalUrlExpansionAssetViewName.customerId;
            this.campaignId = finalUrlExpansionAssetViewName.campaignId;
            this.assetId = finalUrlExpansionAssetViewName.assetId;
            this.fieldType = finalUrlExpansionAssetViewName.fieldType;
            this.urlFp = finalUrlExpansionAssetViewName.urlFp;
        }

        public FinalUrlExpansionAssetViewName build() {
            return new FinalUrlExpansionAssetViewName(this);
        }
    }
}

