/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GoalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_UNIFIED_GOAL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/goals/{unified_goal_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String unifiedGoalId;

    @Deprecated
    protected GoalName() {
        this.customerId = null;
        this.unifiedGoalId = null;
    }

    private GoalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.unifiedGoalId = (String)Preconditions.checkNotNull((Object)builder.getUnifiedGoalId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUnifiedGoalId() {
        return this.unifiedGoalId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GoalName of(String customerId, String unifiedGoalId) {
        return GoalName.newBuilder().setCustomerId(customerId).setUnifiedGoalId(unifiedGoalId).build();
    }

    public static String format(String customerId, String unifiedGoalId) {
        return GoalName.newBuilder().setCustomerId(customerId).setUnifiedGoalId(unifiedGoalId).build().toString();
    }

    public static GoalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_UNIFIED_GOAL_ID.validatedMatch(formattedString, "GoalName.parse: formattedString not in valid format");
        return GoalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("unified_goal_id"));
    }

    public static List<GoalName> parseList(List<String> formattedStrings) {
        ArrayList<GoalName> list = new ArrayList<GoalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GoalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GoalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GoalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_UNIFIED_GOAL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GoalName goalName = this;
            synchronized (goalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.unifiedGoalId != null) {
                        fieldMapBuilder.put((Object)"unified_goal_id", (Object)this.unifiedGoalId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_UNIFIED_GOAL_ID.instantiate(new String[]{"customer_id", this.customerId, "unified_goal_id", this.unifiedGoalId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GoalName that = (GoalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.unifiedGoalId, that.unifiedGoalId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unifiedGoalId);
    }

    public static class Builder {
        private String customerId;
        private String unifiedGoalId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUnifiedGoalId() {
            return this.unifiedGoalId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUnifiedGoalId(String unifiedGoalId) {
            this.unifiedGoalId = unifiedGoalId;
            return this;
        }

        private Builder(GoalName goalName) {
            this.customerId = goalName.customerId;
            this.unifiedGoalId = goalName.unifiedGoalId;
        }

        public GoalName build() {
            return new GoalName(this);
        }
    }
}

