/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SmartCampaignSearchTermViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_QUERY = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/smartCampaignSearchTermViews/{campaign_id}~{query}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String query;

    @Deprecated
    protected SmartCampaignSearchTermViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.query = null;
    }

    private SmartCampaignSearchTermViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.query = (String)Preconditions.checkNotNull((Object)builder.getQuery());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getQuery() {
        return this.query;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SmartCampaignSearchTermViewName of(String customerId, String campaignId, String query) {
        return SmartCampaignSearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setQuery(query).build();
    }

    public static String format(String customerId, String campaignId, String query) {
        return SmartCampaignSearchTermViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setQuery(query).build().toString();
    }

    public static SmartCampaignSearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_QUERY.validatedMatch(formattedString, "SmartCampaignSearchTermViewName.parse: formattedString not in valid format");
        return SmartCampaignSearchTermViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("query"));
    }

    public static List<SmartCampaignSearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<SmartCampaignSearchTermViewName> list = new ArrayList<SmartCampaignSearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SmartCampaignSearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SmartCampaignSearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SmartCampaignSearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_QUERY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SmartCampaignSearchTermViewName smartCampaignSearchTermViewName = this;
            synchronized (smartCampaignSearchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.query != null) {
                        fieldMapBuilder.put((Object)"query", (Object)this.query);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_QUERY.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "query", this.query});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SmartCampaignSearchTermViewName that = (SmartCampaignSearchTermViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.query, that.query);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.query);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String query;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getQuery() {
            return this.query;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        private Builder(SmartCampaignSearchTermViewName smartCampaignSearchTermViewName) {
            this.customerId = smartCampaignSearchTermViewName.customerId;
            this.campaignId = smartCampaignSearchTermViewName.campaignId;
            this.query = smartCampaignSearchTermViewName.query;
        }

        public SmartCampaignSearchTermViewName build() {
            return new SmartCampaignSearchTermViewName(this);
        }
    }
}

