/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetingExpansionViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_TARGETING_EXPANSION_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/targetingExpansionViews/{campaign_id}~{targeting_expansion_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String targetingExpansionType;

    @Deprecated
    protected TargetingExpansionViewName() {
        this.customerId = null;
        this.campaignId = null;
        this.targetingExpansionType = null;
    }

    private TargetingExpansionViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.targetingExpansionType = (String)Preconditions.checkNotNull((Object)builder.getTargetingExpansionType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getTargetingExpansionType() {
        return this.targetingExpansionType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TargetingExpansionViewName of(String customerId, String campaignId, String targetingExpansionType) {
        return TargetingExpansionViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setTargetingExpansionType(targetingExpansionType).build();
    }

    public static String format(String customerId, String campaignId, String targetingExpansionType) {
        return TargetingExpansionViewName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setTargetingExpansionType(targetingExpansionType).build().toString();
    }

    public static TargetingExpansionViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_TARGETING_EXPANSION_TYPE.validatedMatch(formattedString, "TargetingExpansionViewName.parse: formattedString not in valid format");
        return TargetingExpansionViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("targeting_expansion_type"));
    }

    public static List<TargetingExpansionViewName> parseList(List<String> formattedStrings) {
        ArrayList<TargetingExpansionViewName> list = new ArrayList<TargetingExpansionViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TargetingExpansionViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TargetingExpansionViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TargetingExpansionViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_TARGETING_EXPANSION_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TargetingExpansionViewName targetingExpansionViewName = this;
            synchronized (targetingExpansionViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.targetingExpansionType != null) {
                        fieldMapBuilder.put((Object)"targeting_expansion_type", (Object)this.targetingExpansionType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_TARGETING_EXPANSION_TYPE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "targeting_expansion_type", this.targetingExpansionType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TargetingExpansionViewName that = (TargetingExpansionViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.targetingExpansionType, that.targetingExpansionType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.targetingExpansionType);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String targetingExpansionType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getTargetingExpansionType() {
            return this.targetingExpansionType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setTargetingExpansionType(String targetingExpansionType) {
            this.targetingExpansionType = targetingExpansionType;
            return this;
        }

        private Builder(TargetingExpansionViewName targetingExpansionViewName) {
            this.customerId = targetingExpansionViewName.customerId;
            this.campaignId = targetingExpansionViewName.campaignId;
            this.targetingExpansionType = targetingExpansionViewName.targetingExpansionType;
        }

        public TargetingExpansionViewName build() {
            return new TargetingExpansionViewName(this);
        }
    }
}

