/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v22.services;

import com.google.ads.googleads.v22.services.CustomAudienceOperation;
import com.google.ads.googleads.v22.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v22.services.MutateCustomAudiencesRequest;
import com.google.ads.googleads.v22.services.MutateCustomAudiencesResponse;
import com.google.ads.googleads.v22.services.stub.CustomAudienceServiceStub;
import com.google.ads.googleads.v22.services.stub.CustomAudienceServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomAudienceServiceClient
implements BackgroundResource {
    private final CustomAudienceServiceSettings settings;
    private final CustomAudienceServiceStub stub;

    public static final CustomAudienceServiceClient create() throws IOException {
        return CustomAudienceServiceClient.create(CustomAudienceServiceSettings.newBuilder().build());
    }

    public static final CustomAudienceServiceClient create(CustomAudienceServiceSettings settings) throws IOException {
        return new CustomAudienceServiceClient(settings);
    }

    public static final CustomAudienceServiceClient create(CustomAudienceServiceStub stub) {
        return new CustomAudienceServiceClient(stub);
    }

    protected CustomAudienceServiceClient(CustomAudienceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomAudienceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomAudienceServiceClient(CustomAudienceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomAudienceServiceSettings getSettings() {
        return this.settings;
    }

    public CustomAudienceServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomAudiencesResponse mutateCustomAudiences(String customerId, List<CustomAudienceOperation> operations) {
        MutateCustomAudiencesRequest request = MutateCustomAudiencesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomAudiences(request);
    }

    public final MutateCustomAudiencesResponse mutateCustomAudiences(MutateCustomAudiencesRequest request) {
        return (MutateCustomAudiencesResponse)this.mutateCustomAudiencesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomAudiencesRequest, MutateCustomAudiencesResponse> mutateCustomAudiencesCallable() {
        return this.stub.mutateCustomAudiencesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

